/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.picker;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.internal.TempHelper;
import com.ibm.team.filesystem.client.internal.snapshot.SnapshotId;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.changemodel.IPathResolver;
import com.ibm.team.filesystem.common.changemodel.VersionablePath;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.CopyFileAreaPathResolver;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.SnapshotPathResolver;
import com.ibm.team.filesystem.rcp.core.internal.resources.ResourceUtil;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.picker.BrowsableFilenameField;
import com.ibm.team.internal.filesystem.ui.picker.RepositoryFilesPicker;
import com.ibm.team.internal.filesystem.ui.picker.RepositoryFilesPickerInput;
import com.ibm.team.internal.filesystem.ui.picker.RepositoryFilesPickerOutput;
import com.ibm.team.internal.filesystem.ui.util.ShareablesUtil;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.internal.utils.SWTUtil;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.repository.rcp.ui.parts.WidgetToolkit;
import com.ibm.team.repository.rcp.ui.parts.impl.IPartResult;
import com.ibm.team.repository.rcp.ui.utils.MnemonicGenerator;
import com.ibm.team.repository.rcp.ui.utils.UIContext;
import com.ibm.team.repository.rcp.ui.utils.WidgetFactoryContext;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.internal.util.ItemId;
import com.ibm.team.scm.common.internal.util.SiloedItemId;
import java.util.Collections;
import java.util.Map;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;

public class VersionablePicker {
    private IOperationRunner background;
    private Button browseButton;
    private static final SiloedItemId<IVersionable> nullItem = SiloedItemId.create((ItemId)ItemId.getNullItem((IItemType)IFileItem.ITEM_TYPE), (ItemId)ItemId.getNullItem((IItemType)IComponent.ITEM_TYPE));
    private SiloedItemId<IVersionable> selectedVersionable = nullItem;
    private SnapshotId currentWorkspace;
    private Text textContent;
    private WritableValue validationStatus = new WritableValue();
    private Composite buttonBar;
    private Button clearButton;
    public static int FLAG_NONE = 0;

    public VersionablePicker(Composite parent, WidgetFactoryContext context, int flags) {
        this.validationStatus.setValue((Object)Status.OK_STATUS);
        WidgetToolkit toolkit = context.getToolkit();
        this.background = context.getBackgroundOperationRunner();
        MnemonicGenerator mg = context.getMnemonics();
        this.textContent = toolkit.createText(parent, "", 8);
        this.buttonBar = toolkit.createComposite(parent);
        this.browseButton = toolkit.createButton(this.buttonBar, mg.generate(Messages.VersionablePicker_1), 8);
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                VersionablePicker.this.doBrowse();
            }
        });
        this.clearButton = toolkit.createButton(this.buttonBar, mg.generate(Messages.VersionablePicker_2), 8);
        this.clearButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                VersionablePicker.this.doClear();
            }
        });
        Dialog.applyDialogFont((Control)this.buttonBar);
        GridLayoutFactory.fillDefaults().numColumns(this.buttonBar.getChildren().length).generateLayout(this.buttonBar);
        this.textContent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                VersionablePicker.this.onDispose();
            }
        });
        this.updatePath();
    }

    protected void doClear() {
        this.setItem(nullItem);
    }

    public void setWorkspace(SnapshotId namespace) {
        this.currentWorkspace = namespace;
        this.updatePath();
    }

    public void setItem(SiloedItemId<IVersionable> versionable) {
        this.selectedVersionable = versionable;
        this.updatePath();
    }

    public SiloedItemId<IVersionable> getSelection() {
        return this.selectedVersionable;
    }

    private void updatePath() {
        this.clearButton.setEnabled(!this.selectedVersionable.isNull());
        if (this.selectedVersionable.isNull()) {
            this.textContent.setText("");
            return;
        }
        Object resolver = null;
        resolver = this.currentWorkspace == null ? CopyFileAreaPathResolver.create() : SnapshotPathResolver.create((SnapshotId)this.currentWorkspace);
        Display d = Display.getCurrent();
        CopyFileAreaPathResolver finalResolver = resolver;
        this.background.enqueue(Messages.VersionablePicker_4, (Operation)new RepositoryOperation((IPathResolver)finalResolver, d){
            private final /* synthetic */ IPathResolver val$finalResolver;
            private final /* synthetic */ Display val$d;
            {
                this.val$finalResolver = iPathResolver;
                this.val$d = display;
            }

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, FileSystemException, OperationFailedException {
                SiloedItemId item = VersionablePicker.this.selectedVersionable;
                Map result = this.val$finalResolver.resolve(Collections.singleton(item), monitor);
                final VersionablePath path = (VersionablePath)result.get(item);
                SWTUtil.greedyExec((Display)this.val$d, (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (VersionablePicker.this.textContent.isDisposed()) {
                            return;
                        }
                        VersionablePicker.this.textContent.setText(path.toString());
                    }
                });
            }
        });
    }

    protected void onDispose() {
    }

    protected void doBrowse() {
        UIContext context = UIContext.createShellContext((Shell)this.browseButton.getShell());
        if (this.currentWorkspace == null) {
            String finalPath = BrowsableFilenameField.browseWorkspaceMustExist(context, 0, new ISelectionStatusValidator(){

                public IStatus validate(Object[] selection) {
                    int i = 0;
                    while (i < selection.length) {
                        Object next = selection[i];
                        if (next instanceof IResource) {
                            IResource resource = (IResource)next;
                            try {
                                SiloedItemId<IVersionable> item = ShareablesUtil.getSiloedItem(resource, (IProgressMonitor)TempHelper.MONITOR);
                                if (item.isNull()) {
                                    return StatusUtil.newStatus((Object)this, (int)4, (String)Messages.VersionablePicker_5);
                                }
                            }
                            catch (FileSystemException e) {
                                TempHelper.throwEx((TeamRepositoryException)((Object)e));
                            }
                        }
                        ++i;
                    }
                    return Status.OK_STATUS;
                }
            });
            if (finalPath != null) {
                IResource f = ResourceUtil.getResource((IPath)new Path(finalPath));
                try {
                    SiloedItemId<IVersionable> item = ShareablesUtil.getSiloedItem(f, (IProgressMonitor)TempHelper.MONITOR);
                    if (!item.isNull()) {
                        this.setItem(item);
                    }
                }
                catch (FileSystemException e) {
                    TempHelper.throwEx((TeamRepositoryException)((Object)e));
                }
            }
        } else {
            RepositoryFilesPickerInput input = new RepositoryFilesPickerInput(this.currentWorkspace, false, false, Messages.VersionablePicker_6, false, Collections.singleton(this.selectedVersionable), null);
            RepositoryFilesPicker.pickFolder(context.getShell(), input, new IPartResult<RepositoryFilesPickerOutput>(){

                public void setResult(RepositoryFilesPickerOutput result) {
                    if (!result.getItemIds().isEmpty()) {
                        VersionablePicker.this.setItem((SiloedItemId<IVersionable>)result.getItemIds().iterator().next());
                    }
                }
            });
        }
    }

    public IObservableValue getValidationStatus() {
        return this.validationStatus;
    }

    public Control getTextControl() {
        return this.textContent;
    }

    public void setEnabled(boolean enableChanges) {
        this.browseButton.setEnabled(enableChanges);
    }

    public Control getButtonControl() {
        return this.buttonBar;
    }
}

