/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.picker;

import com.ibm.team.filesystem.ui.framework.geometry.Units;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.picker.MultiContentProposalProvider;
import com.ibm.team.repository.rcp.ui.internal.viewers.SettableSelectionProvider;
import com.ibm.team.repository.rcp.ui.parts.WidgetToolkit;
import com.ibm.team.repository.rcp.ui.utils.WidgetFactoryContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.fieldassist.ContentAssistCommandAdapter;

public class TextControl
extends SettableSelectionProvider {
    private static final String DEFAULT_SEPARATOR = Messages.TextControl_0;
    private VerifyListener fStrictVerificationListener = new VerifyListener(){

        public void verifyText(VerifyEvent e) {
            TextControl.this.handleVerification(e);
        }
    };
    private ModifyListener fWarnModifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            TextControl.this.handleVerification(e);
        }
    };
    private Text fText;
    private Composite fTextContainer;
    private ControlDecoration fControlDecoration;
    private IValidator fValidator;
    private boolean fMultiSelection;
    private final ContentAssistCommandAdapter fContentAssistCommandAdapter;
    private final MultiContentProposalProvider fProposalProvider;
    private IStructuredContentProvider fContentProvider;
    private Object fInput;

    public TextControl(Composite parent, WidgetFactoryContext context, int style) {
        WidgetToolkit toolkit = context.getToolkit();
        this.fTextContainer = toolkit.createComposite(parent);
        GridLayoutFactory.fillDefaults().applyTo(this.fTextContainer);
        this.fText = toolkit.createText(this.fTextContainer, "", style);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.fText);
        this.fControlDecoration = new ControlDecoration((Control)this.fTextContainer, 0x1004000);
        this.fControlDecoration.hide();
        this.fControlDecoration.setShowHover(true);
        this.fProposalProvider = new MultiContentProposalProvider();
        this.fContentAssistCommandAdapter = new ContentAssistCommandAdapter((Control)this.fText, (IControlContentAdapter)new TextContentAdapter(), (IContentProposalProvider)this.fProposalProvider, null, new char[]{DEFAULT_SEPARATOR.charAt(0)}, true);
        this.fContentAssistCommandAdapter.setProposalAcceptanceStyle(2);
        this.fContentAssistCommandAdapter.setEnabled(false);
        this.useMultiSelection(true);
        this.installListeners();
    }

    public void setWidthHintInChars(int chars) {
        int widthInPixels = chars > 0 ? Units.getCharsToPixels().multiply((Point)new Point((int)chars, (int)0)).x : -1;
        GridDataFactory.fillDefaults().align(4, 0x1000000).hint(widthInPixels, -1).applyTo((Control)this.fText);
    }

    public Text getTextControl() {
        return this.fText;
    }

    public Composite getTextContainer() {
        return this.fTextContainer;
    }

    public void setValidator(IValidator validator, Options options) {
        this.fValidator = validator;
        this.fText.removeVerifyListener(this.fStrictVerificationListener);
        this.fText.removeModifyListener(this.fWarnModifyListener);
        if (options == Options.VERIFY_STRICT) {
            this.fText.addVerifyListener(this.fStrictVerificationListener);
        } else if (options == Options.VERIFY_WARN) {
            this.fText.addModifyListener(this.fWarnModifyListener);
        }
    }

    public boolean isInputValid() {
        if (this.fValidator == null) {
            return true;
        }
        return this.validate(this.fText.getText()).isOK();
    }

    public void useMultiSelection(boolean multi) {
        this.fMultiSelection = multi;
        this.fProposalProvider.setSeparator(this.fMultiSelection ? DEFAULT_SEPARATOR : null);
    }

    public void setContentProvider(IStructuredContentProvider contentProvider) {
        this.fContentProvider = contentProvider;
    }

    public void setInput(Object input) {
        if (this.fContentProvider != null) {
            this.fContentProvider.inputChanged(null, this.fInput, input);
            this.fInput = input;
            this.fProposalProvider.setProposals(this.createLabels());
            this.fContentAssistCommandAdapter.setEnabled(true);
        }
    }

    protected void handleVerification(VerifyEvent e) {
        if (this.fValidator != null) {
            String currentText = this.fText.getText();
            String newText = String.valueOf(currentText.substring(0, e.start)) + e.text + currentText.substring(e.end);
            IStatus status = this.validate(newText);
            if (!status.isOK()) {
                e.doit = false;
                this.fControlDecoration.showHoverText(status.getMessage());
            } else {
                this.fControlDecoration.hideHover();
            }
        }
    }

    protected void handleVerification(ModifyEvent e) {
        if (this.fValidator != null) {
            IStatus status = this.validate(this.fText.getText());
            this.showValidationStatus(status);
        }
    }

    public void setSelection(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            List<String> currentValues = this.getCurrentValues();
            if (currentValues.containsAll(structuredSelection.toList()) && structuredSelection.toList().containsAll(currentValues)) {
                return;
            }
            StringBuffer buffer = new StringBuffer();
            Iterator iterator = structuredSelection.toList().iterator();
            while (iterator.hasNext()) {
                buffer.append(iterator.next());
                if (!iterator.hasNext()) continue;
                buffer.append(DEFAULT_SEPARATOR);
                buffer.append(" ");
            }
            this.fText.setText(buffer.toString());
        }
    }

    private void installListeners() {
        this.fText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (TextControl.this.isInputValid()) {
                    TextControl.this.realSetSelection((ISelection)new StructuredSelection(TextControl.this.getCurrentValues()));
                }
            }
        });
    }

    private List<String> getCurrentValues() {
        return this.getValues(this.fText.getText());
    }

    private List<String> getValues(String text) {
        String[] rawValues;
        if (!this.fMultiSelection) {
            String trimmed = text.trim();
            return trimmed.length() > 0 ? Collections.singletonList(trimmed) : Collections.emptyList();
        }
        ArrayList<String> values = new ArrayList<String>();
        String[] stringArray = rawValues = text.split(DEFAULT_SEPARATOR);
        int n = rawValues.length;
        int n2 = 0;
        while (n2 < n) {
            String rawValue = stringArray[n2];
            String trimmed = rawValue.trim();
            if (trimmed.length() > 0) {
                values.add(trimmed);
            }
            ++n2;
        }
        return values;
    }

    private IStatus validate(String text) {
        List<String> currentValues = this.getValues(text);
        for (String value : currentValues) {
            IStatus status = this.fValidator.validate((Object)value);
            if (status.isOK()) continue;
            return status;
        }
        return Status.OK_STATUS;
    }

    private void showValidationStatus(IStatus status) {
        if (status.isOK()) {
            this.fControlDecoration.hide();
        } else {
            String fieldDecorationId = this.getDecorationId(status);
            FieldDecoration decoration = FieldDecorationRegistry.getDefault().getFieldDecoration(fieldDecorationId);
            this.fControlDecoration.setDescriptionText(status.getMessage());
            this.fControlDecoration.setImage(decoration.getImage());
            this.fControlDecoration.show();
        }
    }

    private String getDecorationId(IStatus status) {
        switch (status.getSeverity()) {
            case 4: {
                return "DEC_ERROR";
            }
            case 2: {
                return "DEC_WARNING";
            }
            case 1: {
                return "DEC_INFORMATION";
            }
        }
        return "DEC_INFORMATION";
    }

    private String[] createLabels() {
        Object[] elements = this.fContentProvider.getElements(this.fInput);
        ArrayList<String> labels = new ArrayList<String>(elements.length);
        Object[] objectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            String label = object.toString();
            labels.add(label);
            ++n2;
        }
        Collections.sort(labels);
        return labels.toArray(new String[labels.size()]);
    }

    public static enum Options {
        VERIFY_STRICT,
        VERIFY_WARN;

    }
}

