/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.picker;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.dto.IWorkspaceSearchCriteria;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class StreamCombo {
    Combo combo;
    IOperationRunner runner;
    ITeamRepository repo;
    IProcessArea processArea;
    Display display;
    StreamComboListener listener;
    volatile List<IWorkspace> streams = new ArrayList<IWorkspace>();

    public StreamCombo(Composite parent, IProcessArea processArea, ITeamRepository repo, IOperationRunner runner, StreamComboListener listener) {
        this.processArea = processArea;
        this.repo = repo;
        this.runner = runner;
        this.combo = new Combo(parent, 2056);
        this.display = parent.getDisplay();
        this.listener = listener;
        this.combo.setEnabled(false);
    }

    public Combo getCombo() {
        return this.combo;
    }

    public void refresh(final String defaultSelectionHint) {
        this.combo.setText(Messages.StreamCombo_0);
        this.combo.setEnabled(false);
        this.runner.enqueue(Messages.StreamCombo_1, (Operation)new RepositoryOperation(this.repo){

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, FileSystemException, OperationFailedException {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                IWorkspaceSearchCriteria criteria = IWorkspaceSearchCriteria.FACTORY.newInstance();
                criteria.setExactOwnerName(StreamCombo.this.processArea.getName());
                criteria.setKind(1);
                List itemHandles = SCMPlatform.getWorkspaceManager((ITeamRepository)StreamCombo.this.repo).findWorkspaces(criteria, Integer.MAX_VALUE, (IProgressMonitor)progress.newChild(80));
                List streams = StreamCombo.this.repo.itemManager().fetchCompleteItems(itemHandles, 0, (IProgressMonitor)progress.newChild(20));
                Collections.sort(streams, new Comparator<IWorkspace>(){

                    @Override
                    public int compare(IWorkspace w1, IWorkspace w2) {
                        return w1.getName().compareTo(w2.getName());
                    }
                });
                StreamCombo.this.streams = streams;
                StreamCombo.this.display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        int defaultIndex;
                        (this).StreamCombo.this.combo.removeAll();
                        if ((this).StreamCombo.this.streams.isEmpty()) {
                            if ((this).StreamCombo.this.listener != null) {
                                (this).StreamCombo.this.listener.noEntriesFound();
                            }
                            return;
                        }
                        for (IWorkspace workspace : (this).StreamCombo.this.streams) {
                            (this).StreamCombo.this.combo.add(workspace.getName());
                        }
                        String[] items = (this).StreamCombo.this.combo.getItems();
                        int n = defaultIndex = defaultSelectionHint != null ? Arrays.asList((this).StreamCombo.this.combo.getItems()).indexOf(defaultSelectionHint) : 0;
                        if (items.length > 0) {
                            (this).StreamCombo.this.combo.select(defaultIndex);
                        }
                        (this).StreamCombo.this.combo.setEnabled(true);
                        if ((this).StreamCombo.this.listener != null) {
                            (this).StreamCombo.this.listener.refreshed();
                        }
                    }
                });
            }
        });
    }

    public List<IWorkspace> getStreams() {
        return this.streams;
    }

    public IWorkspace getSelection() {
        List<IWorkspace> streams = this.streams;
        int index = this.combo.getSelectionIndex();
        return index >= 0 && index < streams.size() ? streams.get(index) : null;
    }

    public static interface StreamComboListener {
        public void refreshed();

        public void noEntriesFound();
    }
}

