/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.picker;

import com.ibm.team.filesystem.ide.ui.internal.util.DisplayHelper;
import com.ibm.team.filesystem.ui.wrapper.QueryItemWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.picker.RepositoryCombo;
import com.ibm.team.jface.labelProviders.ElementRemovedNotifierImpl;
import com.ibm.team.jface.labelProviders.IElementRemovedNotifier;
import com.ibm.team.jface.labelProviders.StandardLabelProvider;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IFetchResult;
import com.ibm.team.repository.common.NotLoggedInException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.utils.WidgetFactoryContext;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IQueryItem;
import com.ibm.team.scm.common.IScmItemQueryResult;
import com.ibm.team.scm.common.dto.IQueryItemSearchCriteria;
import com.ibm.team.scm.common.dto.IQueryPageDescriptor;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.LayoutConstants;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ListDialog;

public class ScmQueryItemPickerDialog
extends ListDialog {
    public static final int DEFAULT_WIDTH = 500;
    public static final int DEFAULT_HEIGHT = 400;
    private ITeamRepository fInitialRepo;
    private int fQueryType;
    private RepositoryCombo fRepoCombo;
    private Text fNamePatternText;
    private boolean fFetchingDone = true;
    private Object[] fElements;
    private String fNamePattern = "";
    private static final int TIMER_TYPING_DELAY = 500;
    private Runnable fTimerRunnable;
    private Job fQueryItemFetchingJob = new Job(Messages.ScmQueryItemPickerDialog_FetchQueryItemsJobName){

        protected IStatus run(IProgressMonitor monitor) {
            block7: {
                Shell shell = ScmQueryItemPickerDialog.this.getShell();
                ArrayList fetchedQueries = new ArrayList();
                try {
                    try {
                        if (shell != null && !shell.isDisposed()) {
                            final ITeamRepository[] repo = new ITeamRepository[1];
                            shell.getDisplay().syncExec(new Runnable(){

                                @Override
                                public void run() {
                                    if (!ScmQueryItemPickerDialog.this.fRepoCombo.getControl().isDisposed()) {
                                        repo[0] = ScmQueryItemPickerDialog.this.fRepoCombo.getRepository();
                                    }
                                }
                            });
                            if (repo[0] != null && repo[0].loggedIn()) {
                                fetchedQueries.addAll(ScmQueryItemPickerDialog.this.fetchQueryItems(repo[0], monitor));
                            }
                        }
                    }
                    catch (CoreException e) {
                        StatusUtil.log((Object)((Object)this), (String)Messages.ScmQueryItemPickerDialog_ErrorFetchingQueryItems, (Throwable)e);
                        DisplayHelper.asyncExec((Control)shell, new Runnable(shell, fetchedQueries){
                            private final /* synthetic */ Shell val$shell;
                            private final /* synthetic */ List val$fetchedQueries;
                            {
                                this.val$shell = shell;
                                this.val$fetchedQueries = list;
                            }

                            @Override
                            public void run() {
                                if (this.val$shell != null && !this.val$shell.isDisposed()) {
                                    if (this.val$fetchedQueries.isEmpty()) {
                                        ScmQueryItemPickerDialog.this.setElements(new String[]{Messages.ScmQueryItemPickerDialog_NoQueryItemsFoundNode});
                                    } else {
                                        ScmQueryItemPickerDialog.this.setElements(this.val$fetchedQueries.toArray());
                                    }
                                    ScmQueryItemPickerDialog.this.fFetchingDone = true;
                                    ScmQueryItemPickerDialog.this.updateEnablement();
                                }
                            }
                        });
                        break block7;
                    }
                }
                catch (Throwable throwable) {
                    DisplayHelper.asyncExec((Control)shell, new /* invalid duplicate definition of identical inner class */);
                    throw throwable;
                }
                DisplayHelper.asyncExec((Control)shell, new /* invalid duplicate definition of identical inner class */);
            }
            return Status.OK_STATUS;
        }
    };

    public ScmQueryItemPickerDialog(Shell parent, ITeamRepository repository, int queryType) {
        super(parent);
        this.fInitialRepo = repository;
        this.fQueryType = queryType;
        this.setLabelProvider((ILabelProvider)new StandardLabelProvider((IElementRemovedNotifier)new ElementRemovedNotifierImpl()){

            public void updateLabel(ViewerLabel label, Object element) {
                if (element instanceof String) {
                    label.setText((String)element);
                } else {
                    super.updateLabel(label, element);
                }
            }
        });
        this.setContentProvider((IStructuredContentProvider)new ArrayContentProvider());
        String title = queryType == 1 ? Messages.ScmQueryItemPickerDialog_BaselineQueryPickerDialogTitle : (queryType == 2 ? Messages.ScmQueryItemPickerDialog_SnapshotQueryPickerDialogTitle : (queryType == 3 ? Messages.ScmQueryItemPickerDialog_ChangeSetQueryPickerDialogTitle : (queryType == 4 ? Messages.ScmQueryItemPickerDialog_ComponentQueryPickerDialogTitle : (queryType == 5 ? Messages.ScmQueryItemPickerDialog_WorkspaceQueryPickerDialogTitle : Messages.ScmQueryItemPickerDialog_QueryItemPickerDialogTitle))));
        this.setTitle(title);
        this.setMessage(Messages.ScmQueryItemPickerDialog_SearchResultLabel);
        this.fQueryItemFetchingJob.setSystem(false);
    }

    private void setElements(Object[] elements) {
        this.fElements = elements;
        TableViewer tableViewer = this.getTableViewer();
        if (tableViewer != null) {
            tableViewer.setInput((Object)elements);
        }
    }

    public boolean isHelpAvailable() {
        return false;
    }

    protected Label createMessageArea(Composite composite) {
        Label label = new Label(composite, 64);
        if (this.getMessage() != null) {
            label.setText(this.getMessage());
        }
        label.setFont(composite.getFont());
        GridData data = new GridData(4, 0x1000000, true, false);
        data.widthHint = this.convertWidthInCharsToPixels(this.getWidthInChars());
        label.setLayoutData((Object)data);
        return label;
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        this.updateEnablement();
        return control;
    }

    protected void updateEnablement() {
        Button okButton = this.getOkButton();
        if (okButton != null && !okButton.isDisposed()) {
            IStructuredSelection selection = (IStructuredSelection)this.getTableViewer().getSelection();
            okButton.setEnabled(this.fFetchingDone && selection.size() == 1 && !(selection.getFirstElement() instanceof String));
        }
    }

    protected void okPressed() {
        if (this.getOkButton().isEnabled()) {
            super.okPressed();
        }
    }

    public boolean close() {
        if (this.fQueryItemFetchingJob != null) {
            this.fQueryItemFetchingJob.cancel();
        }
        return super.close();
    }

    protected Control createDialogArea(Composite parent) {
        Composite searchCriteriaComposite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).extendedMargins(LayoutConstants.getMargins().x, LayoutConstants.getMargins().x, LayoutConstants.getMargins().y, 0).generateLayout(searchCriteriaComposite);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)searchCriteriaComposite);
        ScmQueryItemPickerDialog.applyDialogFont((Control)searchCriteriaComposite);
        Label repoLabel = new Label(searchCriteriaComposite, 0);
        repoLabel.setText(Messages.ScmQueryItemPickerDialog_RepositoryLabel);
        repoLabel.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.fRepoCombo = new RepositoryCombo(searchCriteriaComposite, this.getConfigPrefs().node("repository"), WidgetFactoryContext.forDialogBox());
        this.fRepoCombo.setLoginButtonText(Messages.ScmQueryItemPickerDialog_LoginButtonLabel);
        if (this.fInitialRepo != null) {
            this.fRepoCombo.setSelectedElement(this.fInitialRepo);
        }
        this.fRepoCombo.getSelectionProvider().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ScmQueryItemPickerDialog.this.setElements(null);
                if (ScmQueryItemPickerDialog.this.fNamePattern != null && !ScmQueryItemPickerDialog.this.fNamePattern.isEmpty()) {
                    ScmQueryItemPickerDialog.this.setElements(new String[]{Messages.ScmQueryItemPickerDialog_FetchingNode});
                    ScmQueryItemPickerDialog.this.fQueryItemFetchingJob.cancel();
                    ScmQueryItemPickerDialog.this.fFetchingDone = false;
                    ScmQueryItemPickerDialog.this.fQueryItemFetchingJob.schedule();
                }
            }
        });
        GridDataFactory.fillDefaults().grab(true, false).applyTo(this.fRepoCombo.getControl());
        Label label = new Label(searchCriteriaComposite, 0);
        label.setText(Messages.ScmQueryItemPickerDialog_QueryNameLabel);
        label.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.fNamePatternText = new Text(searchCriteriaComposite, 384);
        this.fNamePatternText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.fNamePatternText.setFocus();
        this.fNamePatternText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (ScmQueryItemPickerDialog.this.fTimerRunnable == null) {
                    ScmQueryItemPickerDialog.this.fTimerRunnable = new Runnable(){

                        @Override
                        public void run() {
                            if (!ScmQueryItemPickerDialog.this.fNamePatternText.isDisposed()) {
                                if (ScmQueryItemPickerDialog.this.fNamePatternText.getText().trim().isEmpty()) {
                                    ScmQueryItemPickerDialog.this.fNamePattern = "";
                                    ScmQueryItemPickerDialog.this.setElements(null);
                                } else if (!ScmQueryItemPickerDialog.this.fNamePattern.equalsIgnoreCase(ScmQueryItemPickerDialog.this.fNamePatternText.getText())) {
                                    ScmQueryItemPickerDialog.this.fNamePattern = ScmQueryItemPickerDialog.this.fNamePatternText.getText();
                                    ScmQueryItemPickerDialog.this.setElements(new String[]{Messages.ScmQueryItemPickerDialog_FetchingNode});
                                    ScmQueryItemPickerDialog.this.fQueryItemFetchingJob.cancel();
                                    ScmQueryItemPickerDialog.this.fFetchingDone = false;
                                    ScmQueryItemPickerDialog.this.fQueryItemFetchingJob.schedule();
                                }
                            }
                        }
                    };
                }
                ScmQueryItemPickerDialog.this.fNamePatternText.getDisplay().timerExec(500, ScmQueryItemPickerDialog.this.fTimerRunnable);
            }
        });
        Composite container = (Composite)super.createDialogArea(parent);
        TableViewer tableViewer = this.getTableViewer();
        tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ScmQueryItemPickerDialog.this.updateEnablement();
            }
        });
        tableViewer.setSorter(new ViewerSorter());
        Object[] elements = this.fElements;
        if (elements != null) {
            tableViewer.setInput((Object)elements);
        }
        tableViewer.getControl().getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = ScmQueryItemPickerDialog.this.getMessage();
            }
        });
        GridData gridData = (GridData)tableViewer.getTable().getLayoutData();
        gridData.widthHint = 500;
        gridData.heightHint = 400;
        return container;
    }

    private IEclipsePreferences getConfigPrefs() {
        IEclipsePreferences result = new ConfigurationScope().getNode("com.ibm.team.filesystem.ide.ui/" + ((Object)((Object)this)).getClass().getName());
        return result;
    }

    private List<QueryItemWrapper> fetchQueryItems(ITeamRepository repo, IProgressMonitor monitor) throws CoreException {
        ArrayList<QueryItemWrapper> fetchedQueries = new ArrayList<QueryItemWrapper>();
        try {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.ScmQueryItemPickerDialog_FetchQueryItemsJobName, (int)100);
            if (progress.isCanceled()) {
                throw new OperationCanceledException();
            }
            if (!repo.loggedIn()) {
                repo.login((IProgressMonitor)progress.newChild(5));
            }
            progress.setWorkRemaining(95);
            IWorkspaceManager workspaceManager = SCMPlatform.getWorkspaceManager((ITeamRepository)repo);
            IQueryPageDescriptor page = null;
            ArrayList queryItemHandles = new ArrayList();
            do {
                IQueryItemSearchCriteria queryItemSearchCriteria = IQueryItemSearchCriteria.FACTORY.newInstance();
                queryItemSearchCriteria.setQueryType(this.fQueryType);
                queryItemSearchCriteria.setPartialName(this.fNamePattern);
                IScmItemQueryResult queryResult = workspaceManager.findQueryItems(queryItemSearchCriteria, page, (IProgressMonitor)progress.newChild(45));
                queryItemHandles.addAll(queryResult.getItemHandles());
                page = queryResult.getNextPageDescriptor();
                if (page == null) continue;
                progress.setWorkRemaining(100);
            } while (page != null);
            if (!queryItemHandles.isEmpty()) {
                IFetchResult fetchResult = repo.itemManager().fetchCompleteItemsPermissionAware(queryItemHandles, 0, (IProgressMonitor)progress.newChild(50));
                for (Object o : fetchResult.getRetrievedItems()) {
                    if (!(o instanceof IQueryItem)) continue;
                    fetchedQueries.add(QueryItemWrapper.newWrapper(repo, (IQueryItem)o));
                }
            }
            return fetchedQueries;
        }
        catch (TeamRepositoryException e) {
            String message = Messages.ScmQueryItemPickerDialog_ErrorFetchingQueryItems;
            if (e instanceof NotLoggedInException) {
                message = Messages.ScmQueryItemPickerDialog_NotLoggedIn;
            }
            throw new CoreException((IStatus)new Status(4, "com.ibm.team.filesystem.ide.ui", 4, message, (Throwable)e));
        }
        catch (OperationCanceledException operationCanceledException) {
            return fetchedQueries;
        }
    }
}

