/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.picker;

import com.ibm.team.filesystem.ui.queries.KnownTeamRepositoryQuery;
import com.ibm.team.filesystem.ui.queries.SetWithListenersPartFactory;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.rcp.ui.internal.viewers.ISetWithListeners;
import com.ibm.team.repository.rcp.ui.parts.IPartFactory;
import com.ibm.team.repository.rcp.ui.parts.Parts;
import com.ibm.team.repository.rcp.ui.parts.impl.IPartResult;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class RepositoryPicker {
    public static void pickRepository(Shell shell, String message, final IPartResult<ITeamRepository> result) {
        Display display = Display.getCurrent();
        final ITeamRepository[] repositories = TeamPlatform.getTeamRepositoryService().getTeamRepositories();
        if (repositories.length == 1) {
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    result.setResult((Object)repositories[0]);
                }
            });
        } else {
            SetWithListenersPartFactory pf = new SetWithListenersPartFactory((ISetWithListeners)new KnownOnlineTeamRepositoryQuery(), Messages.RepositoryPicker_0, message);
            Parts.openDialog((Shell)shell, (Object)new IPartResult(){

                public void setResult(Object _result) {
                    List ss;
                    if (_result instanceof List && !(ss = (List)_result).isEmpty()) {
                        result.setResult((Object)((ITeamRepository)ss.iterator().next()));
                    }
                }
            }, (IPartFactory)pf);
        }
    }

    private static class KnownOnlineTeamRepositoryQuery
    extends KnownTeamRepositoryQuery {
        @Override
        public Set<ITeamRepository> getElements() {
            ITeamRepository[] repositories = TeamPlatform.getTeamRepositoryService().getTeamRepositories();
            HashSet<ITeamRepository> result = new HashSet<ITeamRepository>();
            int i = 0;
            while (i < repositories.length) {
                ITeamRepository teamRepository = repositories[i];
                if (teamRepository.loggedIn()) {
                    result.add(teamRepository);
                }
                ++i;
            }
            return result;
        }
    }
}

