/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.picker;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.internal.namespace.ItemNamespace;
import com.ibm.team.filesystem.client.internal.namespace.WorkspaceNamespace;
import com.ibm.team.filesystem.client.internal.snapshot.ISnapshot;
import com.ibm.team.filesystem.client.internal.snapshot.NamespaceSetId;
import com.ibm.team.filesystem.client.internal.snapshot.SnapshotId;
import com.ibm.team.filesystem.common.changemodel.VersionablePath;
import com.ibm.team.filesystem.common.changemodel.VersionablePathSegment;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.RemotePathResolver;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.SnapshotPathResolver;
import com.ibm.team.filesystem.ui.views.SimplePartInput;
import com.ibm.team.filesystem.ui.wrapper.AbstractFileSystemItemWrapper;
import com.ibm.team.filesystem.ui.wrapper.FileItemWrapper;
import com.ibm.team.filesystem.ui.wrapper.FolderItemWrapper;
import com.ibm.team.filesystem.ui.wrapper.WorkspaceComponentWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.picker.RepositoryFilesPickerInput;
import com.ibm.team.internal.filesystem.ui.picker.RepositoryFilesPickerOutput;
import com.ibm.team.internal.filesystem.ui.views.repositoryfiles.RepositoryFilesComponentNode;
import com.ibm.team.internal.filesystem.ui.views.repositoryfiles.RepositoryFilesView;
import com.ibm.team.internal.filesystem.ui.views.repositoryfiles.RepositoryFilesViewTreeProvider;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.internal.utils.SWTUtil;
import com.ibm.team.repository.rcp.ui.internal.viewers.ButtonBar;
import com.ibm.team.repository.rcp.ui.internal.viewers.ITreePathRunnable;
import com.ibm.team.repository.rcp.ui.internal.viewers.ITreeProvider;
import com.ibm.team.repository.rcp.ui.internal.viewers.SimpleTreeViewer;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.repository.rcp.ui.parts.AbstractPart;
import com.ibm.team.repository.rcp.ui.parts.IBusyHandler;
import com.ibm.team.repository.rcp.ui.parts.IControlSite;
import com.ibm.team.repository.rcp.ui.parts.IPartFactory;
import com.ibm.team.repository.rcp.ui.parts.PartFactory;
import com.ibm.team.repository.rcp.ui.parts.Parts;
import com.ibm.team.repository.rcp.ui.parts.WidgetToolkit;
import com.ibm.team.repository.rcp.ui.parts.impl.IPartResult;
import com.ibm.team.repository.rcp.ui.parts.impl.MessageDialogFactory;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.internal.RepoFetcher;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.internal.util.ItemId;
import com.ibm.team.scm.common.internal.util.NewCollection;
import com.ibm.team.scm.common.internal.util.SiloedItemId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.IFilter;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.IViewerLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.PlatformUI;

public class RepositoryFilesPicker
extends AbstractPart {
    private SimpleTreeViewer viewer;
    private SimplePartInput<RepositoryFilesPickerInput, RepositoryFilesPickerOutput> input;
    private CLabel statusLabel;
    private Button okayButton;

    public RepositoryFilesPicker(IControlSite site, SimplePartInput<RepositoryFilesPickerInput, RepositoryFilesPickerOutput> newInput) {
        this(Messages.RepositoryFilesPicker_0, site, newInput);
    }

    public RepositoryFilesPicker(String title, IControlSite site, SimplePartInput<RepositoryFilesPickerInput, RepositoryFilesPickerOutput> newInput) {
        super(site, newInput);
        site.getNameable().setName(title);
        WidgetToolkit toolkit = site.getToolkit();
        String message = newInput.getInput().getMessage();
        if (!message.equals("")) {
            toolkit.createLabel(site.getParent(), message, 64);
        }
        int flags = newInput.getInput().isMulti() ? 2 : 0;
        Tree theTree = toolkit.createTree(site.getParent(), flags);
        final RepositoryFilesPickerInput pickerInput = newInput.getInput();
        this.viewer = new SimpleTreeViewer(theTree, (ITreeProvider)new RepositoryFilesViewTreeProvider(this.getControlSite().getOperationRunner(), pickerInput.isFoldersOnly(), !pickerInput.allowComponentOutput(), false)).setProgressService((IBusyHandler)site);
        this.viewer.setLabelProvider((IViewerLabelProvider)RepositoryFilesView.createLabelProvider(this.viewer.getKnownElements()));
        this.viewer.setSorter(RepositoryFilesView.createSorter());
        RepositoryFilesView.makeAutoExpandable(this.viewer);
        this.viewer.setDoubleClickHandler(new ITreePathRunnable(){

            public void run(TreePath selectedObject, Shell targetShell) {
                if (!pickerInput.isFoldersOnly() || selectedObject.getLastSegment() instanceof FolderItemWrapper) {
                    RepositoryFilesPicker.this.doDoubleClick();
                }
            }
        });
        HashSet initial = new HashSet();
        for (SiloedItemId<IVersionable> versionable : pickerInput.getInitialSelection()) {
            initial.addAll(this.viewer.getPathsToElement(versionable));
        }
        this.viewer.selectAndReveal((ITreeSelection)new TreeSelection(initial.toArray(new TreePath[initial.size()])));
        if (pickerInput.getFilter() != null) {
            this.viewer.addFilter(pickerInput.getFilter());
        }
        this.viewer.getSelectionProvider().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                RepositoryFilesPicker.this.updateSelection();
            }
        });
        this.statusLabel = new CLabel(site.getParent(), 64);
        ButtonBar theButtonBar = new ButtonBar(site.getParent(), MessageDialogFactory.getChoicesForType((int)5), new IPartResult(){

            public void setResult(Object result) {
                if (result == MessageDialogFactory.OKAY.getValue()) {
                    RepositoryFilesPicker.this.okayClicked();
                } else {
                    RepositoryFilesPicker.this.getControlSite().close();
                }
            }
        });
        this.okayButton = theButtonBar.getButton(MessageDialogFactory.OKAY.getValue());
        site.setDefaultButton(this.okayButton);
        site.setSelectionProvider(this.viewer.getSelectionProvider());
        GridLayoutFactory.fillDefaults().generateLayout(this.getControlSite().getParent());
        this.handleInput(newInput);
        this.updateSelection();
    }

    private static SimplePartInput<RepositoryFilesPickerInput, RepositoryFilesPickerOutput> createInput(RepositoryFilesPickerInput in, IPartResult<RepositoryFilesPickerOutput> result) {
        return new SimplePartInput<RepositoryFilesPickerInput, RepositoryFilesPickerOutput>(in, result);
    }

    protected void updateSelection() {
        ITreeSelection selection = this.getSelection();
        if (selection.isEmpty()) {
            this.setOkayEnabled(false);
        } else {
            ArrayList resultIds = NewCollection.arrayList();
            ArrayList resultNodes = NewCollection.arrayList();
            this.getSelection(selection.toList(), resultIds, resultNodes);
            this.setOkayEnabled(!resultIds.isEmpty() || this.input.getInput().allowComponentOutput() && !resultNodes.isEmpty());
        }
    }

    protected ITreeSelection getSelection() {
        return this.viewer.getSelection();
    }

    private Image findImage(IStatus status) {
        if (status == null) {
            return null;
        }
        if (status.isOK()) {
            return null;
        }
        if (status.matches(4)) {
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_ERROR_TSK");
        }
        if (status.matches(2)) {
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_WARN_TSK");
        }
        if (status.matches(1)) {
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_INFO_TSK");
        }
        return null;
    }

    protected void setStatus(IStatus status) {
        Image image = this.findImage(status);
        String string = null;
        if (status != null && !status.isOK()) {
            string = status.getMessage();
        }
        if (string == null) {
            string = "";
        }
        this.statusLabel.setImage(image);
        this.statusLabel.setText(string);
    }

    protected void setOkayEnabled(boolean enabled) {
        this.okayButton.setEnabled(enabled);
    }

    private void getSelection(List<Object> list, List<AbstractFileSystemItemWrapper> itemsIds, List<RepositoryFilesComponentNode> components) {
        for (Object o : list) {
            if (o instanceof AbstractFileSystemItemWrapper) {
                AbstractFileSystemItemWrapper item = (AbstractFileSystemItemWrapper)((Object)o);
                itemsIds.add(item);
                continue;
            }
            if (!(o instanceof RepositoryFilesComponentNode)) continue;
            RepositoryFilesComponentNode node = (RepositoryFilesComponentNode)o;
            components.add(node);
        }
    }

    protected void okayClicked() {
        if (!this.okayButton.isEnabled()) {
            return;
        }
        final Display display = Display.getCurrent();
        final List resultList = this.viewer.getSelection().toList();
        this.getControlSite().getOperationRunner().enqueue(Messages.RepositoryFilesPicker_2, (Operation)new RepositoryOperation(){

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, FileSystemException, OperationFailedException {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                ArrayList resultIds = NewCollection.arrayList();
                ArrayList resultNodes = NewCollection.arrayList();
                Map filePaths = NewCollection.hashMap();
                HashMap fullComponents = NewCollection.hashMap();
                HashMap owningComponents = NewCollection.hashMap();
                RepositoryFilesPicker.this.getSelection(resultList, resultIds, resultNodes);
                HashSet namespaces = NewCollection.hashSet();
                for (AbstractFileSystemItemWrapper next : resultIds) {
                    namespaces.add(next.getWorkspace());
                }
                SubMonitor fetchProgress = progress.newChild(40).setWorkRemaining(namespaces.size() * 2);
                HashMap components = NewCollection.hashMap();
                for (ItemNamespace next : namespaces) {
                    ItemId componentId = next.fetchComponentId((IProgressMonitor)fetchProgress.newChild(1));
                    components.put(next, componentId);
                    IComponent fullComponent = (IComponent)RepoFetcher.fetchCurrent((ITeamRepository)next.getRepository(), (ItemId)componentId, (IProgressMonitor)fetchProgress.newChild(1));
                    fullComponents.put(componentId, fullComponent);
                }
                ArrayList itemIds = NewCollection.arrayList();
                ArrayList itemIds2 = NewCollection.arrayList();
                ArrayList componentNamespaces = NewCollection.arrayList();
                for (AbstractFileSystemItemWrapper item : resultIds) {
                    ItemId component = (ItemId)components.get(item.getWorkspace());
                    SiloedItemId siloedItem = SiloedItemId.create((ItemId)item.getItem(), (ItemId)component);
                    itemIds.add(siloedItem);
                    itemIds2.add(siloedItem);
                    owningComponents.put(siloedItem, (IComponent)fullComponents.get(component));
                }
                for (RepositoryFilesComponentNode node : resultNodes) {
                    componentNamespaces.add((WorkspaceComponentWrapper)node.getWrapper());
                }
                IConnection connection = ((RepositoryFilesPickerInput)RepositoryFilesPicker.this.input.getInput()).getSnapshot().getConnection((IProgressMonitor)progress.newChild(40));
                if (connection != null) {
                    RemotePathResolver resolver = new RemotePathResolver(connection);
                    filePaths = resolver.resolve((Collection)itemIds2, (IProgressMonitor)progress.newChild(20));
                }
                progress.setWorkRemaining(0);
                final RepositoryFilesPickerOutput result = new RepositoryFilesPickerOutput(itemIds, componentNamespaces, filePaths, owningComponents);
                display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!RepositoryFilesPicker.this.okayButton.isDisposed()) {
                            RepositoryFilesPicker.this.input.setResult(result);
                            RepositoryFilesPicker.this.getControlSite().close();
                        }
                    }
                });
            }
        });
    }

    protected void doDoubleClick() {
        this.okayClicked();
    }

    public ISelectionProvider getSelectionProvider() {
        return this.viewer.getSelectionProvider();
    }

    private void handleInput(SimplePartInput<RepositoryFilesPickerInput, RepositoryFilesPickerOutput> newInput) {
        this.input = newInput;
        final SnapshotId namespace = newInput.getInput().getSnapshot();
        final Display display = Display.getCurrent();
        Composite c = this.getControlSite().getParent();
        this.getControlSite().getOperationRunner().enqueue(Messages.RepositoryFilesPicker_3, (Operation)new RepositoryOperation((Control)c){
            private final /* synthetic */ Control val$c;
            {
                this.val$c = control;
            }

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, FileSystemException, OperationFailedException {
                ISnapshot snapshot;
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                try {
                    snapshot = namespace.getSnapshot((IProgressMonitor)progress.newChild(50));
                }
                catch (TeamRepositoryException e) {
                    throw new OperationFailedException(StatusUtil.newStatus((Object)((Object)this), (Throwable)e));
                }
                SnapshotPathResolver pathResolver = SnapshotPathResolver.create((SnapshotId)namespace);
                final Map versionables = pathResolver.resolve(((RepositoryFilesPickerInput)RepositoryFilesPicker.this.input.getInput()).getInitialSelection(), (IProgressMonitor)progress.newChild(50));
                SWTUtil.greedyExec((Display)display, (Control)this.val$c, (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        RepositoryFilesPicker.this.viewer.setInput((Object)snapshot);
                        RepositoryFilesPicker.expandAll(RepositoryFilesPicker.this.viewer, versionables.values());
                        RepositoryFilesPicker.this.selectAll(((RepositoryFilesPickerInput)RepositoryFilesPicker.this.input.getInput()).getInitialSelection());
                    }
                });
            }
        });
    }

    public static void expandAll(SimpleTreeViewer viewer, Collection<VersionablePath> values) {
        final HashSet components = NewCollection.hashSet();
        final HashSet folders = NewCollection.hashSet();
        for (VersionablePath nextPath : values) {
            components.add(nextPath.getSiloedRoot().getComponent());
            int idx = 0;
            while (idx < nextPath.segmentCount()) {
                VersionablePathSegment nextSeg = nextPath.segment(idx);
                folders.add(nextSeg.getParent());
                ++idx;
            }
        }
        viewer.expandMatching(new IFilter(){

            public boolean select(Object toTest) {
                if (toTest instanceof RepositoryFilesComponentNode) {
                    RepositoryFilesComponentNode componentNode = (RepositoryFilesComponentNode)toTest;
                    return components.contains(componentNode.getContext().getComponent());
                }
                if (toTest instanceof FolderItemWrapper) {
                    FolderItemWrapper fiw = (FolderItemWrapper)((Object)toTest);
                    return folders.contains(fiw.getItem());
                }
                return false;
            }
        });
    }

    public static void pickFolder(Shell parentShell, RepositoryFilesPickerInput input, IPartResult<RepositoryFilesPickerOutput> result) {
        Parts.openDialog((Shell)parentShell, RepositoryFilesPicker.createInput(input, result), (IPartFactory)new PartFactory(RepositoryFilesPicker.class));
    }

    private void selectAll(Set<SiloedItemId<IVersionable>> initialSelection) {
        final HashSet computedSelection = NewCollection.hashSet();
        for (SiloedItemId<IVersionable> next : initialSelection) {
            computedSelection.add(next.getItemId());
        }
        this.viewer.selectMatching(new IFilter(){

            public boolean select(Object toTest) {
                if (toTest instanceof FileItemWrapper) {
                    FileItemWrapper fiw = (FileItemWrapper)((Object)toTest);
                    return computedSelection.contains(fiw.getItem());
                }
                return false;
            }
        });
    }

    public static IFolderHandle pickFolder(Shell shell, IWorkspaceConnection connection, IComponentHandle component, IVersionableHandle[] initialSelection, String message) {
        HashSet initialItems = NewCollection.hashSet();
        int idx = 0;
        while (idx < initialSelection.length) {
            initialItems.add(SiloedItemId.create((IVersionableHandle)initialSelection[idx], (IComponentHandle)component));
            ++idx;
        }
        RepositoryFilesPickerInput input = new RepositoryFilesPickerInput((SnapshotId)NamespaceSetId.create((ItemNamespace)WorkspaceNamespace.create((IWorkspaceConnection)connection, (IComponentHandle)component)), true, false, message, false, initialItems, null);
        final IFolderHandle[] handle = new IFolderHandle[1];
        IPartResult<RepositoryFilesPickerOutput> result = new IPartResult<RepositoryFilesPickerOutput>(){

            public void setResult(RepositoryFilesPickerOutput output) {
                List<SiloedItemId> result = output.getItemIds();
                if (result != null && !result.isEmpty()) {
                    handle[0] = (IFolderHandle)result.iterator().next().toHandle();
                }
            }
        };
        Parts.openModalDialog((Shell)shell, RepositoryFilesPicker.createInput(input, result), (IPartFactory)new PartFactory(RepositoryFilesPicker.class));
        return handle[0];
    }
}

