/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.picker;

import com.ibm.team.filesystem.client.internal.FileSystemStatusUtil;
import com.ibm.team.filesystem.client.internal.snapshot.SnapshotId;
import com.ibm.team.filesystem.client.internal.snapshot.WorkspaceId;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.ui.views.SimplePartInput;
import com.ibm.team.filesystem.ui.wrapper.AbstractFileSystemItemWrapper;
import com.ibm.team.filesystem.ui.wrapper.AbstractWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.picker.RepositoryFilesPicker;
import com.ibm.team.internal.filesystem.ui.picker.RepositoryFilesPickerInput;
import com.ibm.team.internal.filesystem.ui.picker.RepositoryFilesPickerOutput;
import com.ibm.team.internal.filesystem.ui.util.WorkspaceUtil;
import com.ibm.team.internal.filesystem.ui.views.repositoryfiles.RepositoryFilesComponentNode;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.repository.rcp.ui.parts.IControlSite;
import com.ibm.team.repository.rcp.ui.parts.IPartFactory;
import com.ibm.team.repository.rcp.ui.parts.PartFactory;
import com.ibm.team.repository.rcp.ui.parts.Parts;
import com.ibm.team.repository.rcp.ui.parts.impl.IPartResult;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.internal.util.SiloedItemId;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.swt.widgets.Shell;

public class RepositoryFilePerComponentPicker
extends RepositoryFilesPicker {
    public RepositoryFilePerComponentPicker(IControlSite site, SimplePartInput<RepositoryFilesPickerInput, RepositoryFilesPickerOutput> newInput) {
        super(Messages.RepositoryFilePerComponentPicker_title, site, newInput);
    }

    @Override
    protected void updateSelection() {
        ITreeSelection selection = this.getSelection();
        if (selection.isEmpty()) {
            this.setStatus(Status.OK_STATUS);
            this.setOkayEnabled(true);
        } else {
            TreePath[] paths = selection.getPaths();
            HashSet<RepositoryFilesComponentNode> components = new HashSet<RepositoryFilesComponentNode>();
            boolean okEnabled = true;
            IStatus status = Status.OK_STATUS;
            TreePath[] treePathArray = paths;
            int n = paths.length;
            int n2 = 0;
            while (n2 < n) {
                TreePath path = treePathArray[n2];
                Object selected = path.getLastSegment();
                if (selected instanceof AbstractFileSystemItemWrapper) {
                    AbstractFileSystemItemWrapper item = (AbstractFileSystemItemWrapper)((Object)selected);
                    if (!IFileItem.ITEM_TYPE.equals(item.getItem().getItemType())) {
                        status = FileSystemStatusUtil.getStatusFor((int)4, (String)NLS.bind((String)Messages.RepositoryFilePerComponentPicker_0, (Object)item.getName(), (Object[])new Object[0]));
                        okEnabled = false;
                        break;
                    }
                    RepositoryFilesComponentNode node = (RepositoryFilesComponentNode)path.getFirstSegment();
                    if (components.contains(node)) {
                        IComponent component = RepositoryFilePerComponentPicker.getComponent(node);
                        String message = component != null ? NLS.bind((String)Messages.RepositoryFilePerComponentPicker_1, (Object)component.getName(), (Object[])new Object[0]) : Messages.RepositoryFilePerComponentPicker_2;
                        status = FileSystemStatusUtil.getStatusFor((int)4, (String)message);
                        okEnabled = false;
                        break;
                    }
                    components.add(node);
                } else if (selected instanceof RepositoryFilesComponentNode) {
                    RepositoryFilesComponentNode node = (RepositoryFilesComponentNode)selected;
                    IComponent component = RepositoryFilePerComponentPicker.getComponent(node);
                    String message = component != null ? NLS.bind((String)Messages.RepositoryFilePerComponentPicker_0, (Object)component.getName(), (Object[])new Object[0]) : Messages.RepositoryFilePerComponentPicker_2;
                    status = FileSystemStatusUtil.getStatusFor((int)4, (String)message);
                    okEnabled = false;
                    break;
                }
                ++n2;
            }
            this.setStatus(status);
            this.setOkayEnabled(okEnabled);
        }
    }

    private static IComponent getComponent(RepositoryFilesComponentNode node) {
        IComponent component = null;
        if (node.getWrapper() instanceof AbstractWrapper) {
            AbstractWrapper wrapper = (AbstractWrapper)((Object)node.getWrapper());
            component = WorkspaceUtil.getComponent(wrapper);
        }
        return component;
    }

    public static Set<SiloedItemId<IVersionable>> pickFilePerComponent(Shell shell, ITeamRepository repo, IWorkspace workspace, String message, Set<SiloedItemId<IVersionable>> initialSelection) {
        RepositoryFilesPickerInput input = new RepositoryFilesPickerInput((SnapshotId)WorkspaceId.create((ITeamRepository)repo, (IWorkspaceHandle)((IWorkspaceHandle)workspace.getItemHandle())), false, true, message, true, initialSelection == null ? Collections.EMPTY_SET : initialSelection, null);
        final Set[] items = new Set[1];
        IPartResult<RepositoryFilesPickerOutput> result = new IPartResult<RepositoryFilesPickerOutput>(){

            public void setResult(RepositoryFilesPickerOutput output) {
                items[0] = new HashSet<SiloedItemId>(output.getItemIds());
            }
        };
        Parts.openModalDialog((Shell)shell, new SimplePartInput<RepositoryFilesPickerInput, RepositoryFilesPickerOutput>(input, result), (IPartFactory)new PartFactory(RepositoryFilePerComponentPicker.class));
        return items[0];
    }
}

