/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.picker;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.ui.item.Repositories;
import com.ibm.team.filesystem.ui.queries.KnownTeamRepositoryQuery;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.util.RepositoryUtils;
import com.ibm.team.process.rcp.ui.RepositoryCreationPage;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.client.util.IListener;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.internal.menus.IActionExt;
import com.ibm.team.repository.rcp.ui.internal.menus.IMenuExt;
import com.ibm.team.repository.rcp.ui.internal.menus.PushAction;
import com.ibm.team.repository.rcp.ui.internal.menus.SingleEntryMenu;
import com.ibm.team.repository.rcp.ui.internal.utils.SWTUtil;
import com.ibm.team.repository.rcp.ui.internal.utils.ToolkitUtil;
import com.ibm.team.repository.rcp.ui.internal.viewers.ComboWithActions;
import com.ibm.team.repository.rcp.ui.internal.viewers.ISetWithListeners;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.repository.rcp.ui.parts.WidgetToolkit;
import com.ibm.team.repository.rcp.ui.utils.WidgetFactoryContext;
import com.ibm.team.repository.rcp.ui.wizards.IRunnableWithResult;
import com.ibm.team.repository.rcp.ui.wizards.WizardPageJobRunner;
import com.ibm.team.repository.rcp.ui.wizards.WizardUtil;
import java.util.List;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class RepositoryCombo {
    public static final int FLAG_LOGIN_REQUIRED = 1;
    private static final String LAST_REPOSITORY = "lastRepository";
    private WritableValue validationStatus = new WritableValue();
    private ComboWithActions<ITeamRepository, Object> repo;
    private IOperationRunner background;
    private IOperationRunner foreground;
    private Preferences prefs;
    private PushAction loginAction;
    private Control loginButton;
    private ITeamRepository currentlyListening = null;
    private Display display;
    private int flags;
    private IListener eventListener = new IListener(){

        public void handleEvents(List events) {
            SWTUtil.greedyExec((Display)RepositoryCombo.this.display, (Runnable)new Runnable(){

                @Override
                public void run() {
                    RepositoryCombo.this.updateStatus();
                }
            });
        }
    };

    public RepositoryCombo(Composite parent, WidgetFactoryContext context) {
        this(parent, null, context, 1, null);
    }

    public RepositoryCombo(Composite parent, Preferences prefs, WidgetFactoryContext context) {
        this(parent, prefs, context, 1, null);
    }

    public RepositoryCombo(Composite parent, Preferences prefs, WidgetFactoryContext context, ITeamRepository seedRepo) {
        this(parent, prefs, context, 1, seedRepo);
    }

    public RepositoryCombo(Composite parent, Preferences prefs, final WidgetFactoryContext context, int flags, ITeamRepository seedRepo) {
        this.flags = flags;
        this.display = parent.getDisplay();
        WidgetToolkit toolkit = context.getToolkit();
        this.prefs = prefs;
        PushAction newRepositoryAction = new PushAction(Messages.RepositoryCombo_1, new Runnable(){

            @Override
            public void run() {
                RepositoryCombo.this.openRepositoryCreationDialog();
            }
        });
        this.background = context.getBackgroundOperationRunner();
        this.foreground = context.getUserOperationRunner();
        Composite composite = toolkit.createComposite(parent);
        this.repo = new ComboWithActions(composite);
        this.repo.setInput((ISetWithListeners)new KnownTeamRepositoryQuery());
        this.repo.setMenu((IMenuExt)new SingleEntryMenu((IActionExt)newRepositoryAction));
        this.repo.getSelectionProvider().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                RepositoryCombo.this.updateStatus();
                RepositoryCombo.this.updateListener();
            }
        });
        this.repo.getControl().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                RepositoryCombo.this.disposed();
            }
        });
        GridDataFactory.fillDefaults().align(4, 0x1000000).hint(150, -1).grab(true, false).applyTo(this.repo.getControl());
        this.loginAction = new PushAction(Messages.RepositoryCombo_2, new Runnable(){

            @Override
            public void run() {
                final ITeamRepository teamRepo = RepositoryCombo.this.getRepository();
                if (teamRepo == null) {
                    return;
                }
                RepositoryCombo.this.foreground.enqueue(Messages.RepositoryCombo_3, (Operation)new RepositoryOperation(){

                    public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, FileSystemException, OperationFailedException {
                        teamRepo.login(monitor);
                    }
                });
                if (context.getUserOperationRunner() instanceof WizardPageJobRunner) {
                    RepositoryCombo.this.repo.getControl().notifyListeners(13, new Event());
                }
            }
        });
        this.loginButton = ToolkitUtil.createButton((WidgetFactoryContext)context, (Composite)composite, (IActionExt)this.loginAction);
        this.updateStatus();
        if (seedRepo != null) {
            boolean found = false;
            ITeamRepository[] repos = TeamPlatform.getTeamRepositoryService().getTeamRepositories();
            int i = 0;
            while (i < repos.length) {
                ITeamRepository teamRepository = repos[i];
                if (teamRepository == seedRepo) {
                    found = true;
                    break;
                }
                ++i;
            }
            if (found) {
                this.setSelectedElement(seedRepo);
            } else if (prefs != null) {
                this.selectInitialRepoFromPrefs(prefs);
            }
        } else if (prefs != null) {
            this.selectInitialRepoFromPrefs(prefs);
        }
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(composite);
    }

    private void selectInitialRepoFromPrefs(Preferences prefs) {
        ITeamRepository[] repos;
        ITeamRepository repository;
        String uri = prefs.get(LAST_REPOSITORY, "");
        try {
            repository = Repositories.getRepository(uri);
            boolean found = false;
            ITeamRepository[] repos2 = TeamPlatform.getTeamRepositoryService().getTeamRepositories();
            int i = 0;
            while (i < repos2.length) {
                ITeamRepository teamRepository = repos2[i];
                if (teamRepository == repository) {
                    found = true;
                    break;
                }
                ++i;
            }
            if (!found) {
                repository = null;
            }
        }
        catch (IllegalArgumentException e) {
            repository = null;
        }
        if (repository == null && (repos = TeamPlatform.getTeamRepositoryService().getTeamRepositories()).length > 0) {
            repository = repos[0];
        }
        if (repository != null) {
            this.setSelectedElement(repository);
        }
    }

    public void setLoginButtonText(String loginText) {
        this.loginAction.setText(loginText);
    }

    private void updateStatus() {
        ITeamRepository repository = this.getRepository();
        if (repository == null) {
            this.loginAction.setEnabled(false);
            this.loginButton.setEnabled(false);
            this.validationStatus.setValue((Object)StatusUtil.newStatus((Object)this, (int)4, (String)Messages.RepositoryCombo_5));
        } else {
            boolean loggedIn = repository.loggedIn();
            this.loginAction.setEnabled(!loggedIn && this.repo.getEnabled());
            this.loginButton.setEnabled(!loggedIn && this.repo.getEnabled());
            if (!loggedIn && (this.flags & 1) != 0) {
                this.validationStatus.setValue((Object)StatusUtil.newStatus((Object)this, (String)Messages.RepositoryCombo_6));
            } else {
                this.validationStatus.setValue((Object)Status.OK_STATUS);
            }
        }
    }

    private void updateListener() {
        ITeamRepository repository = this.getRepository();
        if (this.currentlyListening != null) {
            this.currentlyListening.removeGenericListener((Object)"state", this.eventListener);
        }
        this.currentlyListening = repository;
        if (this.currentlyListening != null) {
            this.currentlyListening.addGenericListener((Object)"state", this.eventListener);
        }
    }

    protected void openRepositoryCreationDialog() {
        Shell shell = this.repo.getControl().getShell();
        final RepositoryCreationPage page = new RepositoryCreationPage(Messages.RepositoryCombo_7, Messages.RepositoryCombo_8);
        WizardUtil.open((Shell)shell, (String)Messages.RepositoryCombo_9, (IWizardPage)page, (IRunnableWithResult)new IRunnableWithResult<Boolean>(){

            public Boolean run() {
                ITeamRepository r = page.createRepository(false);
                if (r != null) {
                    RepositoryUtils.asyncLogin(r, RepositoryCombo.this.background);
                    RepositoryCombo.this.repo.setSelectedElement((Object)r);
                }
                return true;
            }
        }, (String)"com.ibm.team.filesystem.ide.ui.wizard_createrepositoryconnection");
    }

    public void setSelectedElement(ITeamRepository repository) {
        this.repo.setSelectedElement((Object)repository);
    }

    public Control getControl() {
        return this.repo.getControl().getParent();
    }

    public ITeamRepository getRepository() {
        return (ITeamRepository)this.repo.getSelectedElement();
    }

    public ISelectionProvider getSelectionProvider() {
        return this.repo.getSelectionProvider();
    }

    public IObservableValue getValidationStatus() {
        return this.validationStatus;
    }

    protected void disposed() {
        if (this.prefs != null) {
            ITeamRepository repository = this.getRepository();
            if (repository != null) {
                this.prefs.put(LAST_REPOSITORY, repository == null ? "" : repository.getRepositoryURI());
            }
            try {
                this.prefs.flush();
            }
            catch (BackingStoreException e) {
                StatusUtil.log((Object)this, (Throwable)e);
            }
        }
        if (this.currentlyListening != null) {
            this.currentlyListening.removeGenericListener((Object)"state", this.eventListener);
        }
    }

    public void setEnabled(boolean enablement) {
        this.repo.setEnabled(enablement);
        this.updateStatus();
    }
}

