/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.picker;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.ui.wrapper.ContributorWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.picker.ContributorPicker;
import com.ibm.team.internal.filesystem.ui.picker.TeamAreaPicker;
import com.ibm.team.internal.filesystem.ui.util.RepositoryUtils;
import com.ibm.team.process.common.IDevelopmentLine;
import com.ibm.team.process.common.IDevelopmentLineHandle;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.process.common.ITeamAreaHandle;
import com.ibm.team.process.common.ITeamAreaHierarchy;
import com.ibm.team.process.common.TeamAreaHierarchyException;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.internal.menus.IActionExt;
import com.ibm.team.repository.rcp.ui.internal.menus.IMenuExt;
import com.ibm.team.repository.rcp.ui.internal.menus.MenuExt;
import com.ibm.team.repository.rcp.ui.internal.menus.PushAction;
import com.ibm.team.repository.rcp.ui.internal.viewers.ComboWithActions;
import com.ibm.team.repository.rcp.ui.internal.viewers.DelegatingLabelProvider;
import com.ibm.team.repository.rcp.ui.internal.viewers.EmptySetWithListeners;
import com.ibm.team.repository.rcp.ui.internal.viewers.ISetWithListeners;
import com.ibm.team.repository.rcp.ui.labelproviders.LabelProviders;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.repository.rcp.ui.utils.UIContext;
import com.ibm.team.repository.rcp.ui.utils.WidgetFactoryContext;
import com.ibm.team.scm.client.internal.RepoFetcher;
import com.ibm.team.scm.common.internal.util.ItemId;
import java.util.Collections;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IViewerLabelProvider;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class OwnerSelectionField {
    public static final int FLAG_USER = 1;
    public static final int FLAG_TEAM_AREA = 2;
    public static final int FLAG_PROJECT_AREA = 8;
    public static final int FLAG_INCLUDE_ANY_NODE = 4;
    private int flags;
    private IOperationRunner runner;
    private ComboWithActions<Object, Object> combo;
    private ITeamRepository repo;
    private static String ANY_NODE = Messages.OwnerSelectionField_0;

    public OwnerSelectionField(Composite parent, WidgetFactoryContext context, ITeamRepository repo, int flags) {
        this.flags = flags;
        PushAction otherUserAction = new PushAction(Messages.OwnerSelectionField_1, new Runnable(){

            @Override
            public void run() {
                OwnerSelectionField.this.otherUserPressed();
            }
        });
        PushAction meAction = new PushAction(Messages.OwnerSelectionField_2, new Runnable(){

            @Override
            public void run() {
                OwnerSelectionField.this.meButtonPressed();
            }
        });
        PushAction teamAreaAction = new PushAction(Messages.OwnerSelectionField_3, new Runnable(){

            @Override
            public void run() {
                OwnerSelectionField.this.otherTeamAreaButtonPressed();
            }
        });
        this.runner = context.getBackgroundOperationRunner();
        this.combo = new ComboWithActions(parent);
        MenuExt menu = new MenuExt();
        if ((flags & 1) != 0) {
            menu.add((IActionExt)meAction);
            menu.add((IActionExt)otherUserAction);
        }
        if ((flags & 2) != 0) {
            menu.add((IActionExt)teamAreaAction);
        }
        this.combo.setMenu((IMenuExt)menu);
        if ((flags & 4) != 0) {
            this.combo.addSpecialValue((Object)ANY_NODE);
        }
        this.combo.setLabelProvider((IViewerLabelProvider)new DelegatingLabelProvider(LabelProviders.create((ISetWithListeners)this.combo.getKnownElements())){

            public void updateLabel(ViewerLabel label, Object element) {
                super.updateLabel(label, element);
                if (element instanceof ITeamArea) {
                    ITeamArea ta = (ITeamArea)element;
                    String name = ta.getName();
                    String developmentLineName = this.getDevelopmentLineName(ta);
                    if (developmentLineName != null) {
                        label.setText(NLS.bind((String)Messages.OwnerSelectionField_8, (Object)name, (Object)developmentLineName));
                    }
                }
            }

            private String getDevelopmentLineName(ITeamArea teamArea) {
                IDevelopmentLine devLine;
                IDevelopmentLineHandle devLineHandle;
                IProjectAreaHandle projectAreaHandle = teamArea.getProjectArea();
                ITeamRepository repo = (ITeamRepository)teamArea.getOrigin();
                if (repo == null || !repo.loggedIn() || repo.getErrorState() != 0) {
                    return null;
                }
                IProjectArea projectArea = (IProjectArea)repo.itemManager().getSharedItemIfKnown((IItemHandle)projectAreaHandle);
                if (projectArea == null) {
                    return null;
                }
                ITeamAreaHierarchy hierarchy = projectArea.getTeamAreaHierarchy();
                ITeamAreaHandle parentTeamAreaHandle = null;
                try {
                    parentTeamAreaHandle = hierarchy.getParent((ITeamAreaHandle)teamArea.getItemHandle());
                }
                catch (TeamAreaHierarchyException teamAreaHierarchyException) {
                    // empty catch block
                }
                if (parentTeamAreaHandle != null && (devLineHandle = hierarchy.getDevelopmentLine((ITeamAreaHandle)teamArea)) != null && (devLine = (IDevelopmentLine)repo.itemManager().getSharedItemIfKnown((IItemHandle)devLineHandle)) != null) {
                    return devLine.getLabel();
                }
                return null;
            }
        });
        this.setRepository(repo);
    }

    public void setRepository(ITeamRepository repo) {
        this.combo.setEnabled(repo != null);
        if (this.repo == repo) {
            return;
        }
        this.repo = repo;
        this.combo.setInput((ISetWithListeners)EmptySetWithListeners.createInstance());
    }

    protected void otherTeamAreaButtonPressed() {
        final ITeamRepository repository = this.getRepository();
        this.runLoggedIn(new Runnable(){

            @Override
            public void run() {
                boolean teamAreasOnly = (OwnerSelectionField.this.flags & 8) == 0;
                IProcessArea result = TeamAreaPicker.selectProcessArea(OwnerSelectionField.this.getShell(), repository, teamAreasOnly, false);
                if (result != null) {
                    OwnerSelectionField.this.selectArea((ItemId<? extends IProcessArea>)new ItemId((IItemHandle)result));
                }
            }
        });
    }

    protected void meButtonPressed() {
        final ITeamRepository repository = this.getRepository();
        this.runLoggedIn(new Runnable(){

            @Override
            public void run() {
                ContributorWrapper cw = new ContributorWrapper(repository, repository.loggedInContributor());
                OwnerSelectionField.this.combo.setSelectedElement((Object)cw);
            }
        });
    }

    protected void otherUserPressed() {
        final Display display = Display.getCurrent();
        final ITeamRepository repository = this.getRepository();
        this.runLoggedIn(new Runnable(){

            @Override
            public void run() {
                try {
                    UIContext uiContext = UIContext.createShellContext((Shell)OwnerSelectionField.this.getShell());
                    String shellTitle = Messages.OwnerSelectionField_4;
                    String dialogTitle = Messages.OwnerSelectionField_9;
                    String dialogMessage = Messages.OwnerSelectionField_5;
                    ItemId<IContributor> contributor = ContributorPicker.pickContributor(uiContext, shellTitle, dialogTitle, dialogMessage, repository, Collections.EMPTY_LIST);
                    OwnerSelectionField.this.selectContributor(display, repository, (ItemId<IContributor>)contributor);
                }
                catch (OperationCanceledException operationCanceledException) {
                    // empty catch block
                }
            }
        });
    }

    private void selectArea(final ItemId<? extends IProcessArea> result) {
        final ITeamRepository repo = this.getRepository();
        if (repo == null) {
            return;
        }
        final Display display = Display.getCurrent();
        this.runner.enqueue(Messages.OwnerSelectionField_6, (Operation)new RepositoryOperation(){

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, FileSystemException, OperationFailedException {
                final IProcessArea fetched = (IProcessArea)RepoFetcher.fetchCurrent((ITeamRepository)repo, (ItemId)result, (IProgressMonitor)monitor);
                display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        OwnerSelectionField.this.combo.setSelectedElement((Object)fetched);
                    }
                });
            }
        });
    }

    private void selectContributor(final Display display, final ITeamRepository repo, final ItemId<IContributor> contributor) {
        if (repo == null) {
            return;
        }
        this.runner.enqueue(Messages.OwnerSelectionField_7, (Operation)new RepositoryOperation(){

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, FileSystemException, OperationFailedException {
                final IContributor fetched = (IContributor)RepoFetcher.fetchCurrent((ITeamRepository)repo, (ItemId)contributor, (IProgressMonitor)monitor);
                display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        ContributorWrapper cw = new ContributorWrapper(repo, fetched);
                        OwnerSelectionField.this.combo.setSelectedElement((Object)cw);
                    }
                });
            }
        });
    }

    protected Shell getShell() {
        return this.combo.getControl().getShell();
    }

    private void runLoggedIn(Runnable runnable) {
        UIContext context = UIContext.createShellContext((Shell)this.getShell());
        ITeamRepository repository = this.getRepository();
        if (repository == null) {
            return;
        }
        RepositoryUtils.loggedInDo(context, repository, runnable);
    }

    private ITeamRepository getRepository() {
        return this.repo;
    }

    public ItemId<? extends IAuditable> getSelection() {
        Object selectedElement = this.combo.getSelectedElement();
        if (selectedElement instanceof ContributorWrapper) {
            return ItemId.create((IItemHandle)((ContributorWrapper)((Object)selectedElement)).getContributor());
        }
        if (selectedElement instanceof IAuditableHandle) {
            return ItemId.create((IItemHandle)((IAuditableHandle)selectedElement));
        }
        return null;
    }

    public Control getControl() {
        return this.combo.getControl();
    }

    public void selectTheAnyNode() {
        this.combo.selectSpecialValue((Object)ANY_NODE);
    }

    public void setSelection(ItemId<? extends IAuditable> ownedBy) {
        if (ownedBy.isNull()) {
            if ((this.flags & 4) != 0) {
                this.combo.setSelectedElement((Object)ANY_NODE);
            } else {
                this.combo.setSelectedElement(null);
            }
            return;
        }
        if (ownedBy.getItemType() == IContributor.ITEM_TYPE) {
            this.selectContributor(Display.getCurrent(), this.getRepository(), ownedBy);
        } else {
            this.selectArea(ownedBy);
        }
    }

    public ISelectionProvider getSelectionProvider() {
        return this.combo.getSelectionProvider();
    }
}

