/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.picker;

import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.picker.OwnerTreeContentProvider;
import com.ibm.team.internal.filesystem.ui.util.RepositoryUtils;
import com.ibm.team.jface.labelProviders.ElementRemovedNotifierImpl;
import com.ibm.team.jface.labelProviders.IElementRemovedNotifier;
import com.ibm.team.jface.labelProviders.StandardLabelProvider;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.process.common.ITeamAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.scm.common.dto.IReadScope;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;

public class OwnerPicker
extends ElementTreeSelectionDialog {
    private final ITeamRepository fRepo;
    private final String fDescription;
    private boolean fIsPrivateToTeamArea;

    public OwnerPicker(Shell shell, ITeamRepository repo, String description) {
        super(shell, (ILabelProvider)new StandardLabelProvider((IElementRemovedNotifier)new ElementRemovedNotifierImpl()), (ITreeContentProvider)new OwnerTreeContentProvider());
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.fRepo = repo;
        this.fDescription = description;
        this.setInput(this.fRepo);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.OwnerPicker_DefaultTitle);
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(Messages.OwnerPicker_DefaultTitle);
        if (this.fDescription != null) {
            this.setMessage(this.fDescription);
        } else {
            this.setMessage(Messages.OwnerPicker_DefaultDescription);
        }
        Composite composite = (Composite)super.createDialogArea(parent);
        final Button isPrivateToTeamAreaButton = new Button(composite, 32);
        this.getTreeViewer().addPostSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ITreeSelection selection = (ITreeSelection)event.getSelection();
                isPrivateToTeamAreaButton.setEnabled(selection.getFirstElement() instanceof ITeamAreaHandle);
            }
        });
        isPrivateToTeamAreaButton.setText(Messages.OwnerPicker_TeamPrivateLabel);
        isPrivateToTeamAreaButton.setLayoutData((Object)new GridData(16384, 1024, true, false, 1, 1));
        isPrivateToTeamAreaButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                OwnerPicker.this.fIsPrivateToTeamArea = isPrivateToTeamAreaButton.getSelection();
            }
        });
        this.setEmptyListMessage(NLS.bind((String)Messages.OwnerPicker_NoProjectAreasMsg, (Object)RepositoryUtils.getLabel(this.fRepo)));
        this.setAllowMultiple(false);
        this.setValidator(new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                if (selection.length < 1) {
                    return new Status(4, "com.ibm.team.filesystem.ide.ui", "");
                }
                Object owner = selection[0];
                if (!(owner instanceof IProjectAreaHandle || owner instanceof ITeamAreaHandle || owner instanceof IContributorHandle)) {
                    return new Status(4, "com.ibm.team.filesystem.ide.ui", Messages.OwnerPicker_InvalidSelectionTypeErrorMsg);
                }
                return new Status(0, "com.ibm.team.filesystem.ide.ui", "");
            }
        });
        this.setHelpAvailable(false);
        return composite;
    }

    public boolean isPrivateToTeamArea() {
        return this.fIsPrivateToTeamArea;
    }

    public IAuditable getOwner() {
        Object obj = this.getFirstResult();
        if (obj != null && obj instanceof IAuditable) {
            return (IAuditable)obj;
        }
        return null;
    }

    public IReadScope getReadScope() {
        Object scope = null;
        IAuditable newOwner = this.getOwner();
        if (newOwner != null) {
            if (newOwner instanceof ITeamArea) {
                scope = this.fIsPrivateToTeamArea ? IReadScope.FACTORY.createTeamAreaPrivateScope() : IReadScope.FACTORY.createProcessAreaScope((IProcessAreaHandle)newOwner);
            }
            if (newOwner instanceof IProjectArea) {
                scope = IReadScope.FACTORY.createProcessAreaScope((IProcessAreaHandle)newOwner);
            }
            if (newOwner instanceof IContributorHandle) {
                scope = IReadScope.FACTORY.createPrivateScope();
            }
        }
        return scope;
    }

    protected TreeViewer createTreeViewer(Composite parent) {
        this.setAllowMultiple(false);
        TreeViewer treeViewer = super.createTreeViewer(parent);
        treeViewer.setComparator(new ViewerComparator(){

            public int category(Object element) {
                if (element instanceof IProjectAreaHandle) {
                    return 0;
                }
                if (element instanceof ITeamAreaHandle) {
                    return 1;
                }
                if (element instanceof IContributorHandle) {
                    return 2;
                }
                return super.category(element);
            }

            public int compare(Viewer viewer, Object e1, Object e2) {
                if (e1 instanceof IProcessArea && e2 instanceof IProcessArea) {
                    IProcessArea p1 = (IProcessArea)e1;
                    IProcessArea p2 = (IProcessArea)e2;
                    return super.compare(viewer, (Object)p1.getName(), (Object)p2.getName());
                }
                if (e1 instanceof IContributor && e2 instanceof IContributor) {
                    IContributor c1 = (IContributor)e1;
                    IContributor c2 = (IContributor)e2;
                    return super.compare(viewer, (Object)c1.getName(), (Object)c2.getName());
                }
                return super.compare(viewer, e1, e2);
            }
        });
        return treeViewer;
    }
}

