/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.picker;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalProvider;

public class MultiContentProposalProvider
implements IContentProposalProvider {
    private String fSeparator;
    private String[] fProposals;

    public void setSeparator(String separator) {
        this.fSeparator = separator;
    }

    public void setProposals(String[] proposals) {
        this.fProposals = proposals;
    }

    public IContentProposal[] getProposals(String contents, int position) {
        if (this.fSeparator != null) {
            return this.handleMultiValueProposals(contents, position);
        }
        String proposalPrefix = contents.substring(0, position).trim();
        return this.handleSingleValueProposals(proposalPrefix, "", "", Collections.emptyList());
    }

    private IContentProposal[] handleMultiValueProposals(String contents, int position) {
        String contentPrefix = this.createContentPrefix(contents, position);
        String contentSuffix = this.createContentSuffix(contents, position);
        String proposalPrefix = this.createProposalPrefix(contents, position);
        String[] parts = contents.split(this.fSeparator);
        ArrayList<String> filter = new ArrayList<String>();
        String[] stringArray = parts;
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            String part = stringArray[n2];
            filter.add(part.trim());
            ++n2;
        }
        return this.handleSingleValueProposals(proposalPrefix, contentPrefix, contentSuffix, filter);
    }

    private String createContentPrefix(String contents, int position) {
        int end = this.getProposalStartIndex(contents, position);
        return contents.substring(0, end);
    }

    private String createProposalPrefix(String contents, int position) {
        int start = this.getProposalStartIndex(contents, position);
        return contents.substring(start > position ? position : start, position).trim();
    }

    private String createContentSuffix(String contents, int position) {
        int rightBound = contents.indexOf(this.fSeparator, position);
        int start = rightBound > -1 ? rightBound : contents.length();
        while (start > 0 && Character.isWhitespace(contents.charAt(start - 1))) {
            --start;
        }
        return contents.substring(start);
    }

    private int getProposalStartIndex(String contents, int position) {
        int leftBound = contents.lastIndexOf(this.fSeparator, position > 0 ? position - 1 : position);
        int start = leftBound > -1 ? leftBound + 1 : 0;
        while (start < position && Character.isWhitespace(contents.charAt(start))) {
            ++start;
        }
        return start;
    }

    private IContentProposal[] handleSingleValueProposals(String proposalPrefix, String contentPrefix, String contentSuffix, Collection<String> filter) {
        ArrayList<SimpleContentProposal> list = new ArrayList<SimpleContentProposal>();
        String[] stringArray = this.fProposals;
        int n = this.fProposals.length;
        int n2 = 0;
        while (n2 < n) {
            String proposal = stringArray[n2];
            if (proposal.length() > proposalPrefix.length() && proposal.substring(0, proposalPrefix.length()).equalsIgnoreCase(proposalPrefix) && !filter.contains(proposal)) {
                list.add(new SimpleContentProposal(proposal, contentPrefix, contentSuffix));
            }
            ++n2;
        }
        return list.toArray(new IContentProposal[list.size()]);
    }

    private static class SimpleContentProposal
    implements IContentProposal {
        private String fProposal;
        private String fPrefix;
        private String fSuffix;

        public SimpleContentProposal(String proposal, String prefix, String suffix) {
            this.fProposal = proposal;
            this.fPrefix = prefix;
            this.fSuffix = suffix;
        }

        public String getContent() {
            return String.valueOf(this.fPrefix) + this.fProposal + this.fSuffix;
        }

        public int getCursorPosition() {
            return this.fPrefix.length() + this.fProposal.length();
        }

        public String getDescription() {
            return null;
        }

        public String getLabel() {
            return this.fProposal;
        }
    }
}

