/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.picker;

import com.ibm.team.filesystem.ui.wrapper.AbstractPlaceWrapper;
import com.ibm.team.filesystem.ui.wrapper.BaselineWrapper;
import com.ibm.team.filesystem.ui.wrapper.RawSnapshotWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.repository.rcp.ui.internal.utils.BaseLabelProvider;
import com.ibm.team.repository.rcp.ui.internal.viewers.ISetWithListeners;
import com.ibm.team.repository.rcp.ui.labelproviders.LabelProviders;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IViewerLabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.ViewerLabel;

public class MixedLocationLabelProvider
extends BaseLabelProvider {
    private IViewerLabelProvider defaultLabelProvider;
    private ILabelProviderListener listener = new ILabelProviderListener(){

        public void labelProviderChanged(LabelProviderChangedEvent event) {
            MixedLocationLabelProvider.this.fireChangeEvent(event.getElements());
        }
    };

    public MixedLocationLabelProvider(ISetWithListeners elements, IOperationRunner operationRunner) {
        this.defaultLabelProvider = LabelProviders.create((ISetWithListeners)elements);
    }

    protected void firstListenerAdded() {
        this.defaultLabelProvider.addListener(this.listener);
        super.firstListenerAdded();
    }

    protected void lastListenerRemoved() {
        super.lastListenerRemoved();
        this.defaultLabelProvider.removeListener(this.listener);
    }

    public void updateLabel(ViewerLabel label, Object element) {
        this.defaultLabelProvider.updateLabel(label, element);
        if (label.hasNewText()) {
            String oldText = label.getText();
            String format = null;
            if (element instanceof BaselineWrapper) {
                format = Messages.MixedLocationLabelProvider_0;
            } else if (element instanceof AbstractPlaceWrapper) {
                AbstractPlaceWrapper apw = (AbstractPlaceWrapper)((Object)element);
                format = apw.getWorkspace().isStream() ? Messages.MixedLocationLabelProvider_1 : Messages.MixedLocationLabelProvider_2;
            } else if (element instanceof RawSnapshotWrapper) {
                format = Messages.MixedLocationLabelProvider_3;
            }
            if (format != null) {
                String newText = NLS.bind((String)format, (Object)oldText, (Object[])new Object[0]);
                label.setText(newText);
            }
        }
    }
}

