/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.picker;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.internal.namespace.ItemLocator;
import com.ibm.team.filesystem.client.internal.namespace.ItemNamespace;
import com.ibm.team.filesystem.client.internal.namespace.WorkspaceNamespace;
import com.ibm.team.filesystem.ui.wrapper.ComponentWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.util.PendingChangesUtil;
import com.ibm.team.internal.filesystem.ui.wizards.component.ComponentConfigurationPickerWizard;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.repository.rcp.ui.parts.impl.IPartResult;
import com.ibm.team.repository.rcp.ui.utils.UIContext;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IWorkspaceHandle;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;

public class LocationPicker {
    public static void pickLocation(final UIContext context, final String windowTitle, final String description, final ItemNamespace optionalDefaultWorkspace, final ItemLocator<IComponent> componentId, final boolean allowFlowTargets, final IPartResult<ComponentConfigurationPickerWizard.ComponentConfigurationPickerResult> callback) {
        context.getUserOperationRunner().enqueue(Messages.LocationPicker_opening_picker_progress, (Operation)new RepositoryOperation(){

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, FileSystemException, OperationFailedException {
                LocationPicker.pickLocation(context, windowTitle, description, optionalDefaultWorkspace, (ItemLocator<IComponent>)componentId, allowFlowTargets, (IPartResult<ComponentConfigurationPickerWizard.ComponentConfigurationPickerResult>)callback, monitor);
            }
        });
    }

    public static void pickLocation(final UIContext context, final String windowTitle, final String description, ItemNamespace optionalDefaultWorkspace, ItemLocator<IComponent> componentId, final boolean showFlowTargets, final IPartResult<ComponentConfigurationPickerWizard.ComponentConfigurationPickerResult> callback, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IWorkspaceHandle sourceWorkspace = null;
        IWorkspaceHandle additionalWorkspace = null;
        if (optionalDefaultWorkspace != null && optionalDefaultWorkspace instanceof WorkspaceNamespace) {
            WorkspaceNamespace cc;
            WorkspaceNamespace wn = (WorkspaceNamespace)optionalDefaultWorkspace;
            sourceWorkspace = (IWorkspaceHandle)wn.getWorkspaceId().toHandle();
            ItemNamespace currentCollaboration = PendingChangesUtil.getCurrentIncomingCollaboration(wn, (IProgressMonitor)progress.newChild(20));
            if (currentCollaboration instanceof WorkspaceNamespace) {
                cc = (WorkspaceNamespace)currentCollaboration;
                additionalWorkspace = (IWorkspaceHandle)cc.getWorkspaceId().toHandle();
            }
            if (additionalWorkspace == null && (currentCollaboration = PendingChangesUtil.getCurrentOutgoingCollaboration(wn, (IProgressMonitor)progress.newChild(20))) instanceof WorkspaceNamespace) {
                cc = (WorkspaceNamespace)currentCollaboration;
                additionalWorkspace = (IWorkspaceHandle)cc.getWorkspaceId().toHandle();
            }
        }
        progress.setWorkRemaining(50);
        final ComponentWrapper component = ComponentWrapper.createFrom(componentId, (IProgressMonitor)progress.newChild(50));
        final IWorkspaceHandle finalSourceWorkspace = sourceWorkspace;
        final IWorkspaceHandle finalAdditionalWorkspace = additionalWorkspace;
        context.asyncExec(new Runnable(){

            @Override
            public void run() {
                ComponentConfigurationPickerWizard wizard = new ComponentConfigurationPickerWizard(new ComponentConfigurationPickerWizard.ConfigurationPickerInput(ComponentConfigurationPickerWizard.ConfigurationPickerInput.ConfigurationPickerMode.NON_SPECIFIC, false), component, finalSourceWorkspace, finalAdditionalWorkspace, showFlowTargets, false, (IPartResult<ComponentConfigurationPickerWizard.ComponentConfigurationPickerResult>)callback);
                wizard.setWindowTitle(windowTitle);
                wizard.setDescription(description);
                WizardDialog dialog = new WizardDialog(context.getShell(), (IWizard)wizard);
                dialog.setBlockOnOpen(false);
                dialog.open();
            }
        });
    }
}

