/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.picker;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.internal.namespace.ItemNamespace;
import com.ibm.team.filesystem.client.internal.snapshot.SnapshotId;
import com.ibm.team.filesystem.common.internal.util.StringUtils;
import com.ibm.team.filesystem.ui.WORKSPACES_OR_STREAMS;
import com.ibm.team.filesystem.ui.WorkspaceAndStreamSelectionDialog;
import com.ibm.team.filesystem.ui.queries.LoadedPlacesQuery;
import com.ibm.team.filesystem.ui.wrapper.AbstractPlaceWrapper;
import com.ibm.team.filesystem.ui.wrapper.ContextWrapper;
import com.ibm.team.internal.filesystem.ui.BaselineSelectionDialog;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.adapters.WrapperUtil;
import com.ibm.team.internal.filesystem.ui.picker.MixedLocationLabelProvider;
import com.ibm.team.internal.filesystem.ui.util.RepositoryUtils;
import com.ibm.team.internal.filesystem.ui.wizards.component.ComponentConfigurationPickerWizard;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.internal.menus.IActionExt;
import com.ibm.team.repository.rcp.ui.internal.menus.IMenuExt;
import com.ibm.team.repository.rcp.ui.internal.menus.MenuExt;
import com.ibm.team.repository.rcp.ui.internal.menus.PushAction;
import com.ibm.team.repository.rcp.ui.internal.viewers.ComboWithActions;
import com.ibm.team.repository.rcp.ui.internal.viewers.EmptySetWithListeners;
import com.ibm.team.repository.rcp.ui.internal.viewers.ISetWithListeners;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.repository.rcp.ui.parts.impl.IPartResult;
import com.ibm.team.repository.rcp.ui.utils.UIContext;
import com.ibm.team.repository.rcp.ui.utils.WidgetFactoryContext;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.internal.util.ItemId;
import java.util.Collections;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IViewerLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class LocationCombo {
    public static final int FLAG_NONE = 0;
    public static final int FLAG_INCLUDE_ANY_NODE = 1;
    public static final int FLAG_INCLUDE_ONE_NODE = 32;
    public static final int FLAG_INCLUDE_BASELINES = 2;
    public static final int FLAG_INCLUDE_WORKSPACES = 4;
    public static final int FLAG_REQUIRED = 16;
    public static final String ANY_NODE_DEFAULT_TEXT = Messages.LocationCombo_0;
    public static final String ONE_NODE_DEFAULT_TEXT = Messages.LocationCombo_9;
    private ComboWithActions combo;
    private IOperationRunner runner;
    private ITeamRepository repo;
    private int flags;
    private WritableValue validationStatus = new WritableValue();
    private String anyNodeText = ANY_NODE_DEFAULT_TEXT;
    private String oneNodeText = ONE_NODE_DEFAULT_TEXT;
    private String specialNodeText;
    private boolean anyNodePresent;
    private boolean oneNodePresent;
    private ISelectionChangedListener validationListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            LocationCombo.this.updateValidationState();
        }
    };
    private ItemId<IComponent> component = ItemId.getNullItem((IItemType)IComponent.ITEM_TYPE);

    public LocationCombo(Composite parent, WidgetFactoryContext context, ITeamRepository repo, int flags) {
        this(parent, context, repo, flags, (flags & 1) == 1 ? ANY_NODE_DEFAULT_TEXT : ((flags & 0x20) == 32 ? ONE_NODE_DEFAULT_TEXT : ANY_NODE_DEFAULT_TEXT));
    }

    public LocationCombo(Composite parent, WidgetFactoryContext context, ITeamRepository repo, int flags, String specialNodeText) {
        this.flags = flags;
        MenuExt menu = new MenuExt();
        PushAction browseWorkspaceAction = new PushAction((flags & 4) == 0 ? Messages.LocationCombo_8 : Messages.LocationCombo_1, new Runnable(){

            @Override
            public void run() {
                LocationCombo.this.browseWorkspacePressed();
            }
        });
        menu.add((IActionExt)browseWorkspaceAction);
        if ((flags & 2) != 0) {
            PushAction browseBaselineAction = new PushAction(Messages.LocationCombo_2, new Runnable(){

                @Override
                public void run() {
                    LocationCombo.this.browseBaselinePressed();
                }
            });
            menu.add((IActionExt)browseBaselineAction);
        }
        this.runner = context.getBackgroundOperationRunner();
        this.combo = new ComboWithActions(parent);
        this.combo.setMenu((IMenuExt)menu);
        if ((flags & 1) == 1) {
            this.anyNodePresent = true;
            this.oneNodePresent = false;
            if (!StringUtils.isEmpty((String)specialNodeText)) {
                this.specialNodeText = this.anyNodeText = specialNodeText;
            }
            this.combo.addSpecialValue((Object)this.anyNodeText);
        } else if ((flags & 0x20) == 32) {
            this.anyNodePresent = false;
            this.oneNodePresent = true;
            if (!StringUtils.isEmpty((String)specialNodeText)) {
                this.specialNodeText = this.oneNodeText = specialNodeText;
            }
            this.combo.addSpecialValue((Object)this.oneNodeText);
        }
        this.combo.setLabelProvider((IViewerLabelProvider)new MixedLocationLabelProvider(this.combo.getKnownElements(), this.runner));
        this.combo.getSelectionProvider().addSelectionChangedListener(this.validationListener);
        this.setRepository(repo);
        this.updateValidationState();
    }

    public void setComponent(ItemId<IComponent> component) {
        this.component = component;
    }

    private void updateValidationState() {
        if ((this.flags & 0x10) != 0 && this.getSelectedSnapshot() == null) {
            this.validationStatus.setValue((Object)StatusUtil.newStatus((Object)this, (String)Messages.LocationCombo_3));
        } else {
            this.validationStatus.setValue((Object)Status.OK_STATUS);
        }
    }

    protected void browseBaselinePressed() {
        if (this.repo == null) {
            return;
        }
        RepositoryUtils.asyncLogin(this.repo, this.runner);
        final UIContext context = UIContext.createShellContext((Shell)this.combo.getControl().getShell());
        IComponentHandle componentHandle = (IComponentHandle)this.component.toHandle();
        BaselineSelectionDialog.getBaseline(new ComponentConfigurationPickerWizard.ConfigurationPickerInput(ComponentConfigurationPickerWizard.ConfigurationPickerInput.ConfigurationPickerMode.NON_SPECIFIC, false), context, Messages.LocationCombo_7, this.repo, null, null, componentHandle, new IPartResult<BaselineSelectionDialog.BaselineSelectionDialogResult>(){

            public void setResult(final BaselineSelectionDialog.BaselineSelectionDialogResult result) {
                LocationCombo.this.runner.enqueue(Messages.LocationCombo_6, (Operation)new RepositoryOperation(){

                    public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, FileSystemException, OperationFailedException {
                        final Object wrapper = WrapperUtil.createWrapperFromNamespace((ItemNamespace)result.getBaselineNamespace(), monitor);
                        context.asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                LocationCombo.this.combo.setSelectedElement(wrapper);
                            }
                        });
                    }
                });
            }
        });
    }

    private void browseWorkspacePressed() {
        if (this.repo == null) {
            return;
        }
        RepositoryUtils.asyncLogin(this.repo, this.runner);
        AbstractPlaceWrapper workspaceOrStream = WorkspaceAndStreamSelectionDialog.getWorkspaceOrStream(this.combo.getControl().getShell(), this.repo, null, null, WORKSPACES_OR_STREAMS.STREAMS, (this.flags & 4) != 0, null, Collections.EMPTY_LIST);
        if (workspaceOrStream != null) {
            this.combo.setSelectedElement((Object)workspaceOrStream);
        }
    }

    public void setRepository(ITeamRepository newRepository) {
        this.combo.getControl().setEnabled(newRepository != null);
        if (newRepository == null) {
            this.combo.setInput((ISetWithListeners)EmptySetWithListeners.createInstance());
        } else {
            boolean repoChanged = this.repo != null && !this.repo.equals(newRepository);
            this.combo.setInput((ISetWithListeners)new LoadedPlacesQuery(this.runner, (this.flags & 4) != 0, true, newRepository), repoChanged);
        }
        this.repo = newRepository;
    }

    public void setSelectedElement(Object wrapper) {
        this.combo.setSelectedElement(wrapper);
        if (this.isOneNodePresent()) {
            this.combo.removeSpecialValue((Object)this.oneNodeText);
        }
    }

    public Control getControl() {
        return this.combo.getControl();
    }

    public void setSelectedSnapshot(final SnapshotId snapshot) {
        final Display display = Display.getCurrent();
        this.runner.enqueue(Messages.LocationCombo_5, (Operation)new RepositoryOperation(){

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, FileSystemException, OperationFailedException {
                final Object selectedWrapper = WrapperUtil.createWrapperFromSnapshot(snapshot, monitor);
                display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        LocationCombo.this.combo.setSelectedElement(selectedWrapper);
                    }
                });
            }
        });
    }

    public SnapshotId getSelectedSnapshot() {
        Object sel = this.combo.getSelectedElement();
        if (sel == null) {
            return null;
        }
        return WrapperUtil.getSnapshotFromWrapper(sel);
    }

    public ContextWrapper getSelectedLocation() {
        Object result = this.combo.getSelectedElement();
        if (result instanceof ContextWrapper) {
            return (ContextWrapper)((Object)result);
        }
        return null;
    }

    public ISelectionProvider getSelectionProvider() {
        return this.combo.getSelectionProvider();
    }

    public IObservableValue getValidationStatus() {
        return this.validationStatus;
    }

    public boolean selectedTheAnyNode() {
        return this.combo.getSelectedSpecialValue() == this.anyNodeText;
    }

    public boolean selectedTheOneNode() {
        return this.combo.getSelectedSpecialValue() == this.oneNodeText;
    }

    public void selectTheAnyNode() {
        this.combo.selectSpecialValue((Object)this.anyNodeText);
        this.specialNodeText = this.anyNodeText;
    }

    public void selectTheOneNode() {
        this.combo.selectSpecialValue((Object)this.oneNodeText);
        this.specialNodeText = this.oneNodeText;
    }

    public void addTheAnyNode() {
        if (!this.isAnyNodePresent()) {
            this.anyNodePresent = true;
            this.combo.addSpecialValue((Object)this.anyNodeText);
            this.specialNodeText = this.anyNodeText;
        }
    }

    public void addTheOneNode() {
        if (!this.isOneNodePresent()) {
            this.oneNodePresent = true;
            this.combo.addSpecialValue((Object)this.oneNodeText);
            this.specialNodeText = this.oneNodeText;
        }
    }

    public boolean isTheAnyNodeSelected() {
        return this.combo.getSelectedSpecialValue() == this.anyNodeText;
    }

    public boolean isTheOneNodeSelected() {
        return this.combo.getSelectedSpecialValue() == this.oneNodeText;
    }

    public boolean isAnyNodePresent() {
        return this.anyNodePresent;
    }

    public boolean isOneNodePresent() {
        return this.oneNodePresent;
    }

    public void removeSpecialNode(String nodeName) {
        if (nodeName.equalsIgnoreCase(this.oneNodeText)) {
            if (this.isOneNodePresent()) {
                this.combo.removeSpecialValue((Object)this.oneNodeText);
                this.oneNodePresent = false;
            }
        } else if (nodeName.equalsIgnoreCase(this.anyNodeText) && this.isAnyNodePresent()) {
            this.combo.removeSpecialValue((Object)this.anyNodeText);
            this.anyNodePresent = false;
        }
    }

    public String getSpecialNodeText() {
        return !StringUtils.isEmpty((String)this.specialNodeText) ? this.specialNodeText : "";
    }
}

