/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.picker;

import com.ibm.team.containers.common.IItemContainerHandle;
import com.ibm.team.filesystem.ui.queries.FolderNode;
import com.ibm.team.filesystem.ui.queries.ItemContainerQuery;
import com.ibm.team.filesystem.ui.views.SimplePartInput;
import com.ibm.team.internal.filesystem.ui.ImagePool;
import com.ibm.team.internal.filesystem.ui.picker.Messages;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.rcp.ui.teamnavigator.ConnectedProjectAreaRegistry;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.repository.rcp.ui.internal.utils.BaseLabelProvider;
import com.ibm.team.repository.rcp.ui.internal.viewers.AbstractSetWithListeners;
import com.ibm.team.repository.rcp.ui.internal.viewers.ButtonBar;
import com.ibm.team.repository.rcp.ui.internal.viewers.ISetWithListeners;
import com.ibm.team.repository.rcp.ui.internal.viewers.ITreeProvider;
import com.ibm.team.repository.rcp.ui.internal.viewers.SimpleTreeViewer;
import com.ibm.team.repository.rcp.ui.parts.AbstractPart;
import com.ibm.team.repository.rcp.ui.parts.IBusyHandler;
import com.ibm.team.repository.rcp.ui.parts.IControlSite;
import com.ibm.team.repository.rcp.ui.parts.IPartFactory;
import com.ibm.team.repository.rcp.ui.parts.PartFactory;
import com.ibm.team.repository.rcp.ui.parts.Parts;
import com.ibm.team.repository.rcp.ui.parts.WidgetToolkit;
import com.ibm.team.repository.rcp.ui.parts.impl.IPartResult;
import com.ibm.team.repository.rcp.ui.parts.impl.MessageDialogFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IViewerLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;

public class ItemContainerPicker
extends AbstractPart
implements ITreeProvider,
Comparator<FolderNode> {
    private SimpleTreeViewer viewer;
    private SimplePartInput<ItemContainerPickerInput, ItemContainerPickerOutput> input;
    private Button okayButton;

    private static SimplePartInput<ItemContainerPickerInput, ItemContainerPickerOutput> createInput(ItemContainerPickerInput in, IPartResult<ItemContainerPickerOutput> result) {
        return new SimplePartInput<ItemContainerPickerInput, ItemContainerPickerOutput>(in, result);
    }

    public ItemContainerPicker(IControlSite site, SimplePartInput<ItemContainerPickerInput, ItemContainerPickerOutput> input) {
        this(Messages.ItemContainerPicker_windowTitle, site, input);
    }

    public ItemContainerPicker(String title, IControlSite site, SimplePartInput<ItemContainerPickerInput, ItemContainerPickerOutput> input) {
        super(site, input);
        this.input = input;
        site.getNameable().setName(title);
        WidgetToolkit toolkit = site.getToolkit();
        toolkit.createLabel(site.getParent(), Messages.ItemContainerPicker_promptMessage, 64);
        int flags = input.getInput().allowMultiSelect() ? 2 : 0;
        Tree theTree = toolkit.createTree(site.getParent(), flags);
        this.viewer = new SimpleTreeViewer(theTree, (ITreeProvider)this).setProgressService((IBusyHandler)site);
        this.viewer.setLabelProvider((IViewerLabelProvider)new LabelProvider());
        this.viewer.setSorter((Comparator)this);
        this.viewer.getSelectionProvider().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ItemContainerPicker.this.updateSelection();
            }
        });
        ButtonBar theButtonBar = new ButtonBar(site.getParent(), MessageDialogFactory.getChoicesForType((int)5), new IPartResult(){

            public void setResult(Object result) {
                if (result == MessageDialogFactory.OKAY.getValue()) {
                    ItemContainerPicker.this.okayClicked();
                } else {
                    ItemContainerPicker.this.getControlSite().close();
                }
            }
        });
        this.okayButton = theButtonBar.getButton(MessageDialogFactory.OKAY.getValue());
        site.setDefaultButton(this.okayButton);
        site.setSelectionProvider(this.viewer.getSelectionProvider());
        GridLayoutFactory.fillDefaults().generateLayout(this.getControlSite().getParent());
        this.viewer.setInput((Object)new RootNode());
        this.updateSelection();
    }

    protected void updateSelection() {
        this.okayButton.setEnabled(!this.viewer.getSelection().isEmpty());
    }

    protected void okayClicked() {
        if (!this.okayButton.isEnabled()) {
            return;
        }
        List objectList = this.viewer.getSelection().toList();
        ArrayList<FolderNode> folderNodes = new ArrayList<FolderNode>(objectList.size());
        for (Object obj : objectList) {
            if (!(obj instanceof FolderNode)) continue;
            folderNodes.add((FolderNode)obj);
        }
        final ItemContainerPickerOutput result = new ItemContainerPickerOutput(folderNodes);
        Display.getCurrent().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!ItemContainerPicker.this.okayButton.isDisposed()) {
                    ItemContainerPicker.this.input.setResult(result);
                    ItemContainerPicker.this.getControlSite().close();
                }
            }
        });
    }

    protected void doDoubleClick() {
        this.okayClicked();
    }

    public ISelectionProvider getSelectionProvider() {
        return this.viewer.getSelectionProvider();
    }

    public static List<FolderNode> pickFolder(Shell shell, ITeamRepository repo, List projectAreas, IContributorHandle contributor, boolean isMulti) {
        ItemContainerPickerInput input = new ItemContainerPickerInput(shell, repo, projectAreas, (IItemHandle)contributor, isMulti);
        return ItemContainerPicker.pickFolder(shell, input);
    }

    public static List<FolderNode> pickFolder(Shell shell, ITeamRepository repo, IContributorHandle contributor, boolean isMulti) {
        ConnectedProjectAreaRegistry registry = ConnectedProjectAreaRegistry.getDefault();
        if (registry == null) {
            return Collections.emptyList();
        }
        List connectedProjectAreas = registry.getConnectedProjectAreas(repo);
        ItemContainerPickerInput input = new ItemContainerPickerInput(shell, repo, connectedProjectAreas, (IItemHandle)contributor, isMulti);
        return ItemContainerPicker.pickFolder(shell, input);
    }

    private static List<FolderNode> pickFolder(Shell shell, ItemContainerPickerInput input) {
        final ArrayList<FolderNode> result = new ArrayList<FolderNode>();
        IPartResult<ItemContainerPickerOutput> partResult = new IPartResult<ItemContainerPickerOutput>(){

            public void setResult(ItemContainerPickerOutput output) {
                result.addAll(output.getFolderNodes());
            }
        };
        Parts.openModalDialog((Shell)shell, ItemContainerPicker.createInput(input, partResult), (IPartFactory)new PartFactory(ItemContainerPicker.class));
        return result;
    }

    public ISetWithListeners getChildren(Object parent) {
        if (parent instanceof RootNode) {
            boolean multipleRepos;
            ItemContainerPickerInput localInput = this.input.getInput();
            final ArrayList<FolderNode> result = new ArrayList<FolderNode>();
            boolean bl = multipleRepos = TeamPlatform.getTeamRepositoryService().getTeamRepositories().length > 1 && localInput.getRepo().getName() != null;
            if (localInput.showProjectArea()) {
                for (Object projectAreaObj : localInput.getProjectAreas()) {
                    IItemHandle projectAreaHandle = (IItemHandle)projectAreaObj;
                    String projectName = Messages.ItemContainerPicker_projectAreaLabel;
                    IItem projectArea = localInput.getRepo().itemManager().getSharedItemIfKnown(projectAreaHandle);
                    if (projectArea != null && projectArea instanceof IProjectArea) {
                        projectName = ((IProjectArea)projectArea).getName();
                    }
                    if (multipleRepos) {
                        projectName = NLS.bind((String)Messages.ItemContainerPicker_projectAreaLabel_multipleRepos, (Object)projectName, (Object[])new Object[]{localInput.getRepo().getName()});
                    }
                    result.add(new ProjectAreaFolder(projectName, localInput.getRepo(), projectAreaHandle));
                }
            }
            ConnectedProjectAreaRegistry.getDefault().getConnectedProjectAreas(null);
            if (localInput.showMyStuff()) {
                String name = null;
                name = multipleRepos ? NLS.bind((String)Messages.ItemContainerPicker_myStuffLabel_multipleRepos, (Object)localInput.getRepo().getName(), (Object[])new Object[0]) : Messages.ItemContainerPicker_myStuffLabel_singleRepo;
                result.add(new MyStuffFolder(name, localInput.getRepo(), localInput.getContributor()));
            }
            return new AbstractSetWithListeners<FolderNode>(){

                protected Collection<FolderNode> computeElements() {
                    return result;
                }
            };
        }
        if (parent instanceof FolderNode) {
            FolderNode node = (FolderNode)parent;
            ItemContainerQuery query = new ItemContainerQuery(node.getRepo(), node.getOwner(), (IItemContainerHandle)node.getItem(), this.getControlSite().getOperationRunner(), Collections.emptyList(), true);
            return query;
        }
        return null;
    }

    @Override
    public int compare(FolderNode obj1, FolderNode obj2) {
        if (obj1 instanceof ProjectAreaFolder) {
            if (obj2 instanceof MyStuffFolder) {
                return -1;
            }
            return obj1.getName().compareToIgnoreCase(obj2.getName());
        }
        if (obj1 instanceof MyStuffFolder) {
            if (obj2 instanceof ProjectAreaFolder) {
                return 1;
            }
            return obj1.getName().compareToIgnoreCase(obj2.getName());
        }
        return obj1.getName().compareToIgnoreCase(obj2.getName());
    }

    private static class ItemContainerPickerInput {
        private boolean allowMultiSelect;
        private ITeamRepository repo;
        private List projectAreas;
        private IItemHandle contributor;

        public ItemContainerPickerInput(Shell shell, ITeamRepository repo, List connectedProjectAreas, IItemHandle contributor, boolean isMulti) {
            this.allowMultiSelect = isMulti;
            this.repo = repo;
            this.projectAreas = connectedProjectAreas;
            this.contributor = contributor;
            this.allowMultiSelect = isMulti;
        }

        public boolean allowMultiSelect() {
            return this.allowMultiSelect;
        }

        public boolean showMyStuff() {
            return this.contributor != null;
        }

        public boolean showProjectArea() {
            return this.projectAreas != null && !this.projectAreas.isEmpty();
        }

        public ITeamRepository getRepo() {
            return this.repo;
        }

        public List getProjectAreas() {
            return this.projectAreas;
        }

        public IItemHandle getContributor() {
            return this.contributor;
        }
    }

    private static class ItemContainerPickerOutput {
        private List<FolderNode> folderNodes;

        public ItemContainerPickerOutput(List<FolderNode> folderNodes) {
            this.folderNodes = folderNodes;
        }

        public List<FolderNode> getFolderNodes() {
            return this.folderNodes;
        }
    }

    private class LabelProvider
    extends BaseLabelProvider {
        private Image myStuffImage = this.getImage(ImagePool.MY_STUFF_FOLDER);
        private Image projectAreaImage = this.getImage(ImagePool.PROJECT_AREA_FOLDER);
        private Image folderImage = this.getImage(ImagePool.FOLDER);

        public void updateLabel(ViewerLabel label, Object element) {
            Image icon = this.folderImage;
            if (element instanceof ProjectAreaFolder) {
                icon = this.projectAreaImage;
            } else if (element instanceof MyStuffFolder) {
                icon = this.myStuffImage;
            }
            if (element instanceof FolderNode) {
                FolderNode node = (FolderNode)element;
                label.setText(node.getName());
                label.setImage(icon);
            }
        }

        public void dispose() {
            this.myStuffImage = null;
            this.projectAreaImage = null;
            this.folderImage = null;
        }
    }

    private class MyStuffFolder
    extends FolderNode {
        public MyStuffFolder(String name, ITeamRepository repo, IItemHandle owner) {
            super(name, repo, owner);
        }
    }

    private class ProjectAreaFolder
    extends FolderNode {
        public ProjectAreaFolder(String name, ITeamRepository repo, IItemHandle owner) {
            super(name, repo, owner);
        }
    }

    private class RootNode {
        private RootNode() {
        }
    }
}

