/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.picker;

import com.ibm.team.internal.filesystem.ui.ImagePool;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.picker.TextControl;
import com.ibm.team.jface.calendar.DatePicker;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.internal.viewers.SettableSelectionProvider;
import com.ibm.team.repository.rcp.ui.parts.WidgetToolkit;
import com.ibm.team.repository.rcp.ui.utils.WidgetFactoryContext;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.Locale;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class DatePickerControl
extends SettableSelectionProvider {
    private ISelectionChangedListener fSelectionChangeListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            DatePickerControl.this.handleSelectionChanged(event);
        }
    };
    private TextControl fTextControl;
    private ToolBar fToolBar;
    private ToolItem fButton;
    private DateFormat fDateFormat;
    private Composite control;

    public DatePickerControl(Composite _parent, WidgetFactoryContext context, DateFormat dateFormat) {
        WidgetToolkit toolkit = context.getToolkit();
        this.control = toolkit.createComposite(_parent);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(this.control);
        this.fDateFormat = dateFormat;
        this.fTextControl = new TextControl(this.control, context, 2052);
        this.fTextControl.useMultiSelection(false);
        this.fTextControl.setValidator(new DateValidator(this.fDateFormat), TextControl.Options.VERIFY_WARN);
        this.fTextControl.addSelectionChangedListener(this.fSelectionChangeListener);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.fTextControl.getTextContainer());
        this.fToolBar = new ToolBar(this.control, 0x800000);
        this.fToolBar.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
        this.fToolBar.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = Messages.DatePickerControl_1;
            }
        });
        LocalResourceManager resourceManager = new LocalResourceManager(JFaceResources.getResources(), (Control)this.fToolBar);
        Image image = (Image)resourceManager.get((DeviceResourceDescriptor)ImagePool.DATE);
        this.fButton = new ToolItem(this.fToolBar, 8);
        this.fButton.setToolTipText(Messages.DatePickerControl_1);
        this.fButton.setImage(image);
        this.fButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DatePickerControl.this.handleButtonSelected(e);
            }
        });
    }

    public void setSelection(ISelection selection) {
        IStructuredSelection structuredSelection;
        if (selection instanceof IStructuredSelection && (structuredSelection = (IStructuredSelection)selection).getFirstElement() instanceof Timestamp) {
            Timestamp timestamp = (Timestamp)structuredSelection.getFirstElement();
            this.setTextSelection(timestamp);
        }
    }

    protected void handleButtonSelected(SelectionEvent e) {
        Rectangle bounds = this.fButton.getBounds();
        Point location = new Point(bounds.x, bounds.y);
        location = this.fToolBar.toDisplay(location);
        DatePicker datePicker = new DatePicker(this.fToolBar.getShell(), Locale.getDefault());
        Point datePickerPoint = datePicker.computeSize(-1, -1);
        datePicker.setLocation(location.x - datePickerPoint.x, location.y);
        datePicker.open();
        Date selected = datePicker.getDateObject();
        if (selected != null) {
            this.setTextSelection(new Timestamp(selected.getTime()));
        }
    }

    private void setTextSelection(Timestamp timestamp) {
        String formatted = this.fDateFormat.format(timestamp);
        this.fTextControl.setSelection((ISelection)new StructuredSelection((Object)formatted));
    }

    private void handleSelectionChanged(SelectionChangedEvent event) {
        if (event.getSelection() instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)event.getSelection();
            try {
                if (structuredSelection.isEmpty()) {
                    this.realSetSelection((ISelection)StructuredSelection.EMPTY);
                } else {
                    Date date = this.fDateFormat.parse(structuredSelection.getFirstElement().toString());
                    this.realSetSelection((ISelection)new StructuredSelection((Object)new Timestamp(date.getTime())));
                }
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
    }

    public void adapt(WidgetToolkit toolkit) {
        toolkit.adapt((Control)this.fTextControl.getTextControl(), true, false);
        toolkit.adapt((Composite)this.fToolBar);
    }

    public Control getControl() {
        return this.control;
    }

    private static class DateValidator
    implements IValidator {
        private DateFormat fDateFormat;
        private IStatus fErrorStatus;

        public DateValidator(DateFormat dateFormat) {
            this.fDateFormat = dateFormat;
            this.fErrorStatus = StatusUtil.newStatus((Object)this, (String)NLS.bind((String)Messages.DatePickerControl_0, (Object)this.fDateFormat.format(new Date())));
        }

        public IStatus validate(Object object) {
            String text = object.toString().trim();
            if (text.length() == 0) {
                return Status.OK_STATUS;
            }
            try {
                this.fDateFormat.parse(object.toString());
                return Status.OK_STATUS;
            }
            catch (ParseException e) {
                if (e.getErrorOffset() == text.length()) {
                    return Status.OK_STATUS;
                }
                return this.fErrorStatus;
            }
        }
    }
}

