/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.picker;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.ui.queries.LoadedComponentsQuery;
import com.ibm.team.filesystem.ui.wrapper.ComponentWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.util.RepositoryUtils;
import com.ibm.team.internal.filesystem.ui.wizards.component.ComponentSelectionPage;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.internal.menus.IActionExt;
import com.ibm.team.repository.rcp.ui.internal.menus.IMenuExt;
import com.ibm.team.repository.rcp.ui.internal.menus.PushAction;
import com.ibm.team.repository.rcp.ui.internal.menus.SingleEntryMenu;
import com.ibm.team.repository.rcp.ui.internal.viewers.ComboWithActions;
import com.ibm.team.repository.rcp.ui.internal.viewers.EmptySetWithListeners;
import com.ibm.team.repository.rcp.ui.internal.viewers.ISetWithListeners;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.repository.rcp.ui.utils.WidgetFactoryContext;
import com.ibm.team.repository.rcp.ui.wizards.IRunnableWithResult;
import com.ibm.team.repository.rcp.ui.wizards.WizardUtil;
import com.ibm.team.scm.client.internal.RepoFetcher;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.internal.util.ItemId;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public final class ComponentCombo {
    private ComboWithActions<ComponentWrapper, Object> combo;
    private IOperationRunner runner;
    private ITeamRepository repo;
    private boolean anyNodePresent;
    private boolean oneNodePresent;
    public static final String ANY_NODE_LABEL = Messages.ComponentCombo_0;
    public static final String ONE_NODE_LABEL = Messages.ComponentCombo_5;
    public static final int FLAG_NONE = 0;
    public static final int FLAG_INCLUDE_ANY_NODE = 1;
    public static final int FLAG_INCLUDE_ONE_NODE = 2;

    public ComponentCombo(Composite parent, WidgetFactoryContext context, int specialNodeFlags) {
        this(parent, context, null, specialNodeFlags);
    }

    public ComponentCombo(Composite parent, WidgetFactoryContext context, ITeamRepository repo, int specialNodeFlags) {
        PushAction newRepositoryAction = new PushAction(Messages.ComponentCombo_1, new Runnable(){

            @Override
            public void run() {
                ComponentCombo.this.browseButtonPressed();
            }
        });
        this.runner = context.getBackgroundOperationRunner();
        this.combo = new ComboWithActions(parent);
        this.combo.setMenu((IMenuExt)new SingleEntryMenu((IActionExt)newRepositoryAction));
        if ((specialNodeFlags & 1) != 0) {
            this.anyNodePresent = true;
            this.combo.addSpecialValue((Object)ANY_NODE_LABEL);
        } else if ((specialNodeFlags & 2) != 0) {
            this.oneNodePresent = true;
            this.combo.addSpecialValue((Object)ONE_NODE_LABEL);
        }
        this.setRepository(repo);
    }

    public void setRepository(ITeamRepository repository) {
        this.combo.getControl().setEnabled(repository != null);
        if (repository == null) {
            this.combo.setInput((ISetWithListeners)EmptySetWithListeners.createInstance());
        } else {
            this.combo.setInput((ISetWithListeners)new LoadedComponentsQuery(this.runner, repository));
        }
        this.repo = repository;
    }

    protected void browseButtonPressed() {
        if (this.repo == null) {
            return;
        }
        RepositoryUtils.asyncLogin(this.repo, this.runner);
        final ComponentSelectionPage page = new ComponentSelectionPage(this.repo, true, false);
        page.setDescription(Messages.ComponentCombo_3);
        WizardUtil.open((Shell)this.combo.getControl().getShell(), (String)Messages.ComponentCombo_2, (IWizardPage)page, (IRunnableWithResult)new IRunnableWithResult<Boolean>(){

            public Boolean run() {
                IComponent component = page.getSelection();
                if (component != null) {
                    ComponentCombo.this.setSelectedComponent(ComponentCombo.this.repo, (ItemId<IComponent>)new ItemId(component.getItemHandle()));
                }
                return true;
            }
        }, (String)"com.ibm.team.filesystem.ComponentPicker");
    }

    public void setSelectedComponent(ITeamRepository repository, final ItemId<IComponent> componentId) {
        this.setRepository(repository);
        final Display d = Display.getCurrent();
        this.runner.enqueue(Messages.ComponentCombo_4, (Operation)new RepositoryOperation(){

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, FileSystemException, OperationFailedException {
                final IComponent component = (IComponent)RepoFetcher.fetchCurrent((ITeamRepository)ComponentCombo.this.repo, (ItemId)componentId, (boolean)false, (IProgressMonitor)monitor);
                d.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        ComponentWrapper componentWrapper = new ComponentWrapper(ComponentCombo.this.repo, component);
                        ComponentCombo.this.setSelectedElement(componentWrapper);
                    }
                });
            }
        });
    }

    public void setSelectedElement(ComponentWrapper wrapper) {
        this.combo.setSelectedElement((Object)wrapper);
        if (this.isOneNodePresent()) {
            this.combo.removeSpecialValue((Object)ONE_NODE_LABEL);
        }
    }

    public Control getControl() {
        return this.combo.getControl();
    }

    public ComponentWrapper getComponent() {
        return (ComponentWrapper)((Object)this.combo.getSelectedElement());
    }

    public ISelectionProvider getSelectionProvider() {
        return this.combo.getSelectionProvider();
    }

    public void selectTheAnyNode() {
        this.combo.selectSpecialValue((Object)ANY_NODE_LABEL);
    }

    public void selectTheOneNode() {
        this.combo.selectSpecialValue((Object)ONE_NODE_LABEL);
    }

    public void addTheAnyNode() {
        if (!this.isAnyNodePresent()) {
            this.anyNodePresent = true;
            this.combo.addSpecialValue((Object)ANY_NODE_LABEL);
        }
    }

    public void addTheOneNode() {
        if (!this.isOneNodePresent()) {
            this.oneNodePresent = true;
            this.combo.addSpecialValue((Object)ONE_NODE_LABEL);
        }
    }

    public boolean isTheAnyNodeSelected() {
        return this.combo.getSelectedSpecialValue() == ANY_NODE_LABEL;
    }

    public boolean isTheOneNodeSelected() {
        return this.combo.getSelectedSpecialValue() == ONE_NODE_LABEL;
    }

    public boolean isAnyNodePresent() {
        return this.anyNodePresent;
    }

    public boolean isOneNodePresent() {
        return this.oneNodePresent;
    }

    public void removeSpecialNode(String nodeName) {
        if (nodeName.equalsIgnoreCase(ONE_NODE_LABEL)) {
            if (this.isOneNodePresent()) {
                this.oneNodePresent = false;
                this.combo.removeSpecialValue((Object)ONE_NODE_LABEL);
            }
        } else if (nodeName.equalsIgnoreCase(ANY_NODE_LABEL) && this.isAnyNodePresent()) {
            this.anyNodePresent = false;
            this.combo.removeSpecialValue((Object)ANY_NODE_LABEL);
        }
    }
}

