/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.picker;

import com.ibm.team.filesystem.rcp.core.internal.resources.ResourceUtil;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.labelproviders.ResourceLabelProvider;
import com.ibm.team.internal.filesystem.ui.queries.ResourceQuery;
import com.ibm.team.repository.rcp.core.utils.CategoryComparator;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.internal.databinding.ValidatorStatus;
import com.ibm.team.repository.rcp.ui.internal.viewers.ComparatorSorter;
import com.ibm.team.repository.rcp.ui.internal.viewers.ConcurrentTreeContentProvider;
import com.ibm.team.repository.rcp.ui.internal.viewers.HistoryCombo;
import com.ibm.team.repository.rcp.ui.internal.viewers.ISetWithListeners;
import com.ibm.team.repository.rcp.ui.internal.viewers.ITreeProvider;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.operations.JobRunner;
import com.ibm.team.repository.rcp.ui.parts.WidgetToolkit;
import com.ibm.team.repository.rcp.ui.utils.MnemonicGenerator;
import com.ibm.team.repository.rcp.ui.utils.UIContext;
import com.ibm.team.repository.rcp.ui.utils.WidgetFactoryContext;
import java.io.File;
import java.util.Comparator;
import org.eclipse.core.databinding.observable.value.ComputedValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.osgi.util.TextProcessor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.osgi.service.prefs.Preferences;

public final class BrowsableFilenameField {
    private int flags;
    private HistoryCombo text;
    private Button button;
    private String[] filterExtensions = new String[0];
    private String[] filterNames = new String[0];
    private IObservableValue textObservable;
    private ValidatorStatus validatorObservable;
    private Type type;
    public static final int FLAG_DISALLOW_FILES = 1;
    public static final int FLAG_ALLOW_DIRECTORIES = 2;
    public static final int FLAG_NOTEXIST = 4;
    public static final int FLAG_WORKSPACE = 16;
    public static final int FLAG_OPTIONAL = 32;
    public static final int FLAG_AUTOSELECT = 64;
    public static final int FLAG_WARN_IF_EXISTS = 128;
    public static final int FLAG_ABSOLUTE_ONLY = 256;

    public BrowsableFilenameField(Composite parent, String browseString, WidgetFactoryContext context, Preferences oldState, Type type, int flags) {
        WidgetToolkit toolkit = context.getToolkit();
        MnemonicGenerator mg = context.getMnemonics();
        this.type = type;
        this.flags = flags;
        this.text = new HistoryCombo(parent, oldState, (flags & 0x40) != 0);
        this.button = toolkit.createButton(parent, mg.generate(browseString), 8);
        this.button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BrowsableFilenameField.this.doBrowse();
            }
        });
        ISWTObservableValue unprocessedText = WidgetProperties.text().observe((Widget)this.text.getCombo());
        this.textObservable = new ComputedValue((IObservableValue)unprocessedText){
            private final /* synthetic */ IObservableValue val$unprocessedText;
            {
                this.val$unprocessedText = iObservableValue;
            }

            protected Object calculate() {
                return TextProcessor.deprocess((String)((String)this.val$unprocessedText.getValue()));
            }
        };
        this.validatorObservable = new ValidatorStatus(this.textObservable, new IValidator(){

            public IStatus validate(Object value) {
                Path path;
                String text = (String)value;
                if (text.equals("")) {
                    if ((BrowsableFilenameField.this.flags & 0x20) != 0) {
                        return Status.OK_STATUS;
                    }
                    return StatusUtil.newStatus((Object)this, (int)4, (String)Messages.BrowsableFilenameField_2);
                }
                if ((BrowsableFilenameField.this.flags & 0x100) != 0 && !text.equals("") && !(path = new Path(text)).isAbsolute()) {
                    return StatusUtil.newStatus((Object)this, (String)Messages.BrowsableFilenameField_4);
                }
                if ((BrowsableFilenameField.this.flags & 0x10) != 0) {
                    IResource resource = ResourceUtil.getResource((IPath)new Path(text));
                    if (resource == null) {
                        return StatusUtil.newStatus((Object)this, (String)NLS.bind((String)Messages.BrowsableFilenameField_5, (Object)text));
                    }
                    boolean isFile = resource instanceof IFile;
                    if (resource.exists()) {
                        if ((BrowsableFilenameField.this.flags & 4) != 0) {
                            return StatusUtil.newStatus((Object)this, (int)4, (String)NLS.bind((String)Messages.BrowsableFilenameField_6, (Object)text));
                        }
                        if (isFile && (BrowsableFilenameField.this.flags & 1) != 0) {
                            return StatusUtil.newStatus((Object)this, (String)NLS.bind((String)Messages.BrowsableFilenameField_7, (Object)text));
                        }
                    } else if (BrowsableFilenameField.this.type == Type.Open) {
                        return StatusUtil.newStatus((Object)this, (int)4, (String)NLS.bind((String)Messages.BrowsableFilenameField_8, (Object)text));
                    }
                    if (!isFile && (BrowsableFilenameField.this.flags & 2) == 0) {
                        if (resource instanceof IProject) {
                            return StatusUtil.newStatus((Object)this, (String)NLS.bind((String)Messages.BrowsableFilenameField_9, (Object)text));
                        }
                        return StatusUtil.newStatus((Object)this, (String)NLS.bind((String)Messages.BrowsableFilenameField_10, (Object)text));
                    }
                } else {
                    File theFile = new File(text);
                    if (theFile.exists()) {
                        if ((BrowsableFilenameField.this.flags & 4) != 0) {
                            return StatusUtil.newStatus((Object)this, (int)4, (String)NLS.bind((String)Messages.BrowsableFilenameField_11, (Object)text));
                        }
                        if (theFile.isDirectory()) {
                            if ((BrowsableFilenameField.this.flags & 2) == 0) {
                                return StatusUtil.newStatus((Object)this, (String)NLS.bind((String)Messages.BrowsableFilenameField_12, (Object)text));
                            }
                        } else if ((BrowsableFilenameField.this.flags & 1) != 0) {
                            return StatusUtil.newStatus((Object)this, (String)NLS.bind((String)Messages.BrowsableFilenameField_13, (Object)text));
                        }
                        if ((BrowsableFilenameField.this.flags & 0x80) != 0) {
                            return StatusUtil.newStatus((Object)this, (int)2, (String)NLS.bind((String)Messages.BrowsableFilenameField_14, (Object)text));
                        }
                    } else {
                        if (BrowsableFilenameField.this.type == Type.Open) {
                            return StatusUtil.newStatus((Object)this, (int)4, (String)NLS.bind((String)Messages.BrowsableFilenameField_15, (Object)text));
                        }
                        File parentFile = theFile.getParentFile();
                        if (parentFile != null) {
                            if (!parentFile.exists()) {
                                return StatusUtil.newStatus((Object)this, (int)4, (String)NLS.bind((String)Messages.BrowsableFilenameField_MISSING_PARENT, (Object)theFile.getAbsoluteFile().getParent()));
                            }
                            if (!parentFile.canWrite()) {
                                return StatusUtil.newStatus((Object)this, (int)4, (String)NLS.bind((String)Messages.BrowsableFilenameField_UNWRITEABLE_PARENT, (Object)theFile.getAbsoluteFile().getParent()));
                            }
                        } else {
                            return StatusUtil.newStatus((Object)this, (int)4, (String)NLS.bind((String)Messages.BrowsableFilenameField_MISSING_PARENT, (Object)theFile.getAbsoluteFile()));
                        }
                    }
                }
                return Status.OK_STATUS;
            }
        });
        this.text.getControl().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                BrowsableFilenameField.this.onDispose();
            }
        });
    }

    public IObservableValue getTextValue() {
        return this.textObservable;
    }

    public IObservableValue getValidationStatus() {
        return this.validatorObservable;
    }

    protected void onDispose() {
        this.validatorObservable.dispose();
        this.textObservable.dispose();
    }

    protected void doBrowse() {
        int style = 0;
        style = this.type == Type.Open ? (style |= 0x1000) : (style |= 0x2000);
        String filename = this.getText();
        String newFilename = null;
        if ((this.flags & 0x10) != 0) {
            newFilename = BrowsableFilenameField.browseWorkspace(UIContext.createShellContext((Shell)this.getButton().getShell()), filename, this.type, this.flags);
        } else if (this.type == Type.Open && (this.flags & 2) != 0 && (this.flags & 1) != 0) {
            DirectoryDialog dialog = new DirectoryDialog(this.text.getControl().getShell());
            dialog.setFilterPath(filename);
            newFilename = dialog.open();
        } else {
            FileDialog dialog = new FileDialog(this.text.getControl().getShell(), style);
            dialog.setFilterExtensions(this.filterExtensions);
            dialog.setFilterNames(this.filterNames);
            dialog.setFileName(filename);
            newFilename = dialog.open();
        }
        if (newFilename != null) {
            this.setText(newFilename);
        }
    }

    public static String browseWorkspace(UIContext context, String initialName, Type type, int flags) {
        if (type == Type.Open) {
            return BrowsableFilenameField.browseWorkspaceMustExist(context, flags, null);
        }
        Path initialPath = new Path(initialName);
        SaveAsDialog dialog = new SaveAsDialog(context.getShell());
        IFile file = ResourceUtil.getFile((IPath)initialPath);
        dialog.setOriginalFile(file);
        if (dialog.open() == 0) {
            return dialog.getResult().toString();
        }
        return null;
    }

    public static String browseWorkspaceMustExist(UIContext context, final int flags, final ISelectionStatusValidator additionalValidator) {
        final JobRunner backgroundRunner = new JobRunner(false);
        String newFilename = null;
        ConcurrentTreeContentProvider tcp = new ConcurrentTreeContentProvider(new ITreeProvider(){

            public ISetWithListeners getChildren(Object element) {
                if (element instanceof IFile) {
                    return null;
                }
                if (element instanceof IResource) {
                    return new ResourceQuery((IOperationRunner)backgroundRunner, (IResource)element);
                }
                return null;
            }
        });
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(context.getShell(), (ILabelProvider)new ResourceLabelProvider(){

            @Override
            public void updateLabel(ViewerLabel label, Object element) {
                if (element instanceof String) {
                    label.setText((String)element);
                    return;
                }
                super.updateLabel(label, element);
            }
        }, (ITreeContentProvider)tcp);
        dialog.setAllowMultiple(false);
        final String message = (flags & 2) != 0 ? ((flags & 1) != 0 ? Messages.BrowsableFilenameField_16 : Messages.BrowsableFilenameField_17) : Messages.BrowsableFilenameField_18;
        dialog.setMessage(message);
        dialog.setSorter((ViewerSorter)new ComparatorSorter((Comparator)new CategoryComparator(){

            protected int category(Object toTest) {
                if (toTest instanceof IContainer) {
                    return 1;
                }
                if (toTest instanceof IFile) {
                    return 2;
                }
                return 0;
            }

            protected int compareSameCategory(int category, Object e1, Object e2) {
                if (e1 instanceof IResource) {
                    return ((IResource)e1).getName().compareToIgnoreCase(((IResource)e2).getName());
                }
                return 0;
            }
        }));
        dialog.setTitle(Messages.BrowsableFilenameField_19);
        dialog.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return (flags & 1) == 0 || !(element instanceof IFile);
            }
        });
        dialog.setValidator(new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                if (selection.length == 0) {
                    return StatusUtil.newStatus((Object)this, (int)4, (String)message);
                }
                Object sel = selection[0];
                if (sel instanceof IFile ? (flags & 1) != 0 : (flags & 2) == 0) {
                    return StatusUtil.newStatus((Object)this, (int)4, (String)message);
                }
                IStatus result = null;
                if (additionalValidator != null && (result = additionalValidator.validate(selection)) != null && !result.isOK()) {
                    return result;
                }
                return StatusUtil.newStatus((Object)this, (int)0, (String)"");
            }
        });
        dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        dialog.open();
        IResource resource = (IResource)dialog.getFirstResult();
        if (resource != null) {
            newFilename = resource.getFullPath().toString();
        }
        return newFilename;
    }

    public void setEnabled(boolean isEnabled) {
        this.text.getControl().setEnabled(isEnabled);
        this.button.setEnabled(isEnabled);
    }

    public Control getTextControl() {
        return this.text.getControl();
    }

    public Button getButton() {
        return this.button;
    }

    public void setFilterExtensions(String[] strings) {
        this.filterExtensions = strings;
    }

    public void setFilterNames(String[] strings) {
        this.filterNames = strings;
    }

    public void addModifyListener(ModifyListener modifyListener) {
        this.text.getCombo().addModifyListener(modifyListener);
    }

    public void removeModifyListener(ModifyListener modifyListener) {
        this.text.getCombo().removeModifyListener(modifyListener);
    }

    public void setText(String newText) {
        this.text.getCombo().setText(TextProcessor.process((String)newText));
    }

    public String getText() {
        String comboText = this.text.getCombo().getText();
        return TextProcessor.deprocess((String)comboText);
    }

    public boolean isDisposed() {
        return this.text.getCombo().isDisposed();
    }

    public void addToHistory() {
        this.text.addToHistory();
    }

    public static enum Type {
        Open,
        Save;

    }
}

