/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.picker;

import com.ibm.team.filesystem.rcp.ui.internal.util.DialogUtil;
import com.ibm.team.internal.filesystem.ui.picker.Messages;
import com.ibm.team.jface.labelProviders.ElementRemovedNotifierImpl;
import com.ibm.team.jface.labelProviders.IElementRemovedNotifier;
import com.ibm.team.jface.labelProviders.StandardLabelProvider;
import com.ibm.team.process.common.IAccessGroup;
import com.ibm.team.process.common.IAccessGroupHandle;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.ide.ui.accessgroups.dialogs.AccessGroupSelectionDialog;
import com.ibm.team.process.rcp.ui.ProcessAreaSelectionDialog;
import com.ibm.team.process.rcp.ui.TeamContributorSelectionDialog;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.internal.utils.SWTUtil;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.repository.rcp.ui.utils.WidgetFactoryContext;
import com.ibm.team.scm.common.dto.IPermissionContextProvider;
import java.util.Collections;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.LayoutConstants;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class AccessControlPicker
extends TitleAreaDialog {
    private static final int DEFAULT_WIDTH_HINT = 275;
    private static final int DEFAULT_INDENT_WIDTH = 17;
    private ITeamRepository fRepo;
    private String fDescription;
    private IPermissionContextProvider fSelection;
    private boolean fIsFolder;
    private Access fDefaultAccess;
    private IOperationRunner fRunner;
    private IAuditableHandle fScope;
    private StandardLabelProvider fStandardLabelProvider = new StandardLabelProvider((IElementRemovedNotifier)new ElementRemovedNotifierImpl());
    private WidgetFactoryContext fWidgetFactoryContext = WidgetFactoryContext.forDialogBox();
    private Composite fParentComposite;
    private Button fComponentScopeRadioButton;
    private Button fContributorScopeRadioButton;
    private Label fContributorScopeLabel;
    private Button fContributorScopeBrowseButton;
    private Button fProcessAreaScopeRadioButton;
    private Label fProcessAreaScopeImage;
    private Label fProcessAreaScopeLabel;
    private Button fProcessAreaScopeBrowseButton;
    private Button fAccessGroupScopeRadioButton;
    private Label fAccessGroupScopeImage;
    private Label fAccessGroupScopeLabel;
    private Button fAccessGroupScopeBrowseButton;
    private boolean fApplyToChildItems;

    public AccessControlPicker(Shell parentShell, ITeamRepository repo, String description, boolean isFolder, Access defaultAccess, IOperationRunner runner) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.fRepo = repo;
        this.fDescription = description;
        this.fSelection = null;
        this.fIsFolder = isFolder;
        this.fApplyToChildItems = false;
        this.fDefaultAccess = defaultAccess;
        this.fRunner = runner;
        this.fScope = repo.loggedInContributor();
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.AccessControlPicker_windowTitle);
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        return control;
    }

    protected Control createDialogArea(Composite parent) {
        Composite top = (Composite)super.createDialogArea(parent);
        this.fParentComposite = new Composite(top, 0);
        this.createComponentScopeSection(this.fParentComposite);
        this.createContributorScopeSection(this.fParentComposite);
        this.createProcessAreaScopeSection(this.fParentComposite);
        this.createAccessGroupScopeSection(this.fParentComposite);
        if (this.fIsFolder) {
            this.createApplyToChildrenSection(this.fParentComposite);
        }
        this.setTitle(Messages.AccessControlPicker_dialogTitle);
        this.setMessage(this.fDescription);
        Dialog.applyDialogFont((Control)this.fParentComposite);
        GridLayoutFactory.fillDefaults().margins(LayoutConstants.getMargins()).applyTo(this.fParentComposite);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.fParentComposite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ibm.team.filesystem.ide.ui.dialog_configureversionableaccess");
        return this.fParentComposite;
    }

    private void createComponentScopeSection(Composite parent) {
        this.fComponentScopeRadioButton = new Button(parent, 16);
        this.fComponentScopeRadioButton.setText(Messages.AccessControlPicker_componentLabel);
        this.fComponentScopeRadioButton.setSelection(this.fDefaultAccess == Access.COMPONENT);
        this.fComponentScopeRadioButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AccessControlPicker.this.updateSelection();
            }
        });
        Label componentScopeLabel = new Label(parent, 64);
        String componentScopeDescription = Messages.AccessControlPicker_componentScopeDescription;
        componentScopeLabel.setText(componentScopeDescription);
        DialogUtil.setAccessibleDescription((Button)this.fComponentScopeRadioButton, (String)componentScopeDescription);
        GridDataFactory.fillDefaults().indent(17, 0).grab(true, false).hint(275, -1).applyTo((Control)componentScopeLabel);
        Button spacingButton = DialogUtil.createPushButton((WidgetFactoryContext)this.fWidgetFactoryContext, (Composite)parent, (String)Messages.AccessControlPicker_BrowseButtonText, (SelectionListener)new SelectionAdapter(){});
        spacingButton.setEnabled(false);
        spacingButton.setVisible(false);
        GridDataFactory.defaultsFor((Control)spacingButton).align(0x1000008, 0x1000000).applyTo((Control)spacingButton);
    }

    private void createContributorScopeSection(Composite parent) {
        this.fContributorScopeRadioButton = new Button(parent, 16);
        this.fContributorScopeRadioButton.setText(Messages.AccessControlPicker_contributorLabel);
        this.fContributorScopeRadioButton.setSelection(this.fDefaultAccess == Access.CONTRIBUTOR);
        this.fContributorScopeRadioButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!(AccessControlPicker.this.fScope instanceof IContributorHandle)) {
                    AccessControlPicker.this.fScope = (IAuditableHandle)AccessControlPicker.this.fRepo.loggedInContributor();
                }
                AccessControlPicker.this.updateSelection();
            }
        });
        Composite contributorScopeComposite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(contributorScopeComposite);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)contributorScopeComposite);
        this.fContributorScopeLabel = new Label(contributorScopeComposite, 64);
        String contributorScopeDescription = NLS.bind((String)Messages.AccessControlPicker_contributorScopeSelection, (Object)this.fRepo.loggedInContributor().getName());
        this.fContributorScopeLabel.setText(contributorScopeDescription);
        DialogUtil.setAccessibleDescription((Button)this.fContributorScopeRadioButton, (String)contributorScopeDescription);
        GridDataFactory.fillDefaults().indent(17, 0).grab(true, false).hint(343, -1).applyTo((Control)this.fContributorScopeLabel);
        this.fContributorScopeBrowseButton = DialogUtil.createPushButton((WidgetFactoryContext)this.fWidgetFactoryContext, (Composite)contributorScopeComposite, (String)Messages.AccessControlPicker_BrowseButtonText, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IContributorHandle selectedcontributor;
                TeamContributorSelectionDialog dialog = new TeamContributorSelectionDialog(AccessControlPicker.this.getShell(), AccessControlPicker.this.fRepo, Collections.EMPTY_LIST, false);
                if (dialog.open() == 0 && (selectedcontributor = dialog.getContributorResult()[0]) != null) {
                    AccessControlPicker.this.fScope = (IAuditableHandle)selectedcontributor;
                    IContributor contributor = (IContributor)AccessControlPicker.this.fRepo.itemManager().getSharedItemIfKnown((IItemHandle)selectedcontributor);
                    if (contributor != null) {
                        AccessControlPicker.this.fContributorScopeLabel.setText(NLS.bind((String)Messages.AccessControlPicker_contributorScopeSelection, (Object)contributor.getName()));
                    } else {
                        final Display display = AccessControlPicker.this.getShell().getDisplay();
                        AccessControlPicker.this.fRunner.enqueue(Messages.AccessControlPicker_fetchingContributor, (Operation)new RepositoryOperation(){

                            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException {
                                final IContributor contributor = (IContributor)AccessControlPicker.this.fRepo.itemManager().getSharedItemIfKnown((IItemHandle)selectedcontributor);
                                if (contributor != null) {
                                    SWTUtil.greedyExec((Display)display, (Runnable)new Runnable(){

                                        @Override
                                        public void run() {
                                            if (!AccessControlPicker.this.fContributorScopeLabel.isDisposed()) {
                                                AccessControlPicker.this.fContributorScopeLabel.setText(NLS.bind((String)Messages.AccessControlPicker_contributorScopeSelection, (Object)contributor.getName()));
                                            }
                                        }
                                    });
                                }
                            }
                        });
                    }
                }
                AccessControlPicker.this.updateSelection();
            }
        });
        this.fContributorScopeBrowseButton.setEnabled(false);
        GridDataFactory.defaultsFor((Control)this.fContributorScopeBrowseButton).align(0x1000008, 0x1000000).applyTo((Control)this.fContributorScopeBrowseButton);
        Label spacerLabel = new Label(parent, 64);
        spacerLabel.setVisible(false);
        GridDataFactory.fillDefaults().indent(17, 0).grab(true, false).hint(275, -1).applyTo((Control)spacerLabel);
    }

    private void createProcessAreaScopeSection(Composite parent) {
        this.fProcessAreaScopeRadioButton = new Button(parent, 16);
        this.fProcessAreaScopeRadioButton.setText(Messages.AccessControlPicker_scopedLabel);
        this.fProcessAreaScopeRadioButton.setSelection(this.fDefaultAccess == Access.PROCESS_AREA);
        this.fProcessAreaScopeRadioButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AccessControlPicker.this.updateSelection();
            }
        });
        Label processAreaScopeDescriptionLabel = new Label(parent, 64);
        String processAreaScopeDescription = Messages.AccessControlPicker_processAreaScopeDescription;
        processAreaScopeDescriptionLabel.setText(processAreaScopeDescription);
        DialogUtil.setAccessibleDescription((Button)this.fProcessAreaScopeRadioButton, (String)processAreaScopeDescription);
        GridDataFactory.fillDefaults().indent(17, 0).grab(true, false).hint(275, -1).applyTo((Control)processAreaScopeDescriptionLabel);
        Composite processAreaScopeComposite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(3).applyTo(processAreaScopeComposite);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)processAreaScopeComposite);
        this.fProcessAreaScopeImage = new Label(processAreaScopeComposite, 0);
        GridDataFactory.fillDefaults().indent(17, 0).align(1, 1).applyTo((Control)this.fProcessAreaScopeImage);
        this.fProcessAreaScopeLabel = new Label(processAreaScopeComposite, 64);
        GridDataFactory.fillDefaults().hint(343, -1).align(4, 4).grab(true, false).applyTo((Control)this.fProcessAreaScopeLabel);
        this.fProcessAreaScopeBrowseButton = DialogUtil.createPushButton((WidgetFactoryContext)this.fWidgetFactoryContext, (Composite)processAreaScopeComposite, (String)Messages.AccessControlPicker_BrowseButtonText, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProcessAreaSelectionDialog dialog = new ProcessAreaSelectionDialog(AccessControlPicker.this.getShell(), false);
                dialog.setAllowMultiple(false);
                dialog.setInput((Object)AccessControlPicker.this.fRepo);
                if (dialog.open() == 0) {
                    IProcessArea selectedProcessArea = dialog.getSelectedProcessArea();
                    AccessControlPicker.this.fScope = (IAuditableHandle)selectedProcessArea;
                    AccessControlPicker.this.fProcessAreaScopeImage.setImage(AccessControlPicker.this.fStandardLabelProvider.getImage((Object)selectedProcessArea));
                    AccessControlPicker.this.fProcessAreaScopeLabel.setText(AccessControlPicker.this.fStandardLabelProvider.getText((Object)selectedProcessArea));
                    AccessControlPicker.this.fParentComposite.layout(true, true);
                }
                AccessControlPicker.this.updateSelection();
            }
        });
        this.fProcessAreaScopeBrowseButton.setEnabled(false);
        GridDataFactory.defaultsFor((Control)this.fProcessAreaScopeBrowseButton).align(0x1000008, 0x1000000).applyTo((Control)this.fProcessAreaScopeBrowseButton);
    }

    private void createAccessGroupScopeSection(Composite parent) {
        this.fAccessGroupScopeRadioButton = new Button(parent, 16);
        this.fAccessGroupScopeRadioButton.setText(Messages.AccessControlPicker_accessGroupScopeRadioButtonText);
        this.fAccessGroupScopeRadioButton.setSelection(this.fDefaultAccess == Access.ACCESS_GROUP);
        this.fAccessGroupScopeRadioButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AccessControlPicker.this.updateSelection();
            }
        });
        Label accessGroupScopeDescriptionLabel = new Label(parent, 64);
        String accessGroupScopeDescription = Messages.AccessControlPicker_accessGroupScopeDescription;
        accessGroupScopeDescriptionLabel.setText(accessGroupScopeDescription);
        DialogUtil.setAccessibleDescription((Button)this.fAccessGroupScopeRadioButton, (String)accessGroupScopeDescription);
        GridDataFactory.fillDefaults().indent(17, 0).grab(true, false).hint(275, -1).applyTo((Control)accessGroupScopeDescriptionLabel);
        Composite accessGroupScopeComposite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(3).applyTo(accessGroupScopeComposite);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)accessGroupScopeComposite);
        this.fAccessGroupScopeImage = new Label(accessGroupScopeComposite, 0);
        GridDataFactory.fillDefaults().indent(17, 0).align(1, 1).applyTo((Control)this.fAccessGroupScopeImage);
        this.fAccessGroupScopeLabel = new Label(accessGroupScopeComposite, 64);
        GridDataFactory.fillDefaults().hint(343, -1).align(4, 4).grab(true, false).applyTo((Control)this.fAccessGroupScopeLabel);
        this.fAccessGroupScopeBrowseButton = DialogUtil.createPushButton((WidgetFactoryContext)this.fWidgetFactoryContext, (Composite)accessGroupScopeComposite, (String)Messages.AccessControlPicker_BrowseButtonText, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AccessGroupSelectionDialog groupSelection = new AccessGroupSelectionDialog(AccessControlPicker.this.getShell(), AccessControlPicker.this.fRepo);
                if (groupSelection.open() == 0) {
                    IAccessGroup selectedAccessGroup = groupSelection.getSelectedAccessGroup();
                    AccessControlPicker.this.fScope = (IAuditableHandle)selectedAccessGroup;
                    AccessControlPicker.this.fAccessGroupScopeImage.setImage(AccessControlPicker.this.fStandardLabelProvider.getImage((Object)selectedAccessGroup));
                    AccessControlPicker.this.fAccessGroupScopeLabel.setText(AccessControlPicker.this.fStandardLabelProvider.getText((Object)selectedAccessGroup));
                    AccessControlPicker.this.fParentComposite.layout(true, true);
                }
                AccessControlPicker.this.updateSelection();
            }
        });
        this.fAccessGroupScopeBrowseButton.setEnabled(false);
        GridDataFactory.defaultsFor((Control)this.fAccessGroupScopeBrowseButton).align(0x1000008, 0x1000000).applyTo((Control)this.fAccessGroupScopeBrowseButton);
    }

    private void createApplyToChildrenSection(Composite parent) {
        Button applyToChildrenButton = new Button(parent, 32);
        applyToChildrenButton.setText(Messages.AccessControlPicker_applyToChildren);
        applyToChildrenButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AccessControlPicker.this.fApplyToChildItems = ((Button)e.getSource()).getSelection();
            }
        });
        this.fApplyToChildItems = true;
        applyToChildrenButton.setSelection(true);
        GridDataFactory.fillDefaults().grab(true, false).align(1, 1).applyTo((Control)applyToChildrenButton);
    }

    public IPermissionContextProvider getAccessContext() {
        return this.fSelection;
    }

    public boolean getApplyToChildren() {
        return this.fApplyToChildItems;
    }

    public void setScopeSelection(IAuditable scope) {
        this.fScope = scope;
        if (scope instanceof IContributor) {
            IContributor contributor = (IContributor)scope;
            String text = NLS.bind((String)Messages.AccessControlPicker_contributorScopeSelection, (Object)contributor.getName());
            this.fContributorScopeLabel.setText(text);
            this.fParentComposite.layout(true, true);
        } else if (scope instanceof IProcessArea) {
            this.fProcessAreaScopeImage.setImage(this.fStandardLabelProvider.getImage((Object)scope));
            this.fProcessAreaScopeLabel.setText(this.fStandardLabelProvider.getText((Object)scope));
            this.fParentComposite.layout(true, true);
        } else if (scope instanceof IAccessGroup) {
            this.fAccessGroupScopeImage.setImage(this.fStandardLabelProvider.getImage((Object)scope));
            this.fAccessGroupScopeLabel.setText(this.fStandardLabelProvider.getText((Object)scope));
            this.fParentComposite.layout(true, true);
        }
        this.updateSelection();
    }

    private void updateSelection() {
        if (this.fComponentScopeRadioButton.getSelection()) {
            this.fSelection = IPermissionContextProvider.FACTORY.createClear();
        } else if (this.fContributorScopeRadioButton.getSelection()) {
            this.fSelection = this.fScope instanceof IContributorHandle ? IPermissionContextProvider.FACTORY.create((IContributorHandle)this.fScope) : null;
        } else if (this.fProcessAreaScopeRadioButton.getSelection()) {
            this.fSelection = this.fScope instanceof IProcessAreaHandle ? IPermissionContextProvider.FACTORY.create((IProcessAreaHandle)this.fScope) : null;
        } else if (this.fAccessGroupScopeRadioButton.getSelection()) {
            this.fSelection = this.fScope instanceof IAccessGroup ? IPermissionContextProvider.FACTORY.create((IAccessGroupHandle)((IAccessGroup)this.fScope)) : null;
        }
        this.fContributorScopeBrowseButton.setEnabled(this.fContributorScopeRadioButton.getSelection());
        this.fProcessAreaScopeBrowseButton.setEnabled(this.fProcessAreaScopeRadioButton.getSelection());
        this.fAccessGroupScopeBrowseButton.setEnabled(this.fAccessGroupScopeRadioButton.getSelection());
        Button button = this.getButton(0);
        if (button != null) {
            button.setEnabled(this.fSelection != null);
        }
    }

    public static enum Access {
        COMPONENT,
        CONTRIBUTOR,
        PROCESS_AREA,
        ACCESS_GROUP;

    }
}

