/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.patches.viewer;

import com.ibm.team.filesystem.ui.changes.views.PatchedDirectory;
import com.ibm.team.repository.rcp.common.collection.SetDiff;
import com.ibm.team.repository.rcp.ui.internal.viewers.AbstractSetWithListeners;
import com.ibm.team.repository.rcp.ui.internal.viewers.ISetListener;
import com.ibm.team.repository.rcp.ui.internal.viewers.ISetWithListeners;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.internal.util.ItemId;
import com.ibm.team.scm.common.internal.util.NewCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;

public class FilterByComponentSet
extends AbstractSetWithListeners<PatchedDirectory> {
    private HashSet<PatchedDirectory> filteredSet = NewCollection.hashSet();
    private ItemId<IComponent> componentId;
    private ISetWithListeners originalSet;
    private ISetListener<PatchedDirectory> setChangeListener = new ISetListener<PatchedDirectory>(){

        public void changed(SetDiff<PatchedDirectory> diff) {
            FilterByComponentSet.this.doDiff(diff);
        }
    };

    public FilterByComponentSet(ISetWithListeners observableSet, ItemId<IComponent> component) {
        this.originalSet = observableSet;
        this.componentId = component;
    }

    protected void doDiff(SetDiff<PatchedDirectory> diff) {
        ArrayList<PatchedDirectory> finalAdded = new ArrayList<PatchedDirectory>();
        for (PatchedDirectory d : diff.getAdditions()) {
            if (!this.isSameComponent(d) || !this.filteredSet.add(d)) continue;
            finalAdded.add(d);
        }
        ArrayList<PatchedDirectory> finalRemoved = new ArrayList<PatchedDirectory>();
        for (PatchedDirectory d : diff.getRemovals()) {
            if (!this.filteredSet.remove(d)) continue;
            finalRemoved.add(d);
        }
        this.fireDiff(SetDiff.create(finalAdded, finalRemoved));
    }

    protected void allocate() {
        super.allocate();
        this.doDiff((SetDiff<PatchedDirectory>)SetDiff.createAddition((Collection)this.originalSet.toCollection()));
        this.originalSet.addListener(this.setChangeListener);
    }

    protected void deallocate() {
        super.deallocate();
        this.doDiff((SetDiff<PatchedDirectory>)SetDiff.createRemoval((Collection)this.originalSet.toCollection()));
        this.originalSet.removeListener(this.setChangeListener);
    }

    private boolean isSameComponent(PatchedDirectory pd) {
        ItemId component = pd.getPath().getSiloedItemId().getComponent();
        return component.equals(this.componentId);
    }

    protected Collection computeElements() {
        if (this.isAllocated()) {
            return this.filteredSet;
        }
        HashSet<PatchedDirectory> result = new HashSet<PatchedDirectory>();
        for (Object next : this.originalSet.toCollection()) {
            PatchedDirectory pd;
            if (!(next instanceof PatchedDirectory) || !this.isSameComponent(pd = (PatchedDirectory)next)) continue;
            result.add(pd);
        }
        return result;
    }

    public Object getElementType() {
        return Object.class;
    }
}

