/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.patches.actions;

import com.ibm.team.filesystem.rcp.core.internal.patches.ParsedPatch;
import com.ibm.team.filesystem.rcp.core.internal.patches.PatchResult;
import com.ibm.team.filesystem.rcp.core.patches.PatchModel;
import com.ibm.team.filesystem.rcp.core.patches.PatchOpHandle;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.patches.actions.AcceptHunkAction;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.repository.rcp.ui.utils.AbstractActionDelegate;
import com.ibm.team.repository.rcp.ui.utils.UIContext;
import java.util.List;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public class ResolveWithProposedAction
extends AbstractActionDelegate {
    public void run(Shell shell, IWorkbenchPage page, IStructuredSelection selection) {
        UIContext context = this.getContext();
        List selList = selection.toList();
        if (!MessageDialog.openConfirm((Shell)shell, (String)Messages.ResolveWithProposed_ConfirmProposedTitle, (String)Messages.ResolveWithProposedAction_0)) {
            return;
        }
        final List<PatchOpHandle> ops = AcceptHunkAction.getSelectedFileOps(selList);
        final ParsedPatch parsedPatch = PatchOpHandle.computePatch(ops);
        context.getUserOperationRunner().enqueue(Messages.ResolveWithProposed_ResolveProposedJobName, (Operation)new RepositoryOperation(){

            public void repositoryRun(IProgressMonitor monitor, final IStatusCollector problems) throws TeamRepositoryException, OperationFailedException {
                try {
                    ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                        public void run(IProgressMonitor monitor) throws CoreException {
                            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                            try {
                                try {
                                    PatchResult result = parsedPatch.resolveWithProposed((IProgressMonitor)progress.newChild(100));
                                    try {
                                        PatchModel.getDefault().updateAfterAccept(result, ops, false, (IProgressMonitor)progress);
                                    }
                                    finally {
                                        result.dispose();
                                    }
                                }
                                catch (TeamRepositoryException e) {
                                    problems.reportException((Throwable)e);
                                    parsedPatch.dispose();
                                }
                            }
                            finally {
                                parsedPatch.dispose();
                            }
                        }
                    }, monitor);
                }
                catch (CoreException e) {
                    problems.reportException((Throwable)e);
                }
            }
        });
    }
}

