/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.patches.actions;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.common.ISymbolicLink;
import com.ibm.team.filesystem.common.changemodel.VersionablePath;
import com.ibm.team.filesystem.ide.ui.internal.actions.AbstractOpenLocalFileAction;
import com.ibm.team.filesystem.rcp.core.internal.CoreShareablesUtil;
import com.ibm.team.filesystem.rcp.core.patches.PatchFile;
import com.ibm.team.filesystem.rcp.core.patches.PatchOp;
import com.ibm.team.filesystem.rcp.core.patches.PatchOpHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;

public class OpenLocalFileAction
extends AbstractOpenLocalFileAction {
    @Override
    protected Collection<IShareable> getShareablesFor(IStructuredSelection selection, IProgressMonitor monitor) throws FileSystemException, TeamRepositoryException {
        VersionablePath vp = this.getVersionablePath(selection);
        if (vp == null) {
            return Collections.EMPTY_LIST;
        }
        return CoreShareablesUtil.getShareablesFor((VersionablePath)vp, (IProgressMonitor)monitor);
    }

    private VersionablePath getVersionablePath(IStructuredSelection selection) {
        PatchOpHandle hunk;
        PatchOp op;
        IItemType itemType;
        Object selected = selection.getFirstElement();
        VersionablePath vp = null;
        if (selected instanceof PatchOpHandle && ((itemType = (op = (hunk = (PatchOpHandle)selected).getOp()).getItemType()) == null || !itemType.equals(ISymbolicLink.ITEM_TYPE))) {
            vp = hunk.getFilePath();
        }
        if (selected instanceof PatchFile) {
            PatchFile file = (PatchFile)selected;
            vp = file.getVersionablePath();
        }
        return vp;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        super.selectionChanged(action, selection);
        boolean enabled = true;
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection)selection;
            VersionablePath vp = this.getVersionablePath(ss);
            enabled = vp != null;
        }
        action.setEnabled(enabled);
    }
}

