/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.patches.actions;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.common.FileLineDelimiter;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.ISymbolicLink;
import com.ibm.team.filesystem.common.changemodel.FileState;
import com.ibm.team.filesystem.common.changemodel.VersionablePath;
import com.ibm.team.filesystem.common.changemodel.VersionablePathSegment;
import com.ibm.team.filesystem.ide.ui.internal.compare.DelegatingSaveableCompareEditorInput;
import com.ibm.team.filesystem.ide.ui.internal.util.ExternalCompareToolUtils;
import com.ibm.team.filesystem.rcp.core.internal.CoreShareablesUtil;
import com.ibm.team.filesystem.rcp.core.internal.compare.Open3WayMergeInExternalCompareOperation;
import com.ibm.team.filesystem.rcp.core.internal.compare.OpenInExternalCompareDilemmaHandler;
import com.ibm.team.filesystem.rcp.core.internal.compare.OpenShareableInExternalCompareOperation;
import com.ibm.team.filesystem.rcp.core.internal.patches.AbstractStateChangeOp;
import com.ibm.team.filesystem.rcp.core.internal.patches.ApplyHunkOp;
import com.ibm.team.filesystem.rcp.core.internal.patches.ClearFileContentsOp;
import com.ibm.team.filesystem.rcp.core.internal.patches.CreateEmptyFileOp;
import com.ibm.team.filesystem.rcp.core.internal.patches.CreateFolderOp;
import com.ibm.team.filesystem.rcp.core.internal.patches.DeleteLinkOp;
import com.ibm.team.filesystem.rcp.core.internal.patches.FilePatchResult;
import com.ibm.team.filesystem.rcp.core.internal.patches.FileStateFactory;
import com.ibm.team.filesystem.rcp.core.internal.patches.Hunk;
import com.ibm.team.filesystem.rcp.core.internal.patches.MovableResource;
import com.ibm.team.filesystem.rcp.core.internal.patches.MoveFileOp;
import com.ibm.team.filesystem.rcp.core.internal.patches.PropertyDelta;
import com.ibm.team.filesystem.rcp.core.internal.streams.PatchResultInputStreamProvider;
import com.ibm.team.filesystem.rcp.core.patches.PatchConflictException;
import com.ibm.team.filesystem.rcp.core.patches.PatchOp;
import com.ibm.team.filesystem.rcp.core.patches.PatchOpHandle;
import com.ibm.team.filesystem.ui.UiPlugin;
import com.ibm.team.filesystem.ui.changes.actions.OpenInCompareAction;
import com.ibm.team.filesystem.ui.changes.actions.OpenInExternalCompareAction;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.util.WarnOpenInExternalCompare;
import com.ibm.team.internal.repository.rcp.streams.EmptyInputStreamProvider;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.utils.IInputStreamProvider;
import com.ibm.team.repository.rcp.ui.internal.utils.SWTUtil;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.repository.rcp.ui.utils.AbstractActionDelegate;
import com.ibm.team.repository.rcp.ui.utils.UIContext;
import com.ibm.team.scm.common.IFolder;
import com.ibm.team.scm.common.internal.gc.ExternalLinks;
import com.ibm.team.scm.common.internal.util.ItemId;
import com.ibm.team.scm.common.internal.util.StateId;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public class OpenHunkAction
extends AbstractActionDelegate {
    protected static final String PREF_EXPLAIN_HUNK = String.valueOf(OpenHunkAction.class.getName()) + ".explain_hunk";

    public void run(Shell shell, final IWorkbenchPage page, IStructuredSelection selection) {
        final PatchOpHandle hunk = (PatchOpHandle)selection.getFirstElement();
        final UIContext context = this.getContext();
        this.getOperationRunner().enqueue(Messages.OpenHunkAction_0, (Operation)new RepositoryOperation(){

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, FileSystemException, OperationFailedException {
                AbstractStateChangeOp stateChange;
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                VersionablePath versionablePath = hunk.getFilePath();
                Collection shareables = CoreShareablesUtil.getShareablesFor((VersionablePath)versionablePath, (IProgressMonitor)progress.newChild(20));
                IShareable shareable = null;
                for (IShareable s : shareables) {
                    ResourceType resourceType = s.getResourceType((IProgressMonitor)progress.newChild(5));
                    if (resourceType != null && resourceType != ResourceType.FILE && resourceType != ResourceType.SYMBOLIC_LINK) continue;
                    shareable = s;
                    break;
                }
                if (shareable == null) {
                    return;
                }
                final PatchOp patchOp = hunk.getOp();
                SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                Hunk theHunk = null;
                FileState rightState = null;
                FileState ancestorState = null;
                Object externalCompareOperation = null;
                CompareEditorInput input = null;
                if (patchOp instanceof ApplyHunkOp) {
                    ApplyHunkOp ah = (ApplyHunkOp)patchOp;
                    try {
                        FilePatchResult result = ah.computeResolve(MovableResource.create((IShareable)shareable), (IProgressMonitor)sub.newChild(80));
                        if (!result.hasRejects()) {
                            FileState beforeState = FileStateFactory.create((IShareable)shareable, (IProgressMonitor)sub.newChild(5));
                            rightState = this.createRightState(beforeState, result);
                        }
                    }
                    catch (PatchConflictException result) {
                    }
                    catch (FileSystemException result) {
                        // empty catch block
                    }
                    if (rightState == null) {
                        theHunk = ah.getHunk((IProgressMonitor)sub.newChild(20));
                    }
                } else if (patchOp instanceof AbstractStateChangeOp) {
                    stateChange = (AbstractStateChangeOp)patchOp;
                    IItemType itemType = stateChange.getItemType();
                    FileState currentState = FileStateFactory.create((IShareable)shareable, (IProgressMonitor)sub.newChild(20));
                    if (itemType != null && itemType.equals(IFileItem.ITEM_TYPE)) {
                        ancestorState = stateChange.getBeforeState(currentState, (IProgressMonitor)sub.newChild(40));
                        rightState = stateChange.getAfterState(currentState, (IProgressMonitor)sub.newChild(40));
                    } else if (itemType != null && itemType.equals(ISymbolicLink.ITEM_TYPE)) {
                        boolean isDirectoryLink;
                        String target;
                        if (stateChange.isPropertyChangeOnly()) {
                            target = currentState.getTarget();
                            isDirectoryLink = currentState.isDirectoryLink();
                        } else {
                            target = stateChange.getAfterLinkTarget(sub.newChild(1));
                            isDirectoryLink = stateChange.getAfterLinkIsDirectory(sub.newChild(1));
                        }
                        PropertyDelta delta = stateChange.getPropertyDelta((IProgressMonitor)sub.newChild(1));
                        Map currentProperties = currentState.getProperties();
                        Map afterProperties = delta.applyToLocal(currentProperties);
                        rightState = FileState.create((VersionablePathSegment)currentState.getPath(), (Date)currentState.getTimestamp(), (IInputStreamProvider)currentState.getContents(), (boolean)currentState.isDeleted(), (Map)afterProperties, (StateId)stateChange.getAfterState(), (String)target, (boolean)isDirectoryLink);
                    } else if (itemType != null && itemType.equals(IFolder.ITEM_TYPE)) {
                        PropertyDelta delta = stateChange.getPropertyDelta((IProgressMonitor)sub.newChild(1));
                        Map currentProperties = currentState.getProperties();
                        Map afterProperties = delta.applyToLocal(currentProperties);
                        rightState = FileState.create((VersionablePathSegment)currentState.getPath(), (Date)currentState.getTimestamp(), (boolean)currentState.isDeleted(), (Map)afterProperties, (StateId)stateChange.getAfterState());
                    }
                } else if (patchOp instanceof DeleteLinkOp) {
                    stateChange = (DeleteLinkOp)patchOp;
                    FileState currentState = FileStateFactory.create((IShareable)shareable, (IProgressMonitor)sub.newChild(20));
                    String encoding = System.getProperty("file.encoding");
                    rightState = FileState.create((VersionablePathSegment)currentState.getPath(), (Date)currentState.getTimestamp(), (IInputStreamProvider)EmptyInputStreamProvider.getDefault(), (boolean)currentState.isExectuable(), (String)currentState.getContentType(), (FileLineDelimiter)currentState.getLineDelimiter(), (boolean)currentState.isTextType(), (String)encoding, (boolean)stateChange.getAfterState().isDeleted(), (Map)currentState.getProperties(), (StateId)stateChange.getAfterState(), (ExternalLinks)currentState.getExternalLinks(), (FileState.VersionIdType)currentState.getVersionIds());
                }
                if (rightState != null) {
                    boolean useExternalCompareTool = ExternalCompareToolUtils.shouldUseExternalCompareTool(rightState.getPath().getName());
                    if (useExternalCompareTool) {
                        final OpenInExternalCompareAction.ExternalCommandLinePreference externalCommandLinePreference = ancestorState != null ? OpenInExternalCompareAction.get3WayCommandLine() : OpenInExternalCompareAction.get2WayLocalCompareCommandLine();
                        String commandLine = externalCommandLinePreference.getCommandLine();
                        if (commandLine == null) {
                            final Shell shell = context.getShell();
                            SWTUtil.greedyExec((Display)shell.getDisplay(), (Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    if (!shell.isDisposed()) {
                                        externalCommandLinePreference.openPreferenceDialog(shell, null);
                                    }
                                }
                            });
                            return;
                        }
                        externalCompareOperation = ancestorState != null ? new Open3WayMergeInExternalCompareOperation(shareable, rightState, ancestorState, commandLine, (OpenInExternalCompareDilemmaHandler)new WarnOpenInExternalCompare(context)) : new OpenShareableInExternalCompareOperation(commandLine, shareable, rightState, (OpenInExternalCompareDilemmaHandler)new WarnOpenInExternalCompare(context));
                    } else {
                        input = DelegatingSaveableCompareEditorInput.createInput(page, shareable, ancestorState, rightState, false);
                    }
                } else if (theHunk != null) {
                    input = DelegatingSaveableCompareEditorInput.createInput(page, shareable, theHunk);
                }
                if (externalCompareOperation != null) {
                    externalCompareOperation.run((IProgressMonitor)sub.newChild(20));
                } else if (input != null) {
                    final CompareEditorInput finalInput = input;
                    context.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            MessageDialogWithToggle dialog;
                            OpenInCompareAction.openCompareEditor(finalInput, context.getPage());
                            IPreferenceStore store = UiPlugin.getDefault().getPreferenceStore();
                            boolean prompt = store.getBoolean(PREF_EXPLAIN_HUNK);
                            if (prompt && (dialog = MessageDialogWithToggle.openInformation((Shell)context.getShell(), (String)Messages.OpenHunkAction_10, (String)Messages.OpenHunkAction_9, (String)Messages.OpenHunkAction_11, (boolean)false, null, null)).getReturnCode() == 0) {
                                store.setValue(PREF_EXPLAIN_HUNK, !dialog.getToggleState());
                            }
                        }
                    });
                } else {
                    context.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            String message = Messages.OpenHunkAction_4;
                            if (patchOp instanceof MoveFileOp) {
                                message = Messages.OpenHunkAction_5;
                            } else if (patchOp instanceof ClearFileContentsOp) {
                                message = Messages.OpenHunkAction_6;
                            } else if (patchOp instanceof CreateEmptyFileOp) {
                                message = Messages.OpenHunkAction_7;
                            } else if (patchOp instanceof CreateFolderOp) {
                                message = Messages.OpenHunkAction_8;
                            }
                            MessageDialog.openInformation((Shell)context.getShell(), null, (String)message);
                        }
                    });
                }
            }

            private FileState createRightState(FileState beforeState, FilePatchResult result) throws FileSystemException {
                PatchResultInputStreamProvider streamProvider = new PatchResultInputStreamProvider(result, true);
                return FileState.create((VersionablePathSegment)beforeState.getPath(), (Date)new Date(), (IInputStreamProvider)streamProvider, (boolean)beforeState.isExectuable(), (String)beforeState.getContentType(), (FileLineDelimiter)beforeState.getLineDelimiter(), (boolean)true, (String)FilePatchResult.getCharset((FilePatchResult)result), (boolean)false, (Map)beforeState.getProperties(), (StateId)StateId.getDeletedState((ItemId)ItemId.getNullItem((IItemType)IFileItem.ITEM_TYPE)), (ExternalLinks)beforeState.getExternalLinks(), (FileState.VersionIdType)beforeState.getVersionIds());
            }
        });
    }
}

