/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.patches.actions;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.common.changemodel.FileChange;
import com.ibm.team.filesystem.common.changemodel.FileState;
import com.ibm.team.filesystem.ui.editor.PartUtil;
import com.ibm.team.filesystem.ui.editor.RemoteFileEditorInput;
import com.ibm.team.filesystem.ui.item.AdapterUtil;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.repository.rcp.ui.parts.impl.MessageDialogFactory;
import com.ibm.team.repository.rcp.ui.utils.AbstractActionDelegate;
import com.ibm.team.repository.rcp.ui.utils.UIContext;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public class OpenAfterStateAction
extends AbstractActionDelegate {
    public void run(Shell shell, IWorkbenchPage page, IStructuredSelection selection) {
        List<FileChange> changes = AdapterUtil.adaptList(selection.toList(), FileChange.class);
        UIContext context = this.getContext();
        for (FileChange next : changes) {
            FileState fileState = next.getFinal();
            OpenAfterStateAction.openEditor(context, fileState);
        }
    }

    public static void openEditor(final UIContext context, final FileState fileState) {
        if (fileState.isDeleted()) {
            MessageDialogFactory.showMessage((Shell)context.getShell(), (int)1, (String)Messages.OpenAfterStateAction_0, (String)Messages.OpenAfterStateAction_1);
        } else {
            context.getUserOperationRunner().enqueue(Messages.OpenAfterStateAction_2, (Operation)new RepositoryOperation(){

                public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, FileSystemException, OperationFailedException {
                    final RemoteFileEditorInput editorInput = RemoteFileEditorInput.createInput(fileState, monitor);
                    context.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            PartUtil.openEditor(context, editorInput, null, true);
                        }
                    });
                }
            });
        }
    }
}

