/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.patches.actions;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.internal.ClientFileStateFactory;
import com.ibm.team.filesystem.client.internal.namespace.IItemContext;
import com.ibm.team.filesystem.client.internal.namespace.ItemFetcher;
import com.ibm.team.filesystem.client.internal.namespace.ItemLocator;
import com.ibm.team.filesystem.client.internal.namespace.ItemNamespace;
import com.ibm.team.filesystem.client.internal.utils.RepositoryUtils;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.changemodel.FileChange;
import com.ibm.team.filesystem.common.changemodel.FileState;
import com.ibm.team.filesystem.ide.ui.internal.compare.DelegatingSaveableCompareEditorInput;
import com.ibm.team.filesystem.ide.ui.internal.util.ExternalCompareToolUtils;
import com.ibm.team.filesystem.rcp.core.internal.CoreShareablesUtil;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.FileChangeFactory;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncContext;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IRemoteChangeSummary;
import com.ibm.team.filesystem.rcp.core.internal.compare.OpenFileItemInExternalCompareOperation;
import com.ibm.team.filesystem.rcp.core.internal.compare.OpenInExternalCompareDilemmaHandler;
import com.ibm.team.filesystem.rcp.core.internal.compare.OpenShareableInExternalCompareOperation;
import com.ibm.team.filesystem.rcp.core.internal.patches.FileStateFactory;
import com.ibm.team.filesystem.rcp.ui.internal.RcpUiPlugin;
import com.ibm.team.filesystem.rcp.ui.internal.compare.FileChangeEditorInput;
import com.ibm.team.filesystem.ui.changes.actions.OpenInCompareAction;
import com.ibm.team.filesystem.ui.changes.actions.OpenInExternalCompareAction;
import com.ibm.team.filesystem.ui.wrapper.AbstractFileSystemItemWrapper;
import com.ibm.team.filesystem.ui.wrapper.FileItemWrapper;
import com.ibm.team.filesystem.ui.wrapper.SymbolicLinkItemWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.picker.LocationPicker;
import com.ibm.team.internal.filesystem.ui.util.PendingChangesUtil;
import com.ibm.team.internal.filesystem.ui.util.ShareablesUtil;
import com.ibm.team.internal.filesystem.ui.util.WarnOpenInExternalCompare;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.nodes.StructuralChangesViewFileNode;
import com.ibm.team.internal.filesystem.ui.wizards.component.ComponentConfigurationPickerWizard;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.common.IRemoteFunction;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.internal.utils.SWTUtil;
import com.ibm.team.repository.rcp.ui.internal.viewers.ConstantFunction;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.repository.rcp.ui.parts.impl.IPartResult;
import com.ibm.team.repository.rcp.ui.parts.impl.MessageDialogFactory;
import com.ibm.team.repository.rcp.ui.utils.AbstractActionDelegate;
import com.ibm.team.repository.rcp.ui.utils.UIContext;
import com.ibm.team.scm.client.internal.RepoFetcher;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.internal.ItemWithLinks;
import com.ibm.team.scm.common.internal.util.ItemId;
import com.ibm.team.scm.common.internal.util.StateId;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public class CompareWithAction
extends AbstractActionDelegate {
    public void run(Shell shell, IWorkbenchPage page, final IStructuredSelection selection) {
        final UIContext context = this.getContext();
        context.getUserOperationRunner().enqueue(Messages.CompareWithAction_2, (Operation)new RepositoryOperation(){

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, FileSystemException, OperationFailedException {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                List selectedStates = CompareWithAction.getStatesFor(selection, (IProgressMonitor)progress.newChild(50));
                if (selectedStates.size() != 1) {
                    context.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            Shell shell = context.getShell();
                            if (shell.isDisposed()) {
                                shell = context.getDisplay().getActiveShell();
                            }
                            if (shell != null) {
                                MessageDialogFactory.showMessage((Shell)shell, (int)4, (String)Messages.CompareWithAction_0, (String)Messages.CompareWithAction_1);
                            }
                        }
                    });
                    return;
                }
                final StateInfo theState = (StateInfo)selectedStates.iterator().next();
                final ItemId theComponent = (ItemId)theState.getComponent().compute((IProgressMonitor)progress.newChild(50));
                context.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        CompareWithAction.this.doCompare(context, theState, (ItemId<IComponent>)theComponent);
                    }
                });
            }
        });
    }

    private String getVersionId(FileState fileState) {
        IPreferenceStore store = RcpUiPlugin.getDefault().getPreferenceStore();
        boolean showLongIdentifier = store.getBoolean("pref_show_version_identifiers_repository_id");
        if (OpenInCompareAction.showVersionIdForCompare() && fileState != null) {
            if (showLongIdentifier) {
                return fileState.getLongVersionId();
            }
            return fileState.getShortVersionId();
        }
        return "";
    }

    private void doCompare(final UIContext context, final StateInfo theState, ItemId<IComponent> theComponent) {
        LocationPicker.pickLocation(this.getContext(), Messages.CompareWithAction_3, Messages.CompareWithAction_4, theState.getOptionalContext(), (ItemLocator<IComponent>)ItemLocator.create((ITeamRepository)theState.getRepo(), theComponent), false, new IPartResult<ComponentConfigurationPickerWizard.ComponentConfigurationPickerResult>(){

            public void setResult(final ComponentConfigurationPickerWizard.ComponentConfigurationPickerResult result) {
                if (result == null) {
                    return;
                }
                context.getUserOperationRunner().enqueue(Messages.CompareWithAction_5, (Operation)new RepositoryOperation(){

                    public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, FileSystemException, OperationFailedException {
                        FileState localState;
                        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                        IItemContext itemContext = result.getItemNamespace().getContext((IProgressMonitor)progress.newChild(20));
                        if (theState.optionalShareable == null) {
                            localState = (FileState)theState.getState().compute((IProgressMonitor)progress.newChild(10));
                            progress.setWorkRemaining(70);
                        } else {
                            localState = null;
                        }
                        ItemWithLinks fileItem = null;
                        ItemId<IFileItem> itemId = theState.getItemId();
                        try {
                            fileItem = ItemFetcher.fetchCurrentWithLinks((IItemContext)itemContext, theState.getItemId(), (boolean)true, (IProgressMonitor)progress.newChild(15));
                        }
                        catch (ItemNotFoundException itemNotFoundException) {
                            // empty catch block
                        }
                        final FileState remoteState = ClientFileStateFactory.create((ITeamRepository)itemContext.getNamespace().getRepository(), (IItemType)itemId.getItemType(), (ItemWithLinks)fileItem, (boolean)OpenInCompareAction.showVersionIdForCompare(), (IProgressMonitor)progress.newChild(5));
                        String remoteFilename = remoteState.getPath().getName();
                        String contextName = itemContext.getName();
                        final String remoteName = CompareWithAction.computeRemoteFilenameWithVersionId(remoteFilename, CompareWithAction.this.getVersionId(remoteState), contextName);
                        final IShareable optionalShareable = theState.getOptionalShareable();
                        boolean useExternalCompareTool = ExternalCompareToolUtils.shouldUseExternalCompareTool(remoteName);
                        if (useExternalCompareTool) {
                            final OpenInExternalCompareAction.ExternalCommandLinePreference externalCommandLinePreference = optionalShareable == null ? OpenInExternalCompareAction.get2WayRemoteCompareCommandLine() : OpenInExternalCompareAction.get2WayLocalCompareCommandLine();
                            String commandLine = externalCommandLinePreference.getCommandLine();
                            if (commandLine == null) {
                                final Shell shell = context.getShell();
                                SWTUtil.greedyExec((Display)shell.getDisplay(), (Runnable)new Runnable(){

                                    @Override
                                    public void run() {
                                        if (!shell.isDisposed()) {
                                            externalCommandLinePreference.openPreferenceDialog(shell, null);
                                        }
                                    }
                                });
                                return;
                            }
                            progress.setTaskName(Messages.OpenInExternalCompareAction_2);
                            if (optionalShareable != null) {
                                OpenShareableInExternalCompareOperation externalCompareOperation = new OpenShareableInExternalCompareOperation(commandLine, optionalShareable, remoteState, (OpenInExternalCompareDilemmaHandler)new WarnOpenInExternalCompare(context));
                                externalCompareOperation.run((IProgressMonitor)progress.newChild(50));
                            } else {
                                OpenFileItemInExternalCompareOperation externalCompareOperation = new OpenFileItemInExternalCompareOperation(commandLine, localState, " " + Messages.CompareWithAction_8, remoteState, remoteName, (OpenInExternalCompareDilemmaHandler)new WarnOpenInExternalCompare(context));
                                externalCompareOperation.run((IProgressMonitor)progress.newChild(50));
                            }
                        } else {
                            context.asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    if (optionalShareable != null) {
                                        OpenInCompareAction.openCompareEditor(DelegatingSaveableCompareEditorInput.createInput(context.getPage(), optionalShareable, remoteState, remoteName, false), context.getPage());
                                    } else {
                                        FileChangeEditorInput input = FileChangeEditorInput.createFrom((FileState)localState, (FileState)remoteState, (boolean)false);
                                        input.setLabels(Messages.CompareWithAction_8, remoteName);
                                        input.setRightLabel(remoteName);
                                        OpenInCompareAction.openCompareEditor((CompareEditorInput)input, context.getPage());
                                    }
                                }
                            });
                        }
                    }
                });
            }
        });
    }

    public static String computeRemoteFilename(String remoteFilename, String contextName) {
        String remoteName = NLS.bind((String)Messages.CompareWithAction_9, (Object)remoteFilename, (Object)contextName);
        return remoteName;
    }

    public static String computeRemoteFilenameWithVersionId(String remoteFilename, String version, String contextName) {
        String versionedLabel = version != null && !version.equals("") ? NLS.bind((String)Messages.CompareWithAction_LabelWithVersionId, (Object)remoteFilename, (Object)version) : remoteFilename;
        String remoteName = CompareWithAction.computeRemoteFilename(versionedLabel, contextName);
        return remoteName;
    }

    private static List<StateInfo> getStatesFor(IStructuredSelection selection, IProgressMonitor monitor) {
        ArrayList<StateInfo> result = new ArrayList<StateInfo>();
        List sel = selection.toList();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)sel.size());
        for (Object next : sel) {
            StateInfo nextState = CompareWithAction.getFileStateFor(next, (IProgressMonitor)progress.newChild(1));
            if (nextState == null) continue;
            result.add(nextState);
        }
        return result;
    }

    private static StateInfo getFileStateFor(Object object, IProgressMonitor monitor) {
        IAdaptable adaptable;
        IShareable shareable;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        if (object instanceof StructuralChangesViewFileNode) {
            StructuralChangesViewFileNode fileNode = (StructuralChangesViewFileNode)object;
            return new StateInfo(fileNode.getChange().getFinal(), fileNode.getFolder().getRepository(), (ItemId<IFileItem>)fileNode.getChange().getItemId(), (ItemId<IComponent>)fileNode.getChange().getSiloedItemId().getComponent(), null);
        }
        if (object instanceof IAdaptable && (shareable = (IShareable)(adaptable = (IAdaptable)object).getAdapter(IShareable.class)) != null) {
            try {
                ItemId item = ShareablesUtil.getItem(shareable, (IProgressMonitor)progress.newChild(20));
                ISharingDescriptor descr = shareable.getShare((IProgressMonitor)progress.newChild(20)).getSharingDescriptor();
                ITeamRepository repo = RepositoryUtils.getTeamRepository((ISharingDescriptor)descr);
                ItemId component = CoreShareablesUtil.getComponent((IShareable)shareable, (IProgressMonitor)progress.newChild(20));
                ItemNamespace localNamespace = CoreShareablesUtil.getContributorPlace((IShareable)shareable, (IProgressMonitor)progress.newChild(20));
                return new StateInfo(shareable, repo, item, (ItemId<IComponent>)component, localNamespace, (IProgressMonitor)progress.newChild(20));
            }
            catch (FileSystemException e) {
                StatusUtil.log(CompareWithAction.class, (Throwable)e);
                return null;
            }
            catch (TeamRepositoryException e) {
                StatusUtil.log(CompareWithAction.class, (Throwable)e);
                return null;
            }
        }
        if (object instanceof IRemoteChangeSummary) {
            final IRemoteChangeSummary rcs = (IRemoteChangeSummary)object;
            IRemoteFunction<FileState> remoteState = new IRemoteFunction<FileState>(){

                public FileState compute(IProgressMonitor monitor) throws TeamRepositoryException {
                    boolean getVersionIds = OpenInCompareAction.showVersionIdForCompare();
                    FileChange change = FileChangeFactory.createFromRemoteSummary((IRemoteChangeSummary)rcs, (boolean)false, (boolean)getVersionIds, (IProgressMonitor)monitor);
                    return change.getFinal();
                }
            };
            IComponentSyncContext model = rcs.getActivity().getActivitySource().getModel();
            return new StateInfo((IRemoteFunction)remoteState, model.localTeamRepository(), ItemId.create((IItemHandle)rcs.getItem()), (IRemoteFunction)new ConstantFunction(PendingChangesUtil.getComponent(model)), PendingChangesUtil.getLocalNamespace(model), null);
        }
        if (object instanceof ILocalChange) {
            ILocalChange localChange = (ILocalChange)object;
            IVersionableHandle handle = localChange.getTarget();
            if (handle == null) {
                return null;
            }
            IShareable shareable2 = localChange.getShareable();
            if (shareable2 == null) {
                return null;
            }
            try {
                ISharingDescriptor descr2 = shareable2.getShare((IProgressMonitor)progress.newChild(25)).getSharingDescriptor();
                ItemNamespace contributorPlace = CoreShareablesUtil.getContributorPlace((IShareable)shareable2, (IProgressMonitor)progress.newChild(25));
                return new StateInfo(shareable2, RepositoryUtils.getTeamRepository((ISharingDescriptor)descr2), ShareablesUtil.getItem(localChange), (ItemId<IComponent>)CoreShareablesUtil.getComponent((ILocalChange)localChange), contributorPlace, (IProgressMonitor)progress.newChild(25));
            }
            catch (FileSystemException e) {
                StatusUtil.log(CompareWithAction.class, (Throwable)e);
                return null;
            }
            catch (TeamRepositoryException e) {
                StatusUtil.log(CompareWithAction.class, (Throwable)e);
                return null;
            }
        }
        if (object instanceof FileItemWrapper || object instanceof SymbolicLinkItemWrapper) {
            final AbstractFileSystemItemWrapper fiw = (AbstractFileSystemItemWrapper)((Object)object);
            return new StateInfo((IRemoteFunction)new IRemoteFunction<FileState>(){

                public FileState compute(IProgressMonitor monitor) throws TeamRepositoryException {
                    StateId state = fiw.getFileItem();
                    IVersionable fetched = (IVersionable)RepoFetcher.fetchItem((ITeamRepository)fiw.getRepository(), (StateId)state, (IProgressMonitor)monitor);
                    return ClientFileStateFactory.create((ITeamRepository)fiw.getRepository(), (IItemType)state.getItemType(), (IVersionable)fetched);
                }
            }, fiw.getRepository(), fiw.getItem(), (IRemoteFunction)new IRemoteFunction<ItemId<IComponent>>(){

                public ItemId<IComponent> compute(IProgressMonitor monitor) throws TeamRepositoryException {
                    return fiw.getWorkspace().fetchComponentId(monitor);
                }
            }, fiw.getWorkspace(), null);
        }
        return null;
    }

    private static final class StateInfo {
        IRemoteFunction<FileState> state;
        ITeamRepository repo;
        ItemId<IFileItem> itemId;
        IRemoteFunction<ItemId<IComponent>> component;
        ItemNamespace optionalContext;
        IShareable optionalShareable;

        public StateInfo(FileState state, ITeamRepository repo, ItemId<IFileItem> itemId, ItemId<IComponent> component, ItemNamespace optionalContext) {
            this((IRemoteFunction<FileState>)new ConstantFunction((Object)state), repo, itemId, (IRemoteFunction<ItemId<IComponent>>)new ConstantFunction(component), optionalContext, null);
        }

        public StateInfo(IShareable optionalShareable, ITeamRepository repo, ItemId itemId, ItemId<IComponent> component, ItemNamespace optionalContext, IProgressMonitor monitor) throws FileSystemException, TeamRepositoryException {
            this((IRemoteFunction<FileState>)new ConstantFunction((Object)FileStateFactory.create((IShareable)optionalShareable, (IProgressMonitor)monitor)), repo, (ItemId<IFileItem>)itemId, (IRemoteFunction<ItemId<IComponent>>)new ConstantFunction(component), optionalContext, optionalShareable);
        }

        private StateInfo(IRemoteFunction<FileState> state, ITeamRepository repo, ItemId<IFileItem> itemId, IRemoteFunction<ItemId<IComponent>> component, ItemNamespace optionalContext, IShareable optionalShareable) {
            this.state = state;
            this.repo = repo;
            this.itemId = itemId;
            this.component = component;
            this.optionalContext = optionalContext;
            this.optionalShareable = optionalShareable;
        }

        public IRemoteFunction<FileState> getState() {
            return this.state;
        }

        public ITeamRepository getRepo() {
            return this.repo;
        }

        public ItemId<IFileItem> getItemId() {
            return this.itemId;
        }

        public IRemoteFunction<ItemId<IComponent>> getComponent() {
            return this.component;
        }

        public ItemNamespace getOptionalContext() {
            return this.optionalContext;
        }

        public IShareable getOptionalShareable() {
            return this.optionalShareable;
        }
    }
}

