/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.patches.actions;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.common.changemodel.VersionablePath;
import com.ibm.team.filesystem.rcp.core.internal.CoreShareablesUtil;
import com.ibm.team.filesystem.rcp.core.internal.resources.ResourceUtil;
import com.ibm.team.filesystem.rcp.core.patches.PatchModel;
import com.ibm.team.filesystem.rcp.core.patches.PatchOpHandle;
import com.ibm.team.filesystem.ui.item.AdapterUtil;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.utils.AbstractActionDelegate;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;
import org.eclipse.ui.dialogs.SaveAsDialog;

public class ChangeHunkTargetAction
extends AbstractActionDelegate {
    public void run(Shell shell, IWorkbenchPage page, IStructuredSelection selection) {
        final List<PatchOpHandle> localFileOps = AdapterUtil.adaptList(selection.toList(), PatchOpHandle.class);
        final int size = localFileOps.size();
        final IPath path = this.promptForTarget(size > 1);
        if (path != null) {
            new Job(NLS.bind((String)Messages.ChangeHunkTargetAction_0, (Object)path)){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                        if (size > 1) {
                            HashMap<PatchOpHandle, VersionablePath> ops = new HashMap<PatchOpHandle, VersionablePath>(size);
                            SubMonitor subMonitor = progress.newChild(20);
                            subMonitor.setWorkRemaining(size);
                            for (PatchOpHandle op : localFileOps) {
                                VersionablePath opPath = op.getFilePath();
                                IPath newPath = path.append(opPath.getFileName());
                                IResource resource = ResourceUtil.getResource((IPath)newPath);
                                VersionablePath pp = CoreShareablesUtil.getPathTo((IResource)resource, (boolean)false, (IProgressMonitor)subMonitor.newChild(1));
                                ops.put(op, pp);
                            }
                            PatchModel.getDefault().retargetHunks(ops, (IProgressMonitor)progress.newChild(80));
                        } else {
                            IResource resource = ResourceUtil.getResource((IPath)path);
                            VersionablePath pp = CoreShareablesUtil.getPathTo((IResource)resource, (boolean)false, (IProgressMonitor)progress.newChild(20));
                            Map<PatchOpHandle, VersionablePath> ops = Collections.singletonMap((PatchOpHandle)localFileOps.iterator().next(), pp);
                            PatchModel.getDefault().retargetHunks(ops, (IProgressMonitor)progress.newChild(80));
                        }
                        return Status.OK_STATUS;
                    }
                    catch (FileSystemException e) {
                        return StatusUtil.newStatus((Object)((Object)this), (Throwable)e);
                    }
                }
            }.schedule();
        }
    }

    private IPath promptForTarget(boolean multiple) {
        Shell shell = this.getContext().getShell();
        if (multiple) {
            ContainerSelectionDialog dialog = new ContainerSelectionDialog(shell, (IContainer)ResourcesPlugin.getWorkspace().getRoot(), true, null);
            return dialog.open() == 0 ? (IPath)dialog.getResult()[0] : null;
        }
        SaveAsDialog dialog = new SaveAsDialog(shell);
        return dialog.open() == 0 ? dialog.getResult() : null;
    }
}

