/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.patches.actions;

import com.ibm.team.filesystem.rcp.core.internal.operations.AcceptHunksOperation;
import com.ibm.team.filesystem.rcp.core.patches.Patch;
import com.ibm.team.filesystem.rcp.core.patches.PatchFile;
import com.ibm.team.filesystem.rcp.core.patches.PatchModel;
import com.ibm.team.filesystem.rcp.core.patches.PatchOpHandle;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.repository.rcp.ui.utils.AbstractActionDelegate;
import com.ibm.team.repository.rcp.ui.utils.UIContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public class AcceptHunkAction
extends AbstractActionDelegate {
    public void run(Shell shell, IWorkbenchPage page, IStructuredSelection selection) {
        final UIContext context = this.getContext();
        List selList = selection.toList();
        if (!MessageDialog.openConfirm((Shell)context.getShell(), (String)Messages.AcceptHunkAction_0, (String)Messages.AcceptHunkAction_1)) {
            return;
        }
        final List toDiscard = this.getEmptyNodes(selList);
        final List<PatchOpHandle> ops = AcceptHunkAction.getSelectedFileOps(selList);
        context.getUserOperationRunner().enqueue(Messages.AcceptHunkAction_2, (Operation)new RepositoryOperation(){

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, OperationFailedException {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
                final int result = AcceptHunksOperation.acceptHunks((List)ops, (IProgressMonitor)progress.newChild(1));
                PatchModel.getDefault().removeAll((Collection)toDiscard, (IProgressMonitor)progress.newChild(1));
                if (result < ops.size()) {
                    context.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (result == 0) {
                                MessageDialog.openWarning((Shell)context.getShell(), (String)Messages.AcceptHunkAction_3, (String)Messages.AcceptHunkAction_4);
                            } else {
                                MessageDialog.openWarning((Shell)context.getShell(), (String)Messages.AcceptHunkAction_3, (String)Messages.AcceptHunkAction_6);
                            }
                        }
                    });
                }
            }
        });
    }

    private List getEmptyNodes(List selList) {
        ArrayList<Object> toDiscard = new ArrayList<Object>();
        for (Object next : selList) {
            Patch cc;
            PatchFile pd;
            if (next instanceof PatchFile && (pd = (PatchFile)next).isEmpty()) {
                toDiscard.add(pd);
            }
            if (!(next instanceof Patch) || !(cc = (Patch)next).isEmpty()) continue;
            toDiscard.add(cc);
        }
        return toDiscard;
    }

    public static List<PatchOpHandle> getSelectedFileOps(List selList) {
        ArrayList<PatchOpHandle> ops = new ArrayList<PatchOpHandle>();
        for (Object next : selList) {
            if (next instanceof PatchOpHandle) {
                PatchOpHandle op = (PatchOpHandle)next;
                ops.add(op);
            }
            if (next instanceof PatchFile) {
                PatchFile file = (PatchFile)next;
                ops.addAll(file.getOpHandles());
            }
            if (!(next instanceof Patch)) continue;
            Patch patch = (Patch)next;
            ops.addAll(patch.getOpHandles());
        }
        return ops;
    }
}

