/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.patches;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.FileSystemStatusException;
import com.ibm.team.filesystem.rcp.core.internal.patches.FilePatchResult;
import com.ibm.team.filesystem.rcp.core.internal.patches.Hunk;
import com.ibm.team.internal.filesystem.ui.patches.UIHunk;
import java.io.InputStream;
import org.eclipse.compare.patch.IFilePatchResult;
import org.eclipse.compare.patch.IHunk;
import org.eclipse.core.runtime.CoreException;

public class UIFilePatchResult
extends FilePatchResult {
    private final IFilePatchResult result;

    public UIFilePatchResult(IFilePatchResult result) {
        this.result = result;
    }

    public String getCharset() throws FileSystemException {
        try {
            return this.result.getCharset();
        }
        catch (CoreException e) {
            throw FileSystemStatusException.fromCoreException(null, (CoreException)e);
        }
    }

    public InputStream getOriginalContents() {
        return this.result.getOriginalContents();
    }

    public InputStream getPatchedContents() {
        return this.result.getPatchedContents();
    }

    public Hunk[] getRejects() {
        IHunk[] rejects = this.result.getRejects();
        Hunk[] hunks = new Hunk[rejects.length];
        int i = 0;
        while (i < rejects.length) {
            IHunk hunk = rejects[i];
            hunks[i] = new UIHunk(hunk);
            ++i;
        }
        return hunks;
    }

    public boolean hasMatches() {
        return this.result.hasMatches();
    }

    public boolean hasRejects() {
        return this.result.hasRejects();
    }
}

