/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.patches;

import com.ibm.team.filesystem.rcp.core.internal.patches.FilePatch;
import com.ibm.team.filesystem.rcp.core.internal.patches.FilePatchResult;
import com.ibm.team.filesystem.rcp.core.internal.patches.Hunk;
import com.ibm.team.internal.filesystem.ui.patches.UIFilePatchResult;
import com.ibm.team.internal.filesystem.ui.patches.UIHunk;
import org.eclipse.compare.patch.IFilePatch;
import org.eclipse.compare.patch.IFilePatchResult;
import org.eclipse.compare.patch.IHunk;
import org.eclipse.compare.patch.PatchConfiguration;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;

public class UIFilePatch
extends FilePatch {
    IFilePatch filePatch;

    public UIFilePatch(IFilePatch filePatch) {
        this.filePatch = filePatch;
    }

    public FilePatchResult apply(IStorage contents, IProgressMonitor monitor) {
        return new UIFilePatchResult(this.filePatch.apply(contents, UIFilePatch.getDefaultConfiguration(), monitor));
    }

    private static PatchConfiguration getDefaultConfiguration() {
        PatchConfiguration patchConfiguration = new PatchConfiguration();
        patchConfiguration.setFuzz(-1);
        return patchConfiguration;
    }

    public IPath getTargetPath() {
        return this.filePatch.getTargetPath(UIFilePatch.getDefaultConfiguration());
    }

    public Hunk[] getHunks(IStorage contents, IProgressMonitor monitor) {
        IFilePatchResult result = this.filePatch.apply(contents, new PatchConfiguration(), monitor);
        if (result.hasMatches()) {
            throw new IllegalStateException("This method is only intended to be called for patches that fail");
        }
        IHunk[] rejects = result.getRejects();
        Hunk[] hunks = new Hunk[rejects.length];
        int i = 0;
        while (i < rejects.length) {
            IHunk hunk = rejects[i];
            hunks[i] = new UIHunk(hunk);
            ++i;
        }
        return hunks;
    }
}

