/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.patches;

import com.ibm.team.filesystem.client.internal.patches.CreatePatchDilemmaHandler;
import com.ibm.team.filesystem.common.changemodel.FileChange;
import com.ibm.team.filesystem.ide.ui.internal.dialogs.DetailsDialog;
import com.ibm.team.filesystem.ui.changes.actions.QuerySelectionDialog;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.repository.rcp.ui.internal.utils.BaseLabelProvider;
import com.ibm.team.repository.rcp.ui.internal.viewers.WritableSetWithListeners;
import com.ibm.team.repository.rcp.ui.utils.UIContext;
import com.ibm.team.scm.common.internal.util.SiloedItemId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.swt.widgets.Shell;

public class StandardCreatePatchDilemmaHandler
extends CreatePatchDilemmaHandler {
    private UIContext context;

    public StandardCreatePatchDilemmaHandler(UIContext context) {
        this.context = context;
    }

    public Collection<FileChange> nonTextChangesDetected(final Collection<FileChange> nonText) throws OperationCanceledException {
        if (nonText.isEmpty()) {
            return new ArrayList<FileChange>();
        }
        final Object[][] result = new Object[1][];
        this.context.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                WritableSetWithListeners items = new WritableSetWithListeners();
                items.addAll(nonText);
                BaseLabelProvider lp = new BaseLabelProvider(){

                    public void updateLabel(ViewerLabel label, Object element) {
                        FileChange fileChange = (FileChange)element;
                        String path = fileChange.getFinal().isDeleted() ? fileChange.getInitial().getPath().getName().toString() : fileChange.getFinal().getPath().getName().toString();
                        label.setText(path);
                    }
                };
                QuerySelectionDialog dlg = QuerySelectionDialog.create(StandardCreatePatchDilemmaHandler.this.context.getShell(), items, (ILabelProvider)lp, Messages.StandardCreatePatchDilemmaHandler_0);
                dlg.setTitle(Messages.StandardCreatePatchDilemmaHandler_1);
                dlg.open();
                result[0] = dlg.getResult();
            }
        });
        if (result[0] == null) {
            throw new OperationCanceledException();
        }
        ArrayList<FileChange> resultList = new ArrayList<FileChange>();
        Object[] objectArray = result[0];
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            resultList.add((FileChange)o);
            ++n2;
        }
        return resultList;
    }

    public int handleConflictsAndGaps(Map<SiloedItemId, List<FileChange>> conflictsAndGaps) {
        final int[] result = new int[1];
        if (!conflictsAndGaps.isEmpty()) {
            this.context.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    if (!MessageDialog.openConfirm((Shell)StandardCreatePatchDilemmaHandler.this.context.getShell(), (String)Messages.StandardCreatePatchDilemmaHandler_2, (String)Messages.StandardCreatePatchDilemmaHandler_3)) {
                        result[0] = 1;
                    }
                }
            });
        }
        return result[0];
    }

    public void reportSubcomponentChange() {
        this.context.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                new DetailsDialog(StandardCreatePatchDilemmaHandler.this.context.getShell(), Messages.StandardCreatePatchDilemmaHandler_CannotPatchSubcomponentChange_Title, Messages.StandardCreatePatchDilemmaHandler_CannotPatchSubcomponentChange_Text, 1, DetailsDialog.ButtonBar.Ok).open();
            }
        });
    }

    public void reportExternalLinksChange() {
        this.context.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                new DetailsDialog(StandardCreatePatchDilemmaHandler.this.context.getShell(), Messages.StandardCreatePatchDilemmaHandler_CannotPatchRelatedArtifactChange_Title, Messages.StandardCreatePatchDilemmaHandler_CannotPatchRelatedArtifactChange_Text, 1, DetailsDialog.ButtonBar.Ok).open();
            }
        });
    }
}

