/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.patches;

import com.ibm.team.filesystem.client.internal.patches.CreatePatchDilemmaHandler;
import com.ibm.team.filesystem.client.internal.patches.CreatePatchUtil;
import com.ibm.team.filesystem.common.changemodel.ChangeDescription;
import com.ibm.team.filesystem.common.changemodel.ConfigurationChange;
import com.ibm.team.filesystem.common.changemodel.FileChange;
import com.ibm.team.filesystem.common.changemodel.IPathResolver;
import com.ibm.team.filesystem.common.internal.patch.ChangeClassifier;
import com.ibm.team.filesystem.ide.ui.internal.dialogs.ClipboardOrFilePart;
import com.ibm.team.filesystem.ide.ui.internal.dialogs.EncodingPart;
import com.ibm.team.filesystem.ui.UiPlugin;
import com.ibm.team.internal.filesystem.ui.ImagePool;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.patches.ChangeFolder;
import com.ibm.team.internal.filesystem.ui.patches.PatchSorter;
import com.ibm.team.internal.filesystem.ui.patches.PatchTreeProvider;
import com.ibm.team.internal.filesystem.ui.patches.StandardCreatePatchDilemmaHandler;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.StructuralChangesViewLabelProvider;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.internal.databinding.CombinedStatus;
import com.ibm.team.repository.rcp.ui.internal.databinding.DatabindingUtil;
import com.ibm.team.repository.rcp.ui.internal.utils.JFaceUtils;
import com.ibm.team.repository.rcp.ui.internal.viewers.ComparatorSorter;
import com.ibm.team.repository.rcp.ui.internal.viewers.ConcurrentTreeContentProvider;
import com.ibm.team.repository.rcp.ui.internal.viewers.ITreeProvider;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.JobRunner;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.repository.rcp.ui.parts.WidgetToolkit;
import com.ibm.team.repository.rcp.ui.parts.impl.MessageDialogFactory;
import com.ibm.team.repository.rcp.ui.utils.UIContext;
import com.ibm.team.repository.rcp.ui.utils.WidgetFactoryContext;
import com.ibm.team.repository.rcp.ui.wizards.BaseWizardPage;
import com.ibm.team.repository.rcp.ui.wizards.IRunnableWithResult;
import com.ibm.team.repository.rcp.ui.wizards.WizardUtil;
import com.ibm.team.scm.common.internal.util.NewCollection;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ContainerCheckedTreeViewer;
import org.osgi.service.prefs.Preferences;

public final class CreatePatchPart
extends BaseWizardPage {
    public static final String[] FILTER_NAMES = new String[]{Messages.CreatePatchPart_11, Messages.CreatePatchPart_12};
    public static final String[] FILTER_EXTENSIONS = new String[]{"*.patch;*.diff", "*"};
    private final ConcurrentTreeContentProvider CHANGES_PROVIDER = new ConcurrentTreeContentProvider((ITreeProvider)new PatchTreeProvider());
    private ConfigurationChange activity;
    private ChangeDescription description;
    private IPathResolver pathResolver;
    private ContainerCheckedTreeViewer changesViewer;
    private WritableValue selectionValidationState = new WritableValue();
    private CombinedStatus validationStatus = new CombinedStatus();
    private ClipboardOrFilePart clipboardOrFilePart;
    private EncodingPart encodingPart;

    public CreatePatchPart(String pageName, Input input) {
        super(pageName, Messages.CreatePatchPart_2, ImagePool.CREATE_PATCH_WIZBAN_IMAGE);
        this.activity = input.input;
        this.description = input.description;
        this.pathResolver = input.pathResolver;
        this.setDescription(Messages.CreatePatchPart_3);
        this.selectionValidationState.setValue((Object)Status.OK_STATUS);
    }

    protected void createBody(Composite parent) {
        Preferences prefs = this.getInstancePrefs();
        WidgetFactoryContext context = WidgetFactoryContext.forDialogBox();
        WidgetToolkit toolkit = context.getToolkit();
        this.clipboardOrFilePart = new ClipboardOrFilePart(new ClipboardOrFilePart.ClipboardOrFilePartInput(null, Messages.ClipboardOrFilePart_FILE, Messages.BrowsableFilenameField_0, prefs, true, FILTER_EXTENSIONS, FILTER_NAMES));
        this.clipboardOrFilePart.create(parent, context);
        this.encodingPart = new EncodingPart(new EncodingPart.EncodingPartInput(Messages.CreatePatchPart_Encoding, Messages.CreatePatchPart_EncodingLabel, prefs));
        this.encodingPart.create(parent, context);
        Composite changesComposite = toolkit.createComposite(parent);
        toolkit.createLabel(changesComposite, context.getMnemonics().generate(Messages.CreatePatchPart_13));
        this.changesViewer = new ContainerCheckedTreeViewer(changesComposite);
        this.changesViewer.setContentProvider((IContentProvider)this.CHANGES_PROVIDER);
        StructuralChangesViewLabelProvider lp = new StructuralChangesViewLabelProvider(this.CHANGES_PROVIDER.getKnownElements(), context.getBackgroundOperationRunner());
        lp.setPathResolver(this.pathResolver);
        this.changesViewer.setLabelProvider((IBaseLabelProvider)lp);
        this.changesViewer.setSorter((ViewerSorter)new ComparatorSorter((Comparator)((Object)new PatchSorter())));
        List<ChangeFolder> folders = ChangeFolder.computeChanges(this.activity.getChanges());
        this.changesViewer.setInput(folders);
        this.changesViewer.setAllChecked(true);
        this.changesViewer.expandAll();
        GridLayoutFactory.fillDefaults().generateLayout(changesComposite);
        Dialog.applyDialogFont((Control)parent);
        GridLayoutFactory.fillDefaults().generateLayout(parent);
        this.validationStatus.addStatus(this.clipboardOrFilePart.getValidationStatus());
        this.validationStatus.addStatus(this.encodingPart.getValidationStatus());
        this.changesViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                CreatePatchPart.this.updateEnablement();
            }
        });
        this.validationStatus.addStatus((IObservableValue)this.selectionValidationState);
        this.updateEnablement();
        DatabindingUtil.bindMessage((DialogPage)this, (IObservableValue)this.validationStatus);
    }

    private void updateEnablement() {
        boolean somethingSelected;
        boolean bl = somethingSelected = this.changesViewer.getCheckedElements().length > 0;
        if (somethingSelected) {
            this.selectionValidationState.setValue((Object)Status.OK_STATUS);
        } else {
            this.selectionValidationState.setValue((Object)StatusUtil.newStatus((Object)((Object)this), (int)4, (String)Messages.CreatePatchPart_14));
        }
    }

    public boolean createPatch() {
        this.clipboardOrFilePart.savePreferences();
        final Shell parentShell = (Shell)this.getControl().getShell().getParent();
        final ClipboardOrFilePart.ClipboardOrFileResult result = this.clipboardOrFilePart.getResult();
        boolean confirmOverwrite = result.confirmOverwrite(parentShell);
        if (!confirmOverwrite) {
            return false;
        }
        EncodingPart.EncodingResult encodingResult = this.encodingPart.getResult();
        final String encoding = encodingResult.getEncoding();
        final ConfigurationChange selectedChanges = this.computeSelectedChanges();
        final ChangeDescription description = this.description;
        final Display display = Display.getCurrent();
        final UIContext context = UIContext.createShellContext((Shell)parentShell);
        JobRunner jobRunner = new JobRunner(true);
        jobRunner.enqueue(Messages.CreatePatchPart_17, (Operation)new RepositoryOperation(){

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, OperationFailedException {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                CreatePatchUtil.createPatch((CreatePatchDilemmaHandler)new StandardCreatePatchDilemmaHandler(context), (OutputStream)out, (ConfigurationChange)selectedChanges, (ChangeDescription)description, (IPathResolver)CreatePatchPart.this.pathResolver, (String)encoding, (IProgressMonitor)progress);
                IStatus status = result.write(out, display);
                if (!status.isOK()) {
                    problems.reportProblem(status);
                    JFaceUtils.showError(null, null, (IStatus)status);
                } else {
                    final IPreferenceStore store = UiPlugin.getDefault().getPreferenceStore();
                    boolean prompt = store.getBoolean("info_create_patch");
                    if (!display.isDisposed() && prompt) {
                        display.asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                MessageDialogWithToggle dialog = MessageDialogWithToggle.openInformation((Shell)parentShell, (String)Messages.CreatePatchPart_20, (String)Messages.CreatePatchPart_21, (String)Messages.CreatePatchPart_0, (boolean)false, null, null);
                                if (dialog.getReturnCode() == 0) {
                                    store.setValue("info_create_patch", !dialog.getToggleState());
                                }
                            }
                        });
                    }
                }
            }
        });
        return true;
    }

    public void setInput(Input theInput) {
        this.activity = theInput.input;
        List<ChangeFolder> folders = ChangeFolder.computeChanges(this.activity.getChanges());
        this.changesViewer.setInput(folders);
        this.changesViewer.setAllChecked(true);
        this.changesViewer.expandAll();
    }

    public ConfigurationChange computeSelectedChanges() {
        Object[] elements = this.changesViewer.getCheckedElements();
        HashSet changes = NewCollection.hashSet();
        int i = 0;
        while (i < elements.length) {
            Object nextObject = elements[i];
            if (nextObject instanceof ChangeFolder) {
                ChangeFolder cf = (ChangeFolder)nextObject;
                changes.addAll(cf.getFolderChanges());
            }
            if (nextObject instanceof FileChange) {
                changes.add((FileChange)nextObject);
            }
            ++i;
        }
        return new ConfigurationChange((Collection)changes);
    }

    protected Preferences getInstancePrefs() {
        return new InstanceScope().getNode("com.ibm.team.filesystem.ide.ui").node(((Object)((Object)this)).getClass().getName());
    }

    public static void showDialog(Shell parent, ConfigurationChange cc, IPathResolver pathResolver, ChangeDescription description) {
        if (cc.isEmpty()) {
            MessageDialogFactory.showMessage((Shell)parent, (IStatus)StatusUtil.newStatus(CreatePatchPart.class, (int)1, (String)Messages.CreatePatchPart_26));
            return;
        }
        ChangeClassifier classifier = new ChangeClassifier(cc.getChanges());
        ArrayList initialSelection = NewCollection.arrayList();
        initialSelection.addAll(classifier.getTextChanges());
        initialSelection.addAll(classifier.getFolderChanges());
        Input input = new Input(cc, initialSelection, pathResolver, description);
        final CreatePatchPart createPatchPart = new CreatePatchPart("page", input);
        WizardUtil.open((Shell)parent, (String)Messages.CreatePatchPart_28, (IWizardPage)createPatchPart, (IRunnableWithResult)new IRunnableWithResult<Boolean>(){

            public Boolean run() {
                return createPatchPart.createPatch();
            }
        }, (String)"com.ibm.team.filesystem.ide.ui.wizard_newpatch");
    }

    public static class Input {
        ConfigurationChange input;
        Collection<FileChange> initialSelection;
        ChangeDescription description;
        IPathResolver pathResolver;

        public Input(ConfigurationChange input, Collection<FileChange> initialSelection, IPathResolver pathResolver, ChangeDescription description) {
            this.input = input;
            this.initialSelection = initialSelection;
            this.description = description;
            this.pathResolver = pathResolver;
        }
    }
}

