/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.patches;

import com.ibm.team.filesystem.common.changemodel.FileChange;
import com.ibm.team.repository.rcp.common.collection.CollectionUtil;
import com.ibm.team.scm.common.IFolder;
import com.ibm.team.scm.common.internal.util.ItemId;
import com.ibm.team.scm.common.internal.util.NewCollection;
import com.ibm.team.scm.common.internal.util.SiloedItemId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ChangeFolder {
    private SiloedItemId<IFolder> path;
    private Set<FileChange> changes = NewCollection.hashSet();
    private Set<FileChange> folderChanges = new HashSet<FileChange>();

    public ChangeFolder(SiloedItemId<IFolder> path) {
        this.path = path;
    }

    public void addFolderChange(FileChange toAdd) {
        if (!toAdd.getSiloedItemId().equals(this.path)) {
            throw new IllegalArgumentException("addFolderChange may only be used to add changes to the folder itself");
        }
        this.folderChanges.add(toAdd);
    }

    public Set<FileChange> getFolderChanges() {
        return this.folderChanges;
    }

    public void addChange(FileChange toAdd) {
        this.changes.add(toAdd);
    }

    public void addChanges(Collection<FileChange> toAdd) {
        this.changes.addAll(toAdd);
    }

    public Set<FileChange> getChanges() {
        return Collections.unmodifiableSet(this.changes);
    }

    public SiloedItemId<IFolder> getPath() {
        return this.path;
    }

    public static List<ChangeFolder> computeChanges(Collection<FileChange> changes) {
        HashMap changesByFolder = NewCollection.hashMap();
        HashMap changesToFolders = NewCollection.hashMap();
        for (FileChange next : changes) {
            SiloedItemId folder;
            if (next.isFolder()) {
                folder = next.getSiloedItemId();
                CollectionUtil.addToMapOfLists((Map)changesToFolders, (Object)folder, (Object)next);
                continue;
            }
            folder = SiloedItemId.create((ItemId)next.getNonDeleted(false).getPath().getParent(), (ItemId)next.getSiloedItemId().getComponent());
            CollectionUtil.addToMapOfLists((Map)changesByFolder, (Object)folder, (Object)next);
        }
        HashSet allFolders = new HashSet();
        allFolders.addAll(changesByFolder.keySet());
        allFolders.addAll(changesToFolders.keySet());
        ArrayList result = NewCollection.arrayList();
        for (SiloedItemId nextPath : allFolders) {
            List folderChanges;
            ChangeFolder nextFolder = new ChangeFolder((SiloedItemId<IFolder>)nextPath);
            List nextChanges = (List)changesByFolder.get(nextPath);
            if (nextChanges != null) {
                nextFolder.addChanges(nextChanges);
            }
            if ((folderChanges = (List)changesToFolders.get(nextPath)) != null) {
                nextFolder.addFolderChanges(folderChanges);
            }
            result.add(nextFolder);
        }
        return result;
    }

    public void addFolderChanges(Collection<FileChange> folderChanges) {
        for (FileChange next : folderChanges) {
            this.addFolderChange(next);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.changes == null ? 0 : this.changes.hashCode());
        result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ChangeFolder other = (ChangeFolder)obj;
        if (this.changes == null ? other.changes != null : !this.changes.equals(other.changes)) {
            return false;
        }
        return !(this.path == null ? other.path != null : !this.path.equals(other.path));
    }
}

