/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.patches;

import com.ibm.team.filesystem.client.DuplicateShareableException;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.ClientRepositoryUtil;
import com.ibm.team.filesystem.client.internal.namespace.IItemContext;
import com.ibm.team.filesystem.client.internal.namespace.ItemNamespace;
import com.ibm.team.filesystem.client.internal.patches.CreatePatchUtil;
import com.ibm.team.filesystem.client.internal.snapshot.NamespaceSetId;
import com.ibm.team.filesystem.client.internal.snapshot.SnapshotId;
import com.ibm.team.filesystem.common.changemodel.ChangeDescription;
import com.ibm.team.filesystem.common.changemodel.ConfigurationChange;
import com.ibm.team.filesystem.common.changemodel.IPathResolver;
import com.ibm.team.filesystem.common.changemodel.VersionablePath;
import com.ibm.team.filesystem.common.internal.patch.ChangeClassifier;
import com.ibm.team.filesystem.common.internal.util.ChangeSetUtil;
import com.ibm.team.filesystem.rcp.core.internal.CoreShareablesUtil;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ComponentSyncUtil;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.FallbackPathResolver;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncContext;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IOutgoingRemoteActivity;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IRemoteActivity;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.SnapshotPathResolver;
import com.ibm.team.filesystem.rcp.core.internal.patches.AbstractStateChangeOp;
import com.ibm.team.filesystem.rcp.core.internal.patches.ParsedFilePatch;
import com.ibm.team.filesystem.rcp.core.internal.patches.ParsedPatch;
import com.ibm.team.filesystem.rcp.core.patches.Patch;
import com.ibm.team.filesystem.rcp.core.patches.PatchModel;
import com.ibm.team.filesystem.rcp.core.patches.PatchOp;
import com.ibm.team.filesystem.ui.changes.actions.ApplyPatchDilemmaHandler;
import com.ibm.team.filesystem.ui.changes.actions.StandardApplyPatchDilemmaHandler;
import com.ibm.team.filesystem.ui.item.Repositories;
import com.ibm.team.filesystem.ui.wrapper.ChangeSetInContextWrapper;
import com.ibm.team.filesystem.ui.wrapper.ChangeSetWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.util.PendingChangesUtil;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.NotLoggedInException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.utils.IInputStreamProvider;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.utils.UIContext;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.internal.RepoFetcher;
import com.ibm.team.scm.common.IChange;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.internal.gc.LinkDiffReport;
import com.ibm.team.scm.common.internal.subcomponents.SubcomponentCommonUtils;
import com.ibm.team.scm.common.internal.util.ItemId;
import com.ibm.team.scm.common.internal.util.ItemLists;
import com.ibm.team.scm.common.internal.util.NewCollection;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;

public class ApplyPatchUtil {
    public static final Object PATCH_RESULT_SUCCESS = new String("Success");
    public static final Object PATCH_TYPE_NORMAL = ParsedPatch.PATCH_TYPE_NORMAL;

    public static void applyPatch(ApplyPatchDilemmaHandler handler, IInputStreamProvider patch, String encoding, IPath targetPath, String patchDescription, IProgressMonitor monitor) throws TeamRepositoryException, OperationFailedException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            boolean foundWorkspaceWithAllChangeSets;
            ParsedPatch parsed;
            block8: {
                parsed = ParsedPatch.parse((IInputStreamProvider)patch, (String)encoding, (int)0, (IPath)targetPath, (IProgressMonitor)progress.newChild(3));
                Set affectedVersionablePaths = parsed.getAffectedVersionablePaths(targetPath, (IProgressMonitor)progress.newChild(3));
                Map map = ParsedPatch.getAffectedShareables((Set)affectedVersionablePaths, (IProgressMonitor)progress.newChild(3));
                HashSet<IShareable> affectedShareables = new HashSet<IShareable>();
                for (IShareable shareable : map.values()) {
                    if (shareable == null) continue;
                    affectedShareables.add(shareable);
                }
                Set<ItemNamespace> components = ApplyPatchUtil.getContributorPlacesFor(affectedShareables, (IProgressMonitor)progress.newChild(3));
                if (parsed.isEmpty()) {
                    handler.reportNothingToDo();
                    return;
                }
                foundWorkspaceWithAllChangeSets = false;
                Collection changeSets = parsed.getDescription().getChangeSets();
                try {
                    SubMonitor loopProgress = progress.newChild(91).setWorkRemaining(components.size());
                    for (ItemNamespace next : components) {
                        SubMonitor iterationProgress = loopProgress.newChild(1).setWorkRemaining(100);
                        IItemContext context = next.getContext((IProgressMonitor)iterationProgress.newChild(50));
                        Collection foundChanges = context.changeSetsInHistory(changeSets, (IProgressMonitor)iterationProgress.newChild(50));
                        if (changeSets.isEmpty() || foundChanges.isEmpty()) continue;
                        foundWorkspaceWithAllChangeSets = true;
                    }
                }
                catch (TeamRepositoryException e) {
                    if (e instanceof NotLoggedInException || e instanceof ItemNotFoundException) break block8;
                    StatusUtil.log(ApplyPatchUtil.class, (Throwable)e);
                }
            }
            if (foundWorkspaceWithAllChangeSets) {
                handler.duplicateChangeFound();
            }
            ApplyPatchUtil.applyPatch(handler, parsed, targetPath, patchDescription, (IProgressMonitor)progress.newChild(1));
        }
        catch (CoreException e) {
            throw new OperationFailedException(StatusUtil.newStatus(CreatePatchUtil.class, (Throwable)e));
        }
    }

    private static Set<ItemNamespace> getContributorPlacesFor(Set<IShareable> affectedShareables, IProgressMonitor monitor) throws TeamRepositoryException {
        HashSet result = NewCollection.hashSet();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)affectedShareables.size());
        for (IShareable shareable : affectedShareables) {
            ItemNamespace contributorPlace;
            if (shareable == null || (contributorPlace = CoreShareablesUtil.getContributorPlace((IShareable)shareable, (IProgressMonitor)progress.newChild(1))) == null) continue;
            result.add(contributorPlace);
        }
        return result;
    }

    static Set<ItemId> getItemsInActiveChangeSets(IWorkspaceConnection wc, IComponentHandle component, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        HashSet itemsWithLocalChanges = NewCollection.hashSet();
        List activeChangeSets = wc.activeChangeSets(component);
        Collection changeSets = RepoFetcher.fetchCurrents((ITeamRepository)wc.teamRepository(), (Collection)ItemLists.handlesToIds((Collection)activeChangeSets), (IProgressMonitor)progress.newChild(100)).values();
        for (IChangeSet next : changeSets) {
            for (Object _nextChange : next.changes()) {
                IChange nextChange = (IChange)_nextChange;
                itemsWithLocalChanges.add(ChangeSetUtil.getItem((IChange)nextChange));
            }
        }
        return itemsWithLocalChanges;
    }

    private static void applyPatch(ApplyPatchDilemmaHandler handler, ParsedPatch patch, IPath root, String changeDescription, IProgressMonitor monitor) throws CoreException, TeamRepositoryException {
        PatchModel model = PatchModel.getDefault();
        Patch contentChange = model.addPatch(patch, changeDescription, monitor);
        if (handler != null) {
            ArrayList<Patch> contentChanges = new ArrayList<Patch>();
            contentChanges.add(contentChange);
            handler.patchApplied(contentChanges);
        }
    }

    public static void applyPatch(UIContext context, ConfigurationChange patch, ChangeDescription changeDescription, IPathResolver pathResolver, IProgressMonitor monitor) throws TeamRepositoryException, OperationFailedException {
        StandardApplyPatchDilemmaHandler handler = new StandardApplyPatchDilemmaHandler(context);
        ApplyPatchUtil.applyPatch((ApplyPatchDilemmaHandler)handler, patch, changeDescription, pathResolver, monitor);
    }

    public static void applyPatch(ApplyPatchDilemmaHandler handler, ConfigurationChange change, ChangeDescription changeDescription, IPathResolver pathResolver, IProgressMonitor monitor) throws TeamRepositoryException, OperationFailedException {
        ParsedPatch patch;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        if (change.isEmpty()) {
            handler.reportNothingToDo();
            return;
        }
        try {
            patch = ParsedPatch.createFromConfigurationChange((ChangeDescription)changeDescription, (ConfigurationChange)change, (IPathResolver)pathResolver, (IProgressMonitor)progress.newChild(50));
        }
        catch (IOException e) {
            throw new OperationFailedException(StatusUtil.newStatus(ApplyPatchUtil.class, (Throwable)e));
        }
        ChangeClassifier changeClassifier = new ChangeClassifier(change.getChanges());
        handler.getCreatePatchHandler().nonTextChangesDetected(changeClassifier.getNonText());
        try {
            try {
                ApplyPatchUtil.applyPatch(handler, patch, (IPath)new Path(""), "", (IProgressMonitor)progress.newChild(50));
            }
            catch (CoreException e) {
                throw new OperationFailedException(StatusUtil.newStatus(ApplyPatchUtil.class, (Throwable)e));
            }
        }
        finally {
            patch.dispose();
        }
    }

    public static void closeAllOutgoingChanges(IComponentSyncContext next, IProgressMonitor newChild) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)newChild, (int)100);
        List activities = next.getOutgoingActivitySource().getActivities();
        ArrayList activeActivities = NewCollection.arrayList();
        HashSet changeSets = NewCollection.hashSet();
        for (IRemoteActivity activity : activities) {
            changeSets.add(PendingChangesUtil.getChangeSet(activity));
        }
        Map fetched = RepoFetcher.fetchCurrents((ITeamRepository)Repositories.getRepository(next), (Collection)changeSets, (IProgressMonitor)progress.newChild(10));
        for (IRemoteActivity activity : activities) {
            IChangeSet changeSet = (IChangeSet)fetched.get(PendingChangesUtil.getChangeSet(activity));
            if (changeSet == null || !changeSet.isActive()) continue;
            activeActivities.add(activity);
        }
        next.getOutgoingTeamPlace().ensureClosed((Collection)ComponentSyncUtil.getChangeSetHandles((Collection)activeActivities), (IProgressMonitor)progress.newChild(90));
    }

    public static IOutgoingRemoteActivity getCurrentActivity(IComponentSyncContext context) {
        List activities = context.getOutgoingActivitySource().getActivities();
        for (IRemoteActivity next : activities) {
            if (!context.isCurrent(next) || !context.isActive(next) || !(next instanceof IOutgoingRemoteActivity)) continue;
            return (IOutgoingRemoteActivity)next;
        }
        return null;
    }

    public static void applyAsPatch(ApplyPatchDilemmaHandler handler, List<? extends ChangeSetWrapper> changeSets, boolean reverse, IProgressMonitor monitor) throws TeamRepositoryException, OperationFailedException {
        ApplyPatchUtil.applyAsPatch(handler, changeSets, reverse, false, monitor);
    }

    public static void applyAsPatch(ApplyPatchDilemmaHandler handler, List<? extends ChangeSetWrapper> changeSets, boolean reverse, boolean failWhenComponenentsLoadedMultipleTimes, IProgressMonitor monitor) throws TeamRepositoryException, OperationFailedException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)3);
        ITeamRepository repo = null;
        HashMap<ItemId, ItemNamespace> namespaces = new HashMap<ItemId, ItemNamespace>();
        for (ChangeSetWrapper changeSetWrapper : changeSets) {
            IChangeSet changeSet = changeSetWrapper.getChangeSet();
            if (changeSetWrapper instanceof ChangeSetInContextWrapper) {
                ChangeSetInContextWrapper changeSetInContext = (ChangeSetInContextWrapper)changeSetWrapper;
                namespaces.put(ChangeSetUtil.getComponent((IChangeSet)changeSet), changeSetInContext.getNamespace());
                repo = changeSetInContext.getNamespace().getRepository();
            }
            if (repo != null) continue;
            repo = ClientRepositoryUtil.getRepository((IItemHandle)changeSet);
        }
        HashSet hashSet = NewCollection.hashSet();
        hashSet.addAll(namespaces.values());
        ArrayList<SnapshotPathResolver> pathResolvers = new ArrayList<SnapshotPathResolver>();
        if (!hashSet.isEmpty()) {
            pathResolvers.add(SnapshotPathResolver.create((SnapshotId)NamespaceSetId.create((ITeamRepository)((ItemNamespace)hashSet.iterator().next()).getRepository(), (Set)hashSet)));
        }
        FallbackPathResolver fpr = new FallbackPathResolver(pathResolvers);
        ParsedPatch patch = null;
        try {
            try {
                patch = ParsedPatch.createFromChangeSets((ITeamRepository)repo, ChangeSetWrapper.getChangeSets(changeSets), (boolean)reverse, (boolean)failWhenComponenentsLoadedMultipleTimes, (IPathResolver)fpr, (IProgressMonitor)monitor);
                ApplyPatchUtil.excludeSubcomponentChanges(handler, patch, (IProgressMonitor)progress.newChild(1));
                ApplyPatchUtil.warnOnRelatedArtifactChanges(handler, patch, (IProgressMonitor)progress.newChild(1));
                ApplyPatchUtil.applyPatch(handler, patch, (IPath)new Path(""), "", (IProgressMonitor)progress.newChild(1));
            }
            catch (DuplicateShareableException e) {
                throw new OperationFailedException(StatusUtil.newStatus(ApplyPatchUtil.class, (String)Messages.HistoryReverseChangesAction_multipleWorkspacesMessage));
            }
            catch (CoreException e) {
                throw new OperationFailedException(StatusUtil.newStatus(ApplyPatchUtil.class, (Throwable)e));
            }
        }
        finally {
            if (patch != null) {
                patch.dispose();
            }
        }
    }

    private static void excludeSubcomponentChanges(ApplyPatchDilemmaHandler handler, ParsedPatch patch, IProgressMonitor monitor) throws FileSystemException {
        Set paths = patch.getAffectedVersionablePaths((IPath)new Path(""), monitor);
        boolean hasSubcomponentChange = false;
        Iterator i = paths.iterator();
        while (i.hasNext()) {
            VersionablePath path = (VersionablePath)i.next();
            if (!SubcomponentCommonUtils.infoFileName().equals(path.getFileName())) continue;
            hasSubcomponentChange = true;
            i.remove();
        }
        if (hasSubcomponentChange) {
            handler.getCreatePatchHandler().reportSubcomponentChange();
        }
    }

    private static void warnOnRelatedArtifactChanges(ApplyPatchDilemmaHandler handler, ParsedPatch patch, IProgressMonitor monitor) throws TeamRepositoryException {
        Set filePatches = patch.getFilePatchSet();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)filePatches.size());
        for (ParsedFilePatch p : filePatches) {
            SubMonitor fileProgress = SubMonitor.convert((IProgressMonitor)progress.newChild(1), (int)2);
            for (PatchOp op : p.getAllOps((IProgressMonitor)fileProgress.newChild(1))) {
                AbstractStateChangeOp stateChangeOp;
                LinkDiffReport delta;
                if (!(op instanceof AbstractStateChangeOp) || (delta = (stateChangeOp = (AbstractStateChangeOp)op).getExternalLinksDelta((IProgressMonitor)fileProgress.newChild(1))).isUnchanged()) continue;
                handler.reportUnmergedRelatedArtifacts();
            }
        }
    }
}

