/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.operations;

import com.ibm.team.containers.common.IItemContainer;
import com.ibm.team.containers.common.IItemContainerHandle;
import com.ibm.team.containers.common.IItemContainerResponse;
import com.ibm.team.containers.common.IItemContainerService;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.operations.AbstractFolderOperation;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class RenameFolderOperation
extends AbstractFolderOperation {
    private String newName;

    public void rename(IItemContainer handle, String newName) {
        if (handle == null || newName == null || newName.isEmpty() || newName.equals(handle.getName())) {
            throw new IllegalArgumentException();
        }
        if (!this.toAdd.isEmpty()) {
            throw new IllegalStateException();
        }
        this.addOperand((ITeamRepository)handle.getOrigin(), handle.getOwner(), null, handle);
        this.newName = newName;
    }

    @Override
    protected void serviceCall(IItemContainerService service, ITeamRepository repo, IItemHandle owner, IItemContainerHandle parent, Collection<Object> values, IProgressMonitor monitor) throws TeamRepositoryException {
        if (values.size() != 1) {
            throw new IllegalStateException();
        }
        Object container = values.iterator().next();
        if (!(container instanceof IItemContainerHandle)) {
            throw new IllegalStateException();
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IItemContainerResponse response = service.renameContainer((IItemContainerHandle)container, this.newName, 0);
        repo.itemManager().applyItemUpdates(response.getModifiedContainers());
        progress.done();
    }

    @Override
    protected String getOperationName() {
        return Messages.RenameFolderOperation_OperationName;
    }

    @Override
    protected String getOperationShortId() {
        return "rename";
    }
}

