/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.operations;

import com.ibm.team.containers.common.IItemContainerHandle;
import com.ibm.team.containers.common.IItemContainerResponse;
import com.ibm.team.containers.common.IItemContainerService;
import com.ibm.team.containers.common.ItemContainerHasChildrenException;
import com.ibm.team.filesystem.ui.changes.actions.DialogUtil;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.operations.AbstractFolderOperation;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.repository.rcp.ui.utils.UIContext;
import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.ui.progress.UIJob;

public class RemoveFromFolderOperation
extends AbstractFolderOperation {
    private IItemHandle owner = null;
    private UIContext context;

    public RemoveFromFolderOperation(UIContext context) {
        this.context = context;
    }

    @Override
    protected void serviceCall(final IItemContainerService service, final ITeamRepository repo, IItemHandle owner, final IItemContainerHandle parent, final Collection<Object> values, IProgressMonitor monitor) throws TeamRepositoryException {
        final SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            IItemContainerResponse response = service.removeChildren(parent, values.toArray(new IItemHandle[values.size()]), 0);
            repo.itemManager().applyItemUpdates(response.getModifiedContainers());
            progress.worked(25);
        }
        catch (ItemContainerHasChildrenException e) {
            progress.setWorkRemaining(50);
            new UIJob(this.context.getDisplay(), Messages.RemoveFromFolderOperation_HasChildrenTitle){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    if (DialogUtil.openQuestionDialog(RemoveFromFolderOperation.this.context.getShell(), Messages.RemoveFromFolderOperation_HasChildrenTitle, Messages.RemoveFromFolderOperation_HasChildrenMessage, false)) {
                        RemoveFromFolderOperation.this.context.getUserOperationRunner().enqueue(Messages.RemoveFromFolderOperation_HasChildrenTitle, (Operation)new RepositoryOperation(){

                            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, OperationFailedException {
                                try {
                                    IItemContainerResponse response = service.removeChildren(parent, values.toArray(new IItemHandle[values.size()]), 1);
                                    repo.itemManager().applyItemUpdates(response.getModifiedContainers());
                                    progress.worked(25);
                                }
                                catch (TeamRepositoryException e) {
                                    problems.reportProblem(StatusUtil.newStatus((Object)((Object)this), (Throwable)e));
                                }
                            }
                        });
                    }
                    return Status.OK_STATUS;
                }
            }.schedule();
        }
    }

    public void remove(IItemContainerHandle currentParent, IItem item) {
        if (item == null) {
            throw new IllegalArgumentException();
        }
        this.addOperand((ITeamRepository)item.getOrigin(), this.owner, currentParent, item);
    }

    public void setOwner(IItemHandle owner) {
        this.owner = owner;
    }

    @Override
    protected String getOperationName() {
        return Messages.RemoveFromFolderOperation_OperationName;
    }

    @Override
    protected String getOperationShortId() {
        return "remove";
    }
}

