/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.operations;

import com.ibm.team.containers.common.IItemContainerHandle;
import com.ibm.team.containers.common.IItemContainerResponse;
import com.ibm.team.containers.common.IItemContainerService;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.operations.AbstractFolderOperation;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class MoveToFolderOperation
extends AbstractFolderOperation {
    private IItemContainerHandle target;

    public void move(IItemHandle owner, IItemContainerHandle currentParent, IItem item) {
        boolean moveToSameParent;
        if (owner == null || item == null) {
            throw new IllegalArgumentException();
        }
        boolean moveToSameItem = item.sameItemId((IItemHandle)this.target);
        boolean bl = this.target == null ? currentParent == null : (moveToSameParent = this.target.sameItemId((IItemHandle)currentParent));
        if (!moveToSameItem && !moveToSameParent) {
            this.addOperand((ITeamRepository)item.getOrigin(), owner, currentParent, item);
        }
    }

    @Override
    public void serviceCall(IItemContainerService service, ITeamRepository repo, IItemHandle owner, IItemContainerHandle currentParent, Collection<Object> values, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        if (this.target == null) {
            this.target = service.getRootContainer("com.ibm.team.scm.container.root", owner, 0);
            progress.worked(33);
        }
        progress.setWorkRemaining(67);
        IItemContainerResponse response = service.moveChildren(currentParent, this.target, values.toArray(new IItemHandle[values.size()]), 16);
        repo.itemManager().applyItemUpdates(response.getModifiedContainers());
        progress.done();
    }

    public void setTarget(IItemContainerHandle target) {
        this.target = target;
    }

    public IItemContainerHandle getTarget() {
        return this.target;
    }

    @Override
    protected String getOperationName() {
        return Messages.MoveToFolderOperation_OperationName;
    }

    @Override
    protected String getOperationShortId() {
        return "move";
    }
}

