/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.operations;

import com.ibm.team.containers.common.IItemContainerCreateResponse;
import com.ibm.team.containers.common.IItemContainerHandle;
import com.ibm.team.containers.common.IItemContainerService;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.operations.AbstractFolderOperation;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class CreateFolderOperation
extends AbstractFolderOperation {
    public void add(ITeamRepository repo, IItemContainerHandle parent, IItemHandle owner, String name) {
        if (repo == null || owner == null || name == null || name.isEmpty()) {
            throw new IllegalArgumentException();
        }
        this.addOperand(repo, owner, parent, name);
    }

    @Override
    public void serviceCall(IItemContainerService service, ITeamRepository repo, IItemHandle owner, IItemContainerHandle parent, Collection<Object> values, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IItemContainerCreateResponse response = service.createContainers(parent, owner, values.toArray(new String[values.size()]), 0);
        repo.itemManager().applyItemUpdates(response.getModifiedContainers());
        progress.done();
    }

    @Override
    protected String getOperationName() {
        return Messages.CreateFolderOperation_OperationName;
    }

    @Override
    protected String getOperationShortId() {
        return "create";
    }
}

