/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.operations;

import com.ibm.team.containers.common.IItemContainerHandle;
import com.ibm.team.containers.common.IItemContainerResponse;
import com.ibm.team.containers.common.IItemContainerService;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.operations.AbstractFolderOperation;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class AddToFolderOperation
extends AbstractFolderOperation {
    public void add(IItemHandle owner, IItemContainerHandle parent, IItem item) {
        if (item == null || owner == null && parent == null) {
            throw new IllegalArgumentException();
        }
        this.addOperand((ITeamRepository)item.getOrigin(), owner, parent, item);
    }

    @Override
    public void serviceCall(IItemContainerService service, ITeamRepository repo, IItemHandle owner, IItemContainerHandle parent, Collection<Object> values, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IItemContainerResponse response = service.addChildren(parent, values.toArray(new IItemHandle[values.size()]), 16);
        repo.itemManager().applyItemUpdates(response.getModifiedContainers());
        progress.done();
    }

    @Override
    protected String getOperationName() {
        return Messages.AddToFolderOperation_OperationName;
    }

    @Override
    protected String getOperationShortId() {
        return "add";
    }
}

