/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.operations;

import com.ibm.team.containers.common.IItemContainerHandle;
import com.ibm.team.containers.common.IItemContainerService;
import com.ibm.team.process.client.IProcessClientService;
import com.ibm.team.process.common.advice.IOperationReport;
import com.ibm.team.process.common.advice.ProcessRunnable;
import com.ibm.team.process.common.advice.TeamOperationCanceledException;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.PermissionDeniedException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public abstract class AbstractFolderOperation
implements Operation {
    private static final String PROCESS_OPERATION = "com.ibm.team.artifactfolders.modify";
    public static final String CONTAINER_PERMISSION_DENIED = "com.ibm.team.internal.filesystem.ui.operations.permission.denied";
    protected Map<ITeamRepository, IWorkspaceManager> managers = new HashMap<ITeamRepository, IWorkspaceManager>();
    protected Map<PartitionKey, Collection<Object>> toAdd = new HashMap<PartitionKey, Collection<Object>>();

    protected abstract void serviceCall(IItemContainerService var1, ITeamRepository var2, IItemHandle var3, IItemContainerHandle var4, Collection<Object> var5, IProgressMonitor var6) throws TeamRepositoryException;

    protected abstract String getOperationName();

    protected abstract String getOperationShortId();

    protected void addOperand(ITeamRepository repo, IItemHandle owner, IItemContainerHandle parent, Object value) {
        if (repo == null || value == null) {
            throw new IllegalArgumentException();
        }
        this.rememberManager(repo);
        PartitionKey key = new PartitionKey(repo, parent, owner);
        Collection<Object> values = this.toAdd.get(key);
        if (values == null) {
            values = new ArrayList<Object>();
            this.toAdd.put(key, values);
        }
        values.add(value);
    }

    protected IWorkspaceManager getManager(ITeamRepository repo) {
        IWorkspaceManager manager = this.managers.get(repo);
        if (manager == null) {
            throw new IllegalStateException("Manager for repo has not been set");
        }
        return manager;
    }

    protected void rememberManager(ITeamRepository repo) {
        if (!this.managers.containsKey(repo)) {
            this.managers.put(repo, SCMPlatform.getWorkspaceManager((ITeamRepository)repo));
        }
    }

    public void run(IProgressMonitor monitor, IStatusCollector problems) throws OperationFailedException {
        SubMonitor loopProgress = SubMonitor.convert((IProgressMonitor)monitor, (int)(this.toAdd.size() * 100));
        for (Map.Entry<PartitionKey, Collection<Object>> entry : this.toAdd.entrySet()) {
            PartitionKey key = entry.getKey();
            IWorkspaceManager manager = this.getManager(key.getRepo());
            try {
                IItemContainerService service = manager.getItemContainerService();
                this.serviceCall(service, key.getRepo(), key.getOwner(), key.getParent((IProgressMonitor)loopProgress.newChild(10)), entry.getValue(), (IProgressMonitor)loopProgress.newChild(90));
            }
            catch (TeamRepositoryException e) {
                if (e instanceof PermissionDeniedException || e instanceof TeamOperationCanceledException) {
                    this.notifyProcess(manager, e, monitor);
                    if (e.getData() == null) {
                        e.setData((Object)CONTAINER_PERMISSION_DENIED);
                    }
                }
                throw new OperationFailedException(StatusUtil.newStatus((Object)this, (Throwable)e));
            }
        }
    }

    private void notifyProcess(IWorkspaceManager manager, final Throwable cause, IProgressMonitor monitor) {
        try {
            IProcessClientService process = (IProcessClientService)manager.teamRepository().getClientLibrary(IProcessClientService.class);
            process.execute(new ProcessRunnable(){

                public IOperationReport run(IProgressMonitor monitor) throws TeamRepositoryException {
                    if (cause == null) {
                        return null;
                    }
                    throw (TeamRepositoryException)cause;
                }

                public String getOperationIdentifier() {
                    return "com.ibm.team.artifactfolders.modify#" + AbstractFolderOperation.this.getOperationShortId();
                }

                public boolean equals(Object obj) {
                    if (obj instanceof ProcessRunnable) {
                        return this.getOperationIdentifier().equals(((ProcessRunnable)obj).getOperationIdentifier());
                    }
                    return super.equals(obj);
                }
            }, this.getOperationName(), monitor);
        }
        catch (TeamRepositoryException teamRepositoryException) {
            // empty catch block
        }
    }

    protected class PartitionKey {
        private ITeamRepository repo;
        private IItemContainerHandle parent;
        private IItemHandle owner;

        protected PartitionKey(ITeamRepository repo, IItemContainerHandle parent, IItemHandle owner) {
            if (repo == null) {
                throw new IllegalArgumentException();
            }
            this.repo = repo;
            this.parent = parent;
            this.owner = owner;
        }

        protected ITeamRepository getRepo() {
            return this.repo;
        }

        protected IItemContainerHandle getParent(IProgressMonitor monitor) throws TeamRepositoryException {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            if (this.parent == null) {
                IWorkspaceManager manager = AbstractFolderOperation.this.getManager(this.repo);
                IItemContainerService service = manager.getItemContainerService();
                this.parent = service.getRootContainer("com.ibm.team.scm.container.root", this.owner, 0);
            }
            progress.done();
            return this.parent;
        }

        protected IItemHandle getOwner() {
            return this.owner;
        }

        private AbstractFolderOperation getOuterType() {
            return AbstractFolderOperation.this;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this.owner == null ? 0 : this.owner.getItemId().hashCode());
            result = 31 * result + (this.parent == null ? 0 : this.parent.getItemId().hashCode());
            result = 31 * result + (this.repo == null ? 0 : this.repo.getRepositoryURI().hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PartitionKey other = (PartitionKey)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            if (this.owner == null ? other.owner != null : !this.owner.sameItemId(other.owner)) {
                return false;
            }
            if (this.parent == null ? other.parent != null : !this.parent.sameItemId((IItemHandle)other.parent)) {
                return false;
            }
            return !(this.repo == null ? other.repo != null : !this.repo.getRepositoryURI().equals(other.repo.getRepositoryURI()));
        }
    }
}

