/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.openactions;

import com.ibm.team.filesystem.ide.ui.internal.editors.component.ComponentEditor;
import com.ibm.team.filesystem.ide.ui.internal.editors.component.ComponentEditorInput;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncContext;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ISubcomponentChange;
import com.ibm.team.filesystem.ui.wrapper.ComponentWrapper;
import com.ibm.team.filesystem.ui.wrapper.WorkspaceComponentWrapper;
import com.ibm.team.foundation.common.util.Adapters;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.rcp.ui.utils.AbstractActionDelegate;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IComponent;
import java.util.HashSet;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public class OpenWorkspaceComponentAction
extends AbstractActionDelegate {
    public void selectionChanged(IAction action, ISelection selection) {
        boolean shouldEnable = true;
        for (Object o : ((IStructuredSelection)selection).toList()) {
            ISubcomponentChange subcomponentChange;
            if (!(o instanceof ISubcomponentChange) || !(subcomponentChange = (ISubcomponentChange)o).isComponentInaccessible()) continue;
            shouldEnable = false;
            break;
        }
        action.setEnabled(shouldEnable);
        super.selectionChanged(action, selection);
    }

    public void run(Shell shell, IWorkbenchPage page, IStructuredSelection selection) {
        HashSet<WorkspaceComponentWrapper> componentsToOpen = new HashSet<WorkspaceComponentWrapper>();
        for (Object obj : selection) {
            ISubcomponentChange subcomponentChange;
            IComponent component;
            if ((obj == null || !Adapters.hasAdapter(obj, WorkspaceComponentWrapper.class) && !(obj instanceof IComponentSyncContext)) && !(obj instanceof ISubcomponentChange)) continue;
            WorkspaceComponentWrapper componentWrapper = (WorkspaceComponentWrapper)Adapters.getAdapter(obj, WorkspaceComponentWrapper.class);
            if (componentWrapper == null && obj instanceof IComponentSyncContext) {
                IComponentSyncContext context = (IComponentSyncContext)obj;
                IWorkspaceConnection connection = context.getOutgoingTeamPlace();
                IComponent component2 = context.getComponent();
                if (connection != null && component2 != null) {
                    componentWrapper = WorkspaceComponentWrapper.newWrapper(connection, component2);
                }
            }
            if (componentWrapper == null && obj instanceof ISubcomponentChange && (component = (subcomponentChange = (ISubcomponentChange)obj).getComponent()) != null) {
                IWorkspaceConnection connection = subcomponentChange.getContainingWorkspaceConnection();
                if (connection != null) {
                    componentWrapper = WorkspaceComponentWrapper.newWrapper(connection, component);
                } else {
                    ComponentWrapper wrapper = new ComponentWrapper((ITeamRepository)subcomponentChange.getComponent().getOrigin(), component);
                    ComponentEditor.open(page, ComponentEditorInput.newForEdit(wrapper));
                }
            }
            if (componentWrapper == null) continue;
            componentsToOpen.add(componentWrapper);
        }
        for (WorkspaceComponentWrapper component : componentsToOpen) {
            ComponentEditor.open(page, ComponentEditorInput.newForEdit(component));
        }
    }
}

