/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.openactions;

import com.ibm.team.filesystem.ide.ui.internal.editors.component.ComponentEditor;
import com.ibm.team.filesystem.ide.ui.internal.editors.component.ComponentEditorInput;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncContext;
import com.ibm.team.filesystem.ui.wrapper.ComponentWrapper;
import com.ibm.team.filesystem.ui.wrapper.WorkspaceComponentWrapper;
import com.ibm.team.foundation.common.util.Adapters;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.nodes.StructuralChangesComponentNode;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.nodes.StructuralChangesSubcomponentNode;
import com.ibm.team.repository.rcp.ui.utils.AbstractActionDelegate;
import java.util.HashSet;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public class OpenComponentAction
extends AbstractActionDelegate {
    public void selectionChanged(IAction action, ISelection selection) {
        boolean shouldEnable = true;
        for (Object obj : (IStructuredSelection)selection) {
            StructuralChangesSubcomponentNode node;
            if (!(obj instanceof StructuralChangesSubcomponentNode) || (node = (StructuralChangesSubcomponentNode)obj).getComponent() != null) continue;
            shouldEnable = false;
            break;
        }
        action.setEnabled(shouldEnable);
        super.selectionChanged(action, selection);
    }

    public void run(Shell shell, IWorkbenchPage page, IStructuredSelection selection) {
        HashSet<ComponentWrapper> componentsToOpen = new HashSet<ComponentWrapper>();
        HashSet<WorkspaceComponentWrapper> componentsWithContextToOpen = new HashSet<WorkspaceComponentWrapper>();
        for (Object obj : selection) {
            Object wrapper;
            if (obj == null || !Adapters.hasAdapter(obj, WorkspaceComponentWrapper.class) && !Adapters.hasAdapter(obj, ComponentWrapper.class) && !(obj instanceof IComponentSyncContext) && !(obj instanceof StructuralChangesComponentNode) && !(obj instanceof StructuralChangesSubcomponentNode)) continue;
            WorkspaceComponentWrapper workspaceComponentWrapper = (WorkspaceComponentWrapper)Adapters.getAdapter(obj, WorkspaceComponentWrapper.class);
            if (workspaceComponentWrapper != null) {
                componentsWithContextToOpen.add(workspaceComponentWrapper);
                continue;
            }
            ComponentWrapper componentWrapper = (ComponentWrapper)((Object)Adapters.getAdapter(obj, ComponentWrapper.class));
            if (componentWrapper != null) {
                componentsToOpen.add(componentWrapper);
                continue;
            }
            if (obj instanceof IComponentSyncContext) {
                IComponentSyncContext context = (IComponentSyncContext)obj;
                componentsToOpen.add(new ComponentWrapper(context.localTeamRepository(), context.getComponent()));
                continue;
            }
            if (obj instanceof StructuralChangesComponentNode) {
                StructuralChangesComponentNode ChangeExplorerComponent = (StructuralChangesComponentNode)obj;
                wrapper = ChangeExplorerComponent.getWrapper();
                if (wrapper instanceof ComponentWrapper) {
                    componentsToOpen.add((ComponentWrapper)((Object)wrapper));
                    continue;
                }
                if (wrapper instanceof WorkspaceComponentWrapper) {
                    componentsWithContextToOpen.add((WorkspaceComponentWrapper)wrapper);
                    continue;
                }
            }
            if (!(obj instanceof StructuralChangesSubcomponentNode)) continue;
            StructuralChangesSubcomponentNode ChangeExplorerSubcomponent = (StructuralChangesSubcomponentNode)obj;
            wrapper = ChangeExplorerSubcomponent.getWrapper();
            if (wrapper instanceof ComponentWrapper) {
                componentsToOpen.add((ComponentWrapper)((Object)wrapper));
                continue;
            }
            if (!(wrapper instanceof WorkspaceComponentWrapper)) continue;
            componentsWithContextToOpen.add((WorkspaceComponentWrapper)wrapper);
        }
        for (ComponentWrapper componentWrapper : componentsToOpen) {
            ComponentEditor.open(page, ComponentEditorInput.newForEdit(componentWrapper));
        }
        for (WorkspaceComponentWrapper workspaceComponentWrapper : componentsWithContextToOpen) {
            ComponentEditor.open(page, ComponentEditorInput.newForEdit(workspaceComponentWrapper));
        }
    }
}

