/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.openactions;

import com.ibm.team.filesystem.ide.ui.internal.editors.baseline.BaselineEditor;
import com.ibm.team.filesystem.ide.ui.internal.editors.baseline.BaselineEditorInput;
import com.ibm.team.filesystem.ide.ui.internal.util.DisplayHelper;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IBaselineGroup;
import com.ibm.team.filesystem.ui.configuration.IHistoryEntry;
import com.ibm.team.filesystem.ui.wrapper.BaselineHierarchyWrapper;
import com.ibm.team.filesystem.ui.wrapper.BaselineWrapper;
import com.ibm.team.foundation.common.util.Adapters;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IFetchResult;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.repository.rcp.ui.utils.AbstractActionDelegate;
import com.ibm.team.scm.common.IBaseline;
import com.ibm.team.scm.common.IBaselineHandle;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public class OpenBaselineAction
extends AbstractActionDelegate {
    public static final String ACTION_ID = "com.ibm.team.internal.filesystem.ui.openactions.OpenBaselineAction";

    public void selectionChanged(IAction action, ISelection selection) {
        super.selectionChanged(action, selection);
        if (selection == null) {
            action.setEnabled(false);
            return;
        }
        for (Object o : ((IStructuredSelection)selection).toList()) {
            IBaselineGroup baseline;
            if (Adapters.getAdapter(o, BaselineWrapper.class) != null) {
                action.setEnabled(true);
                return;
            }
            if (o instanceof BaselineHierarchyWrapper) {
                BaselineHierarchyWrapper wrapper = (BaselineHierarchyWrapper)((Object)o);
                if (wrapper.getHierarchy() == null) continue;
                action.setEnabled(true);
                return;
            }
            if (o instanceof IHistoryEntry) {
                IHistoryEntry entry = (IHistoryEntry)o;
                if (entry.getBaseline() == null) continue;
                action.setEnabled(true);
                return;
            }
            if (!(o instanceof IBaselineGroup) || (baseline = (IBaselineGroup)o).getBaseline() == null) continue;
            action.setEnabled(true);
            return;
        }
        action.setEnabled(false);
    }

    public void run(final Shell shell, final IWorkbenchPage page, IStructuredSelection selection) {
        HashSet<BaselineWrapper> baselineWrappers = new HashSet<BaselineWrapper>();
        final HashSet<BaselineHierarchyWrapper> baselineHierarchyWrappers = new HashSet<BaselineHierarchyWrapper>();
        final HashSet<IHistoryEntry> baselinesInHistory = new HashSet<IHistoryEntry>();
        final HashSet<IBaselineGroup> baselinesInPcView = new HashSet<IBaselineGroup>();
        for (Object o : selection.toList()) {
            IBaselineGroup baseline;
            BaselineWrapper wrapper = (BaselineWrapper)Adapters.getAdapter(o, BaselineWrapper.class);
            if (wrapper != null) {
                baselineWrappers.add(wrapper);
                continue;
            }
            if (o instanceof BaselineWrapper) {
                baselineWrappers.add((BaselineWrapper)o);
                continue;
            }
            if (o instanceof BaselineHierarchyWrapper) {
                BaselineHierarchyWrapper baselineInHierarchy = (BaselineHierarchyWrapper)((Object)o);
                if (baselineInHierarchy.getHierarchy() == null) continue;
                baselineHierarchyWrappers.add(baselineInHierarchy);
                continue;
            }
            if (o instanceof IHistoryEntry) {
                IHistoryEntry entry = (IHistoryEntry)o;
                if (entry.getBaseline() == null) continue;
                baselinesInHistory.add(entry);
                continue;
            }
            if (!(o instanceof IBaselineGroup) || (baseline = (IBaselineGroup)o).getBaseline() == null) continue;
            baselinesInPcView.add(baseline);
        }
        for (BaselineWrapper wrapper : baselineWrappers) {
            BaselineEditor.open(page, BaselineEditorInput.newForEdit(wrapper));
        }
        if (!(baselineHierarchyWrappers.isEmpty() && baselinesInHistory.isEmpty() && baselinesInPcView.isEmpty())) {
            this.getOperationRunner().enqueue(Messages.OpenBaselineAction_FetchingJobName, (Operation)new RepositoryOperation(){

                public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, OperationFailedException {
                    IBaseline baseline;
                    IComponent component;
                    ITeamRepository repo;
                    SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(baselineHierarchyWrappers.size() + baselinesInHistory.size() + baselinesInPcView.size()));
                    final HashSet<BaselineWrapper> wrappersToOpen = new HashSet<BaselineWrapper>(baselineHierarchyWrappers.size() + baselinesInHistory.size() + baselinesInPcView.size());
                    if (!baselineHierarchyWrappers.isEmpty()) {
                        repo = ((BaselineHierarchyWrapper)((Object)baselineHierarchyWrappers.iterator().next())).getRepository();
                        HashMap<UUID, IComponent> hashMap = new HashMap<UUID, IComponent>(baselineHierarchyWrappers.size());
                        ArrayList<Object> toFetch = new ArrayList<Object>(baselineHierarchyWrappers.size());
                        for (BaselineHierarchyWrapper wrapper : baselineHierarchyWrappers) {
                            if (wrapper.getHierarchy() == null) continue;
                            IBaselineHandle baselineHandle = wrapper.getHierarchy().getBaselineHandle();
                            hashMap.put(baselineHandle.getItemId(), wrapper.getComponent());
                            toFetch.add(baselineHandle);
                        }
                        if (!toFetch.isEmpty()) {
                            IFetchResult fetchResult = repo.itemManager().fetchCompleteItemsPermissionAware(toFetch, 0, (IProgressMonitor)progress.newChild(50));
                            for (Object o : fetchResult.getRetrievedItems()) {
                                if (!(o instanceof IBaseline) || (component = (IComponent)hashMap.get((baseline = (IBaseline)o).getItemId())) == null) continue;
                                wrappersToOpen.add(new BaselineWrapper(repo, baseline, component));
                            }
                        }
                    }
                    progress.setWorkRemaining(baselinesInHistory.size() + baselinesInPcView.size());
                    if (!baselinesInHistory.isEmpty()) {
                        repo = ((IHistoryEntry)baselinesInHistory.iterator().next()).getRepository();
                        ArrayList<IComponentHandle> arrayList = new ArrayList<IComponentHandle>();
                        for (IHistoryEntry entry : baselinesInHistory) {
                            if (entry.getBaseline() == null) continue;
                            IBaseline baseline2 = entry.getBaseline();
                            arrayList.add(baseline2.getComponent());
                        }
                        if (!arrayList.isEmpty()) {
                            IFetchResult fetchResult = repo.itemManager().fetchCompleteItemsPermissionAware(arrayList, 0, (IProgressMonitor)progress.newChild(50));
                            HashMap<UUID, IComponent> fetchedComponents = new HashMap<UUID, IComponent>(fetchResult.getRetrievedItems().size());
                            for (Object o : fetchResult.getRetrievedItems()) {
                                if (!(o instanceof IComponent)) continue;
                                IComponent component2 = (IComponent)o;
                                fetchedComponents.put(component2.getItemId(), component2);
                            }
                            for (IHistoryEntry entry : baselinesInHistory) {
                                if (entry.getBaseline() == null || (component = (IComponent)fetchedComponents.get((baseline = entry.getBaseline()).getComponent().getItemId())) == null) continue;
                                wrappersToOpen.add(new BaselineWrapper(repo, baseline, component));
                            }
                        }
                    }
                    progress.setWorkRemaining(baselinesInPcView.size());
                    if (!baselinesInPcView.isEmpty()) {
                        HashMap<ITeamRepository, ArrayList<IComponentHandle>> toFetch = new HashMap<ITeamRepository, ArrayList<IComponentHandle>>();
                        for (IBaselineGroup iBaselineGroup : baselinesInPcView) {
                            IBaseline baseline3;
                            if (iBaselineGroup.getBaseline() == null || !((baseline3 = iBaselineGroup.getBaseline()).getOrigin() instanceof ITeamRepository)) continue;
                            ITeamRepository repo2 = (ITeamRepository)baseline3.getOrigin();
                            ArrayList<IComponentHandle> componentsToFetch = (ArrayList<IComponentHandle>)toFetch.get(repo2);
                            if (componentsToFetch == null) {
                                componentsToFetch = new ArrayList<IComponentHandle>();
                                toFetch.put(repo2, componentsToFetch);
                            }
                            componentsToFetch.add(baseline3.getComponent());
                        }
                        if (!toFetch.isEmpty()) {
                            for (Map.Entry entry : toFetch.entrySet()) {
                                ITeamRepository repo3 = (ITeamRepository)entry.getKey();
                                IFetchResult fetchResult = repo3.itemManager().fetchCompleteItemsPermissionAware((List)entry.getValue(), 0, (IProgressMonitor)progress.newChild(50));
                                HashMap<UUID, IComponent> fetchedComponents = new HashMap<UUID, IComponent>(fetchResult.getRetrievedItems().size());
                                for (Object o : fetchResult.getRetrievedItems()) {
                                    if (!(o instanceof IComponent)) continue;
                                    IComponent component3 = (IComponent)o;
                                    fetchedComponents.put(component3.getItemId(), component3);
                                }
                                for (IBaselineGroup baselineNode : baselinesInPcView) {
                                    IBaseline baseline4;
                                    IComponent component4;
                                    if (baselineNode.getBaseline() == null || (component4 = (IComponent)fetchedComponents.get((baseline4 = baselineNode.getBaseline()).getComponent().getItemId())) == null) continue;
                                    wrappersToOpen.add(new BaselineWrapper(repo3, baseline4, component4));
                                }
                            }
                        }
                    }
                    DisplayHelper.asyncExec((Control)shell, new Runnable(){

                        @Override
                        public void run() {
                            for (BaselineWrapper wrapper : wrappersToOpen) {
                                BaselineEditor.open(page, BaselineEditorInput.newForEdit(wrapper));
                            }
                        }
                    });
                }
            });
        }
    }
}

