/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.labelproviders;

import com.ibm.team.filesystem.rcp.core.internal.FileSystemResourcesPlugin;
import com.ibm.team.filesystem.rcp.core.internal.changes.ILocalSynchronizationManager;
import com.ibm.team.filesystem.ui.wrapper.AbstractWrapper;
import com.ibm.team.filesystem.ui.wrapper.BaselineWrapper;
import com.ibm.team.filesystem.ui.wrapper.HierarchyData;
import com.ibm.team.filesystem.ui.wrapper.IConfigurationWrapper;
import com.ibm.team.filesystem.ui.wrapper.WorkspaceComponentWrapper;
import com.ibm.team.internal.filesystem.ui.ImagePool;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.labelproviders.SharedItemLabelProvider;
import com.ibm.team.internal.filesystem.ui.util.WorkspaceUtil;
import com.ibm.team.repository.client.ISharedItemChangeEvent;
import com.ibm.team.repository.client.ISharedItemChangeListener;
import com.ibm.team.repository.client.util.IEvent;
import com.ibm.team.repository.client.util.IListener;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.rcp.ui.internal.utils.SWTUtil;
import com.ibm.team.repository.rcp.ui.internal.viewers.ISetWithListeners;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.operations.JobRunner;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.events.IChangeHistoryEvent;
import com.ibm.team.scm.client.events.ILockEvent;
import com.ibm.team.scm.client.internal.PatchUpdateEvent;
import com.ibm.team.scm.common.ComponentNotInWorkspaceException;
import com.ibm.team.scm.common.IBaseline;
import com.ibm.team.scm.common.IBaselineHandle;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.ICurrentComponentInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.osgi.util.NLS;
import org.eclipse.osgi.util.TextProcessor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IDecoratorManager;
import org.eclipse.ui.PlatformUI;

public class WorkspaceComponentLabelProvider
extends SharedItemLabelProvider {
    private Map<WorkspaceComponentWrapper, UUID> fComponentToBasisUUID = new HashMap<WorkspaceComponentWrapper, UUID>();
    private ISharedItemChangeListener fBasisItemChangeListener = new ISharedItemChangeListener(){

        public void itemsChanged(List events) {
            final HashSet<UUID> baselineComponents = new HashSet<UUID>();
            for (Object o : events) {
                ISharedItemChangeEvent event;
                if (!(o instanceof ISharedItemChangeEvent) || !((event = (ISharedItemChangeEvent)o).getSharedItem() instanceof IBaseline)) continue;
                IBaseline changedBaseline = (IBaseline)event.getSharedItem();
                if (!WorkspaceComponentLabelProvider.this.fComponentToBasisUUID.values().contains(changedBaseline.getItemId())) continue;
                baselineComponents.add(changedBaseline.getComponent().getItemId());
            }
            if (!baselineComponents.isEmpty()) {
                SWTUtil.greedyExec((Display)WorkspaceComponentLabelProvider.this.getDisplay(), (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ArrayList<WorkspaceComponentWrapper> toUpdate = new ArrayList<WorkspaceComponentWrapper>();
                        for (Object element : WorkspaceComponentLabelProvider.this.getKnownElements()) {
                            WorkspaceComponentWrapper wrapper;
                            if (!(element instanceof WorkspaceComponentWrapper) || !baselineComponents.contains((wrapper = (WorkspaceComponentWrapper)element).getComponentHandle().getItemId()) || toUpdate.contains(wrapper)) continue;
                            toUpdate.add(wrapper);
                        }
                        WorkspaceComponentLabelProvider.this.fireChangeEvent(toUpdate);
                    }
                });
            }
        }
    };
    private Set<IWorkspaceConnection> fHookedConnections = new HashSet<IWorkspaceConnection>();
    private IListener fSharedComponentsListener = new IListener(){

        public void handleEvents(List events) {
            SWTUtil.greedyExec((Display)WorkspaceComponentLabelProvider.this.getDisplay(), (Runnable)new Runnable(){

                @Override
                public void run() {
                    WorkspaceComponentLabelProvider.this.fireChangeEvent((Collection)WorkspaceComponentLabelProvider.this.getKnownElements());
                }
            });
        }
    };
    private IListener fLockListener = new IListener(){

        public void handleEvents(List events) {
            for (Object object : events) {
                ILockEvent lockEvent;
                if (!(object instanceof ILockEvent) || !(lockEvent = (ILockEvent)object).getEventType().equals("com.ibm.team.scm.LockEvent.ComponentsLocked")) continue;
                SWTUtil.greedyExec((Display)WorkspaceComponentLabelProvider.this.getDisplay(), (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ArrayList<WorkspaceComponentWrapper> toUpdate = new ArrayList<WorkspaceComponentWrapper>();
                        for (Object element : WorkspaceComponentLabelProvider.this.getKnownElements()) {
                            if (!(element instanceof WorkspaceComponentWrapper)) continue;
                            WorkspaceComponentWrapper wrapper = (WorkspaceComponentWrapper)element;
                            if (lockEvent.getComponentIDs().contains(wrapper.getComponentHandle().getItemId())) {
                                toUpdate.add(wrapper);
                            }
                            wrapper.getComponentHandle().getItemId();
                        }
                        WorkspaceComponentLabelProvider.this.fireChangeEvent(toUpdate);
                    }
                });
            }
        }
    };
    private IListener fBasesListener = new IListener(){

        public void handleEvents(List events) {
            final HashSet<UUID> eventSources = new HashSet<UUID>();
            for (Object o : events) {
                IChangeHistoryEvent changeHistoryEvent;
                IEvent event;
                if (!(o instanceof IEvent) || !((event = (IEvent)o).getEventSource() instanceof IWorkspaceConnection)) continue;
                IWorkspaceConnection eventSource = (IWorkspaceConnection)event.getEventSource();
                eventSources.add(eventSource.getResolvedWorkspace().getItemId());
                if (!(event instanceof IChangeHistoryEvent) || !(changeHistoryEvent = (IChangeHistoryEvent)event).getEventType().equals("com.ibm.team.scm.ChangeHistoryEvent.Deliver")) continue;
                eventSources.add(changeHistoryEvent.getDeliverTarget().getItemId());
            }
            if (!eventSources.isEmpty()) {
                SWTUtil.greedyExec((Display)WorkspaceComponentLabelProvider.this.getDisplay(), (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ArrayList<WorkspaceComponentWrapper> toUpdate = new ArrayList<WorkspaceComponentWrapper>();
                        for (Object element : WorkspaceComponentLabelProvider.this.getKnownElements()) {
                            WorkspaceComponentWrapper wrapper;
                            if (!(element instanceof WorkspaceComponentWrapper) || !eventSources.contains((wrapper = (WorkspaceComponentWrapper)element).getWorkspace().getItemId()) || toUpdate.contains(wrapper)) continue;
                            toUpdate.add(wrapper);
                        }
                        WorkspaceComponentLabelProvider.this.fireChangeEvent(toUpdate);
                    }
                });
            }
        }
    };
    private IListener fPortListener = new IListener(){

        public void handleEvents(List events) {
            final HashMap eventSources = new HashMap();
            for (Object event : events) {
                if (!(event instanceof PatchUpdateEvent)) continue;
                PatchUpdateEvent patchUpdateEvent = (PatchUpdateEvent)event;
                UUID workspaceUUID = patchUpdateEvent.getWorkspaceConnection().getResolvedWorkspace().getItemId();
                HashSet components = (HashSet)eventSources.get(workspaceUUID);
                if (components == null) {
                    components = new HashSet();
                }
                components.addAll(patchUpdateEvent.getComponentsWithCurrentPatchChanges());
                components.addAll(patchUpdateEvent.getComponentsWithAcceptQueueChanges());
                eventSources.put(workspaceUUID, components);
            }
            if (!eventSources.isEmpty()) {
                SWTUtil.greedyExec((Display)WorkspaceComponentLabelProvider.this.getDisplay(), (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ArrayList<WorkspaceComponentWrapper> toUpdate = new ArrayList<WorkspaceComponentWrapper>();
                        for (Object element : WorkspaceComponentLabelProvider.this.getKnownElements()) {
                            WorkspaceComponentWrapper wrapper;
                            Set components;
                            if (!(element instanceof WorkspaceComponentWrapper) || (components = (Set)eventSources.get((wrapper = (WorkspaceComponentWrapper)element).getWorkspace().getItemId())) == null || !components.contains(wrapper.getComponent().getItemId()) || toUpdate.contains(wrapper)) continue;
                            toUpdate.add(wrapper);
                        }
                        WorkspaceComponentLabelProvider.this.fireChangeEvent(toUpdate);
                    }
                });
            }
        }
    };

    public WorkspaceComponentLabelProvider() {
        this(null, (IOperationRunner)new JobRunner(false));
    }

    public WorkspaceComponentLabelProvider(ISetWithListeners knownElements, IOperationRunner runner) {
        super(knownElements, runner);
        ILocalSynchronizationManager mgr = FileSystemResourcesPlugin.getComponentSyncModel().getLocalSynchronizationManager();
        mgr.addGenericListener((Object)"loadedComponents", this.fSharedComponentsListener);
    }

    private void hookIfNeeded(IWorkspaceConnection connection) {
        if (!this.fHookedConnections.contains(connection)) {
            connection.addGenericListener((Object)"com.ibm.team.scm.PatchUpdate", this.fPortListener);
            connection.addGenericListener((Object)"com.ibm.team.scm.ConfigurationUpdate", this.fBasesListener);
            connection.addGenericListener((Object)"com.ibm.team.scm.ChangeHistoryEvent.AcceptChangeSets", this.fBasesListener);
            connection.addGenericListener((Object)"com.ibm.team.scm.ChangeHistoryEvent.AcceptCombined", this.fBasesListener);
            connection.addGenericListener((Object)"com.ibm.team.scm.ChangeHistoryEvent.CreateChangeSet", this.fBasesListener);
            connection.addGenericListener((Object)"com.ibm.team.scm.ChangeHistoryEvent.Deliver", this.fBasesListener);
            connection.addGenericListener((Object)"com.ibm.team.scm.ChangeHistoryEvent.DiscardChangeSet", this.fBasesListener);
            connection.addGenericListener((Object)"com.ibm.team.scm.Commit", this.fBasesListener);
            connection.addGenericListener((Object)"bases", this.fBasesListener);
            connection.addGenericListener((Object)"com.ibm.team.scm.LockEvent.ComponentsLocked", this.fLockListener);
            connection.teamRepository().itemManager().addItemChangeListener(IBaseline.ITEM_TYPE, this.fBasisItemChangeListener);
            this.fHookedConnections.add(connection);
        }
    }

    private void unhookConnections() {
        for (IWorkspaceConnection connection : this.fHookedConnections) {
            connection.removeGenericListener((Object)"com.ibm.team.scm.PatchUpdate", this.fPortListener);
            connection.removeGenericListener((Object)"com.ibm.team.scm.ConfigurationUpdate", this.fBasesListener);
            connection.removeGenericListener((Object)"com.ibm.team.scm.ChangeHistoryEvent.AcceptChangeSets", this.fBasesListener);
            connection.removeGenericListener((Object)"com.ibm.team.scm.ChangeHistoryEvent.AcceptCombined", this.fBasesListener);
            connection.removeGenericListener((Object)"com.ibm.team.scm.ChangeHistoryEvent.CreateChangeSet", this.fBasesListener);
            connection.removeGenericListener((Object)"com.ibm.team.scm.ChangeHistoryEvent.Deliver", this.fBasesListener);
            connection.removeGenericListener((Object)"com.ibm.team.scm.ChangeHistoryEvent.DiscardChangeSet", this.fBasesListener);
            connection.removeGenericListener((Object)"com.ibm.team.scm.Commit", this.fBasesListener);
            connection.removeGenericListener((Object)"bases", this.fBasesListener);
            connection.removeGenericListener((Object)"com.ibm.team.scm.LockEvent.ComponentsLocked", this.fLockListener);
            connection.teamRepository().itemManager().removeItemChangeListener(IBaseline.ITEM_TYPE, this.fBasisItemChangeListener);
        }
        this.fHookedConnections.clear();
    }

    public void dispose() {
        ILocalSynchronizationManager mgr = FileSystemResourcesPlugin.getComponentSyncModel().getLocalSynchronizationManager();
        mgr.removeGenericListener((Object)"loadedComponents", this.fSharedComponentsListener);
        this.unhookConnections();
        super.dispose();
    }

    @Override
    public IItem getSharedItemFor(Object element) {
        return ((AbstractWrapper)((Object)element)).getItem();
    }

    protected void doUpdateLabel(ViewerLabel label, Object element) {
        ImageDescriptor image = null;
        String componentShortLabel = null;
        String basisText = null;
        String gapResolutionText = null;
        String subcomponentMissingText = null;
        String subcomponentCycleText = null;
        if (element instanceof WorkspaceComponentWrapper) {
            WorkspaceComponentWrapper wrapper = (WorkspaceComponentWrapper)element;
            this.hookIfNeeded(wrapper.getWorkspaceConnection());
            image = this.computeImage(wrapper);
            componentShortLabel = WorkspaceComponentLabelProvider.computeShortLabel(wrapper);
            basisText = this.getBasisText(wrapper);
            gapResolutionText = this.getPendingGapResolutionText(wrapper);
            subcomponentMissingText = this.getSubcomponentMissingText(wrapper);
            subcomponentCycleText = WorkspaceComponentLabelProvider.getSubcomponentCycleText(wrapper);
            String lockText = this.getLockDecoratorText(wrapper);
            if (componentShortLabel != null) {
                String finalComponentLabel = componentShortLabel;
                if (lockText != null) {
                    finalComponentLabel = TextProcessor.process((String)NLS.bind((String)Messages.TeamPlaceLabelProvider_lockedByMessage, (Object)finalComponentLabel, (Object)lockText), (String)")(");
                }
                if (basisText != null) {
                    finalComponentLabel = NLS.bind((String)Messages.WorkspaceComponentLabelProvider_0, (Object)finalComponentLabel, (Object)basisText);
                }
                if (gapResolutionText != null) {
                    finalComponentLabel = NLS.bind((String)Messages.WorkspaceComponentLabelProvider_0, (Object)finalComponentLabel, (Object)gapResolutionText);
                }
                if (subcomponentMissingText != null) {
                    finalComponentLabel = NLS.bind((String)Messages.WorkspaceComponentLabelProvider_0, (Object)finalComponentLabel, (Object)subcomponentMissingText);
                }
                if (subcomponentCycleText != null) {
                    finalComponentLabel = NLS.bind((String)Messages.WorkspaceComponentLabelProvider_0, (Object)finalComponentLabel, (Object)subcomponentCycleText);
                }
                label.setText(finalComponentLabel);
                if (image != null) {
                    label.setImage((Image)this.getResources().get((DeviceResourceDescriptor)image));
                }
            }
        }
    }

    protected String getLockDecoratorText(WorkspaceComponentWrapper wrapper) {
        return null;
    }

    protected ImageDescriptor getLockImage(ImageDescriptor baseImage, WorkspaceComponentWrapper wrapper) {
        return baseImage;
    }

    public static String computeShortLabel(WorkspaceComponentWrapper wrapper) {
        return wrapper.getComponent().getName();
    }

    public static ImageDescriptor computeBasicImage(WorkspaceComponentWrapper wrapper) {
        return wrapper.isShared() ? ImagePool.COMPONENT : ImagePool.COMPONENT_UNLOADED;
    }

    public ImageDescriptor computeImage(WorkspaceComponentWrapper wrapper) {
        ImageDescriptor image = WorkspaceComponentLabelProvider.computeBasicImage(wrapper);
        if (Boolean.getBoolean("com.ibm.team.filesystem.ide.ui.showChangeSetsAfterBasisImageDecorator")) {
            boolean hasCycleDecoration;
            IDecoratorManager decoratorManager = PlatformUI.getWorkbench().getDecoratorManager();
            boolean bl = hasCycleDecoration = WorkspaceComponentLabelProvider.getSubcomponentCycleText(wrapper) != null && decoratorManager.getEnabled("com.ibm.team.internal.filesystem.ui.decorators.HierarchicalComponentDecorator");
            if (!hasCycleDecoration) {
                try {
                    boolean isDirty;
                    IWorkspaceConnection wc = wrapper.getWorkspaceConnection();
                    IComponent component = wrapper.getComponent();
                    if (!WorkspaceUtil.isDeleted(wc) && (isDirty = wc.getComponentInfo((IComponentHandle)component).isHierarchyDivergedFromBasis())) {
                        image = wrapper.isShared() ? ImagePool.COMPONENT_DIRTY : ImagePool.COMPONENT_UNLOADED_DIRTY;
                    }
                }
                catch (ComponentNotInWorkspaceException componentNotInWorkspaceException) {
                    // empty catch block
                }
            }
        }
        image = this.getLockImage(image, wrapper);
        return image;
    }

    private String getBasisText(WorkspaceComponentWrapper wrapper) {
        IComponent component;
        IWorkspaceConnection wc;
        block5: {
            wc = wrapper.getWorkspaceConnection();
            component = wrapper.getComponent();
            if (!WorkspaceUtil.isDeleted(wc)) break block5;
            return null;
        }
        try {
            IItem item;
            ICurrentComponentInfo info = wc.getComponentInfo((IComponentHandle)component);
            IBaselineHandle basisHandle = info.basis();
            if (basisHandle != null && (item = this.getItemFuture((IItemHandle)basisHandle, "basis", wrapper)) instanceof IBaseline) {
                boolean isDirty = info.isHierarchyDivergedFromBasis();
                IBaseline basis = (IBaseline)item;
                this.fComponentToBasisUUID.put(wrapper, basis.getItemId());
                if (isDirty) {
                    return NLS.bind((String)Messages.WorkspaceComponentLabelProvider_IS_DIRTY_DECORATOR, (Object)BaselineWrapper.getLabel(basis));
                }
                return BaselineWrapper.getLabel(basis);
            }
        }
        catch (ComponentNotInWorkspaceException componentNotInWorkspaceException) {
            // empty catch block
        }
        return null;
    }

    private String getPendingGapResolutionText(WorkspaceComponentWrapper wrapper) {
        try {
            IWorkspaceConnection workspace = wrapper.getWorkspaceConnection();
            IComponent component = wrapper.getComponent();
            if (workspace.getCurrentPatch((IComponentHandle)component) != null || workspace.getAcceptQueueSize((IComponentHandle)component) > 0L) {
                return Messages.WorkspaceComponentLabelProvider_PENDING_GAP_RESOLUTION_DECORATOR;
            }
        }
        catch (ComponentNotInWorkspaceException componentNotInWorkspaceException) {
            // empty catch block
        }
        return null;
    }

    private String getSubcomponentMissingText(WorkspaceComponentWrapper wrapper) {
        if (wrapper.getHierarchyData() != null) {
            try {
                boolean existsInWorkspace = wrapper.getWorkspaceConnection().containsComponent((IComponentHandle)wrapper.getComponent());
                if (!existsInWorkspace) {
                    return wrapper.getWorkspace().isStream() ? Messages.WorkspaceComponentLabelProvider_NOT_IN_STREAM_DECORATOR : Messages.WorkspaceComponentLabelProvider_NOT_IN_REPOSITORY_WORKSPACE_DECORATOR;
                }
            }
            catch (TeamRepositoryException teamRepositoryException) {
                // empty catch block
            }
        }
        return null;
    }

    public static String getSubcomponentCycleText(IConfigurationWrapper wrapper) {
        HierarchyData hierarchyData = wrapper.getHierarchyData();
        if (hierarchyData != null) {
            if (hierarchyData.isInCycle()) {
                return Messages.WorkspaceComponentLabelProvider_SUBCOMPONENT_CYCLE_DECORATOR;
            }
            if (hierarchyData.isBranchContainsCycles()) {
                return Messages.WorkspaceComponentLabelProvider_SUBCOMPONENT_CYCLE_IN_BRANCH_DECORATOR;
            }
        }
        return null;
    }
}

