/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.labelproviders;

import com.ibm.team.filesystem.client.internal.ClientRepositoryUtil;
import com.ibm.team.filesystem.ui.changes.views.DecorationImageDescriptor;
import com.ibm.team.filesystem.ui.wrapper.TeamPlaceWrapper;
import com.ibm.team.internal.filesystem.ui.ImagePool;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.labelproviders.SharedItemLabelProvider;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.repository.client.ISharedItemChangeEvent;
import com.ibm.team.repository.client.ISharedItemChangeListener;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.rcp.ui.internal.utils.SWTUtil;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.osgi.util.NLS;
import org.eclipse.osgi.util.TextProcessor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class TeamPlaceLabelProvider
extends SharedItemLabelProvider {
    private Image streamNotLockedImage;
    private Image streamLockedByMeImage;
    private Image streamLockedByOtherImage;
    private Set<ITeamRepository> hookedRepos = new HashSet<ITeamRepository>();
    private ISharedItemChangeListener teamAreasChangeListener = new ISharedItemChangeListener(){

        public void itemsChanged(List events) {
            for (ISharedItemChangeEvent event : events) {
                ITeamArea oldTeam = (ITeamArea)event.getBeforeState();
                final ITeamArea newTeam = (ITeamArea)event.getAfterState();
                if (oldTeam == null || newTeam == null || oldTeam.getName().equals(newTeam.getName())) continue;
                SWTUtil.greedyExec((Display)TeamPlaceLabelProvider.this.getDisplay(), (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        TeamPlaceLabelProvider.this.fireChangeEvent(TeamPlaceLabelProvider.this.getStreamsWithOwner(newTeam));
                    }
                });
            }
        }
    };

    public TeamPlaceLabelProvider() {
        this.streamNotLockedImage = this.getImage(ImagePool.STREAM);
        this.streamLockedByMeImage = this.getImage((ImageDescriptor)new DecorationImageDescriptor(ImagePool.STREAM, 20, 0));
        this.streamLockedByOtherImage = this.getImage((ImageDescriptor)new DecorationImageDescriptor(ImagePool.STREAM, 19, 0));
    }

    private Set getStreamsWithOwner(ITeamArea teamArea) {
        HashSet<TeamPlaceWrapper> result = new HashSet<TeamPlaceWrapper>();
        for (TeamPlaceWrapper wrapper : this.getKnownElements()) {
            if (!teamArea.sameItemId((IItemHandle)wrapper.getWorkspace().getOwner())) continue;
            result.add(wrapper);
        }
        return result;
    }

    public void doUpdateLabel(ViewerLabel label, Object element) {
        Image image = this.streamNotLockedImage;
        TeamPlaceWrapper wrapper = (TeamPlaceWrapper)((Object)element);
        String text = TeamPlaceLabelProvider.getElementText(wrapper);
        String owner = this.getOwnerName(wrapper);
        if (owner != null) {
            text = TextProcessor.process((String)NLS.bind((String)Messages.TeamPlaceLabelProvider_0, (Object)text, (Object)owner), (String)")(");
        }
        if (wrapper.isLocked()) {
            text = TextProcessor.process((String)NLS.bind((String)Messages.TeamPlaceLabelProvider_lockedByMessage, (Object)text, (Object)wrapper.getStreamLockOwnerLabel()), (String)")(");
            image = wrapper.isStreamLockedByMe() ? this.streamLockedByMeImage : this.streamLockedByOtherImage;
        }
        label.setText(text);
        label.setImage(image);
    }

    private String getOwnerName(TeamPlaceWrapper wrapper) {
        IItem item = this.getItemFuture((IItemHandle)wrapper.getWorkspace().getOwner(), "owner", (Object)wrapper);
        if (item instanceof IContributor) {
            IContributor contributor = (IContributor)item;
            return contributor.getName();
        }
        if (item instanceof IProcessArea) {
            IProcessArea teamArea = (IProcessArea)item;
            return teamArea.getName();
        }
        return null;
    }

    public static String getElementText(TeamPlaceWrapper obj) {
        return obj.getWorkspace().getName();
    }

    public static ImageDescriptor getElementImage(TeamPlaceWrapper element) {
        return ImagePool.STREAM;
    }

    public IItemType[] getAdditionalItemTypes() {
        return new IItemType[]{ITeamArea.ITEM_TYPE};
    }

    @Override
    protected IItem getSharedItemFor(Object element) {
        TeamPlaceWrapper wrapper = (TeamPlaceWrapper)((Object)element);
        return wrapper.getWorkspace();
    }

    @Override
    protected void elementAdded(Object obj) {
        super.elementAdded(obj);
        ITeamRepository repo = ClientRepositoryUtil.getRepository((IItemHandle)this.getSharedItemFor(obj));
        if (!this.hookedRepos.contains(repo)) {
            repo.itemManager().addItemChangeListener(ITeamArea.ITEM_TYPE, this.teamAreasChangeListener);
            this.hookedRepos.add(repo);
        }
    }

    public void dispose() {
        Iterator<ITeamRepository> i = this.hookedRepos.iterator();
        while (i.hasNext()) {
            ITeamRepository repo = i.next();
            repo.itemManager().removeItemChangeListener(ITeamArea.ITEM_TYPE, this.teamAreasChangeListener);
            i.remove();
        }
        super.dispose();
    }
}

