/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.labelproviders;

import com.ibm.team.filesystem.ui.wrapper.SymbolicLinkItemWrapper;
import com.ibm.team.internal.filesystem.ui.ImagePool;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.changes.CustomTreeViewer;
import com.ibm.team.repository.rcp.ui.internal.utils.BaseLabelProvider;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;

public class SymbolicLinkItemLabelProvider
extends BaseLabelProvider {
    private final boolean customMarkup;

    public SymbolicLinkItemLabelProvider() {
        this(false);
    }

    public SymbolicLinkItemLabelProvider(boolean customMarkup) {
        this.customMarkup = customMarkup;
    }

    public void updateLabel(ViewerLabel label, Object element) {
        SymbolicLinkItemWrapper symbolicLink = (SymbolicLinkItemWrapper)((Object)element);
        Image image = this.getImage(ImagePool.SYMBOLIC_LINK);
        label.setImage(image);
        String versionStr = null;
        switch (symbolicLink.getDisplayOption()) {
            case SHOW_VERSION_NUMBER: {
                versionStr = symbolicLink.getVersionNumber();
                break;
            }
            case SHOW_VERSION_ID: {
                versionStr = symbolicLink.getVersionId();
            }
        }
        if (versionStr == null) {
            label.setText(symbolicLink.getName());
        } else {
            versionStr = CustomTreeViewer.markupDecorations(versionStr, this.customMarkup);
            label.setText(NLS.bind((String)Messages.RepositoryFilesView_VersionIdLabel, (Object)symbolicLink.getName(), (Object)versionStr));
        }
    }
}

