/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.labelproviders;

import com.ibm.team.filesystem.ui.wrapper.AbstractWrapper;
import com.ibm.team.filesystem.ui.wrapper.RawSnapshotWrapper;
import com.ibm.team.internal.filesystem.ui.ImagePool;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.labelproviders.BaselineLabelProvider;
import com.ibm.team.internal.filesystem.ui.labelproviders.SharedItemLabelProvider;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.scm.common.IBaselineSet;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;

public class SnapshotLabelProvider
extends SharedItemLabelProvider {
    private boolean showDate;
    private Image baselineImage;

    public SnapshotLabelProvider() {
        this(false);
    }

    public SnapshotLabelProvider(boolean showDate) {
        this.showDate = showDate;
        this.baselineImage = this.getImage(ImagePool.SNAPSHOT);
    }

    public void doUpdateLabel(ViewerLabel label, Object element) {
        if (element instanceof RawSnapshotWrapper) {
            RawSnapshotWrapper wrapper = (RawSnapshotWrapper)((Object)element);
            label.setImage(this.baselineImage);
            label.setText(this.getText(wrapper));
        }
    }

    private String getText(RawSnapshotWrapper wrapper) {
        IBaselineSet bset = wrapper.getSnapshot();
        String text = bset.getName();
        String comment = bset.getComment();
        if (comment.length() > 0) {
            text = NLS.bind((String)Messages.SnapshotLabelProvider_0, (Object)text, (Object)comment);
        }
        if (this.showDate) {
            text = NLS.bind((String)Messages.SnapshotLabelProvider_1, (Object)text, (Object)BaselineLabelProvider.getDate(bset.getCreationDate()));
        }
        return text;
    }

    @Override
    public IItem getSharedItemFor(Object element) {
        return ((AbstractWrapper)((Object)element)).getItem();
    }
}

