/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.labelproviders;

import com.ibm.team.filesystem.client.internal.ClientRepositoryUtil;
import com.ibm.team.filesystem.ui.item.ItemListenerUtil;
import com.ibm.team.internal.filesystem.ui.util.AsyncItemFetcher;
import com.ibm.team.internal.filesystem.ui.util.FetchItemFuture;
import com.ibm.team.internal.filesystem.ui.util.IFetchItemListener;
import com.ibm.team.repository.client.ISharedItemChangeListener;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.internal.viewers.ISetWithListeners;
import com.ibm.team.repository.rcp.ui.labelproviders.ListeningLabelProvider;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.widgets.Display;

abstract class SharedItemLabelProvider
extends ListeningLabelProvider {
    private Map<ItemKey, List<Object>> mapItemsOntoElements = new HashMap<ItemKey, List<Object>>();
    private Map<Object, Entry> entries = new HashMap<Object, Entry>();
    private AsyncItemFetcher itemFetcher;

    public SharedItemLabelProvider() {
    }

    public SharedItemLabelProvider(ISetWithListeners knownElements, IOperationRunner operationRunner) {
        super(knownElements);
    }

    public SharedItemLabelProvider(ISetWithListeners itemsThatNeedLabels) {
        super(itemsThatNeedLabels);
    }

    protected abstract IItem getSharedItemFor(Object var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Collection getElements(IItemHandle handle) {
        List<Object> elements = null;
        Map<ItemKey, List<Object>> map = this.mapItemsOntoElements;
        synchronized (map) {
            elements = this.mapItemsOntoElements.get(new ItemKey(handle));
        }
        if (elements != null) {
            return elements;
        }
        return Collections.EMPTY_SET;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void elementAdded(Object element) {
        IItem item = this.getSharedItemFor(element);
        ItemKey itemKey = new ItemKey((IItemHandle)item);
        Map<ItemKey, List<Object>> map = this.mapItemsOntoElements;
        synchronized (map) {
            List<Object> elements = this.mapItemsOntoElements.get(itemKey);
            if (elements == null) {
                elements = new LinkedList<Object>();
                this.mapItemsOntoElements.put(itemKey, elements);
            }
            elements.add(element);
        }
        Entry entry = new Entry(element);
        this.entries.put(element, entry);
        ItemListenerUtil.addListener(item, entry.listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void elementRemoved(Object element) {
        IItem item = this.getSharedItemFor(element);
        ItemKey itemKey = new ItemKey((IItemHandle)item);
        Map<ItemKey, List<Object>> map = this.mapItemsOntoElements;
        synchronized (map) {
            List<Object> elements = this.mapItemsOntoElements.get(itemKey);
            if (elements != null) {
                elements.remove(element);
                if (elements.isEmpty()) {
                    this.mapItemsOntoElements.remove(itemKey);
                }
            }
        }
        Entry entry = this.entries.get(element);
        if (entry != null) {
            ItemListenerUtil.removeListener(item, entry.listener);
        }
    }

    private AsyncItemFetcher getItemFetcher() {
        if (this.itemFetcher == null) {
            this.itemFetcher = new AsyncItemFetcher(Display.getCurrent());
        }
        return this.itemFetcher;
    }

    protected IItem getItemFuture(IItemHandle itemHandle, String key, Object element) {
        Entry entry = this.entries.get(element);
        if (entry == null) {
            return null;
        }
        FetchItemFuture future = null;
        Map<String, FetchItemFuture> futures = entry.futures;
        if (futures != null) {
            future = futures.get(key);
        }
        if (future == null || !future.getHandle().sameItemId(itemHandle)) {
            ITeamRepository repo = ClientRepositoryUtil.getRepository((IItemHandle)itemHandle);
            future = this.getItemFetcher().fetch(repo, itemHandle, new ItemFetchListener(element));
            if (futures == null) {
                entry.futures = futures = new HashMap<String, FetchItemFuture>();
            }
            futures.put(key, future);
        }
        if (future.isDone()) {
            return future.getItem();
        }
        return null;
    }

    private class Entry {
        Object element;
        ISharedItemChangeListener listener;
        Map<String, FetchItemFuture> futures;

        Entry(Object element) {
            this.element = element;
            this.listener = new ISharedItemChangeListener(){

                public void itemsChanged(List events) {
                    SharedItemLabelProvider.this.fireChangeEvent(Collections.singletonList(Entry.this.element));
                }
            };
        }
    }

    private class ItemFetchListener
    implements IFetchItemListener {
        private Object element;

        public ItemFetchListener(Object element) {
            this.element = element;
        }

        @Override
        public void fetchDone(FetchItemFuture future) {
            SharedItemLabelProvider.this.fireChangeEvent(Collections.singletonList(this.element));
        }

        @Override
        public void fetchFailed(FetchItemFuture future, TeamRepositoryException e) {
            StatusUtil.log((Object)this, (String)("Item fetch for " + this.element + " failed in " + this), (Throwable)e);
        }
    }

    private static class ItemKey {
        ITeamRepository repo;
        UUID itemId;

        public ItemKey(IItemHandle handle) {
            this.repo = ClientRepositoryUtil.getRepository((IItemHandle)handle);
            this.itemId = handle.getItemId();
        }

        public int hashCode() {
            return this.repo.hashCode() * 31 + this.itemId.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ItemKey other = (ItemKey)obj;
            return this.repo.equals(other.repo) && this.itemId.equals((Object)other.itemId);
        }
    }
}

