/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.labelproviders;

import com.ibm.team.filesystem.ui.queries.RepositoryNode;
import com.ibm.team.internal.filesystem.ui.ImagePool;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.jface.labelProviders.TypeLabelProvider;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.swt.graphics.Image;

public class RepositoryNodeLabelProvider
extends TypeLabelProvider {
    private Image image = null;
    private Image imageDisconnected = null;

    public void updateLabel(ViewerLabel label, Object element) {
        if (!(element instanceof RepositoryNode)) {
            return;
        }
        RepositoryNode repoNode = (RepositoryNode)element;
        String repoName = repoNode.getName();
        int state = repoNode.getRepository().getState();
        int errorState = repoNode.getRepository().getErrorState();
        boolean repoOnline = true;
        if (errorState == 1 || errorState == 2) {
            repoName = String.valueOf(repoName) + " " + Messages.RepositoryNodeLabelProvider_0;
            repoOnline = false;
        } else if (state != 1) {
            repoName = String.valueOf(repoName) + " " + Messages.RepositoryNodeLabelProvider_0;
            repoOnline = false;
        }
        if (!repoOnline) {
            if (this.imageDisconnected == null) {
                this.imageDisconnected = this.getImage(ImagePool.REPOSITORY_WORKSPACES_DISABLED);
            }
            label.setImage(this.imageDisconnected);
        } else {
            if (this.image == null) {
                this.image = this.getImage(ImagePool.REPOSITORY_WORKSPACES);
            }
            label.setImage(this.image);
        }
        label.setText(repoName);
    }
}

