/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.labelproviders;

import com.ibm.team.filesystem.ui.wrapper.BaselineQueryWrapper;
import com.ibm.team.filesystem.ui.wrapper.ChangeSetQueryWrapper;
import com.ibm.team.filesystem.ui.wrapper.ComponentQueryWrapper;
import com.ibm.team.filesystem.ui.wrapper.LockQueryWrapper;
import com.ibm.team.filesystem.ui.wrapper.QueryItemWrapper;
import com.ibm.team.filesystem.ui.wrapper.SnapshotQueryWrapper;
import com.ibm.team.filesystem.ui.wrapper.WorkspaceQueryWrapper;
import com.ibm.team.internal.filesystem.ui.ImagePool;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.labelproviders.SharedItemLabelProvider;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.scm.common.IQueryItem;
import com.ibm.team.scm.common.dto.IItemSearchCriteria;
import com.ibm.team.scm.common.internal.dto.WorkspaceSearchCriteria;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.osgi.util.NLS;
import org.eclipse.osgi.util.TextProcessor;

public class QueryItemLabelProvider
extends SharedItemLabelProvider {
    @Override
    protected IItem getSharedItemFor(Object wrapper) {
        QueryItemWrapper queryWrapper = (QueryItemWrapper)((Object)wrapper);
        return queryWrapper.getQueryItem();
    }

    protected void doUpdateLabel(ViewerLabel label, Object element) {
        if (element instanceof QueryItemWrapper) {
            QueryItemWrapper wrapper = (QueryItemWrapper)((Object)element);
            IQueryItem query = wrapper.getQueryItem();
            String ownerName = this.getOwnerName(wrapper);
            if (ownerName != null) {
                String text = TextProcessor.process((String)NLS.bind((String)Messages.TeamPlaceLabelProvider_0, (Object)query.getName(), (Object)ownerName), (String)")(");
                label.setText(text);
            } else {
                label.setText(query.getName());
            }
            ImageDescriptor imageDescriptor = QueryItemLabelProvider.getImageDescriptor(wrapper);
            if (imageDescriptor != null) {
                label.setImage(this.getImage(imageDescriptor));
            }
        }
    }

    private String getOwnerName(QueryItemWrapper wrapper) {
        IItem item = this.getItemFuture((IItemHandle)wrapper.getQueryItem().getOwner(), "owner", (Object)wrapper);
        if (item instanceof IProcessArea) {
            IProcessArea teamArea = (IProcessArea)item;
            return teamArea.getName();
        }
        return null;
    }

    public static ImageDescriptor getImageDescriptor(QueryItemWrapper element) {
        if (element instanceof ChangeSetQueryWrapper) {
            return ImagePool.QUERY_CHANGE_SET;
        }
        if (element instanceof BaselineQueryWrapper) {
            return ImagePool.QUERY_BASELINE;
        }
        if (element instanceof ComponentQueryWrapper) {
            return ImagePool.QUERY_COMPONENT;
        }
        if (element instanceof LockQueryWrapper) {
            return ImagePool.QUERY_LOCK;
        }
        if (element instanceof SnapshotQueryWrapper) {
            return ImagePool.QUERY_SNAPSHOT;
        }
        if (element instanceof WorkspaceQueryWrapper) {
            WorkspaceSearchCriteria workspaceSearchCriteria;
            WorkspaceQueryWrapper workspaceQuery = (WorkspaceQueryWrapper)element;
            IItemSearchCriteria searchCriteria = workspaceQuery.getQueryItem().getSearchCriteria();
            if (searchCriteria instanceof WorkspaceSearchCriteria && 2 == (workspaceSearchCriteria = (WorkspaceSearchCriteria)searchCriteria).getWorkspaceKind()) {
                return ImagePool.QUERY_WORKSPACE;
            }
            return ImagePool.QUERY_STREAM;
        }
        return null;
    }
}

