/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.labelproviders;

import com.ibm.team.filesystem.rcp.core.internal.changes.ports.model.AbstractPortNode;
import com.ibm.team.filesystem.rcp.core.internal.changes.ports.model.CurrentPortNode;
import com.ibm.team.filesystem.rcp.core.internal.changes.ports.model.PendingPortNode;
import com.ibm.team.filesystem.ui.wrapper.ChangeSetWrapper;
import com.ibm.team.internal.filesystem.ui.ImagePool;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.labelproviders.DecoratedChangeSetLabelProvider;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.rcp.ui.internal.viewers.ConvertingLabelProvider;
import com.ibm.team.repository.rcp.ui.internal.viewers.ConvertingSet;
import com.ibm.team.repository.rcp.ui.internal.viewers.IConversion;
import com.ibm.team.repository.rcp.ui.internal.viewers.IDynamicFunction;
import com.ibm.team.repository.rcp.ui.internal.viewers.ISetWithListeners;
import com.ibm.team.repository.rcp.ui.labelproviders.ListeningLabelProvider;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.operations.JobRunner;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetSource;
import com.ibm.team.scm.common.ICurrentPatchInput;
import com.ibm.team.scm.common.IPatchChangeSetSource;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IViewerLabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.osgi.util.NLS;

public final class PortLabelProvider
extends ListeningLabelProvider {
    private IViewerLabelProvider fNestedLabelProvider;
    private IOperationRunner fOperationRunner;
    private ILabelProviderListener fLabelProviderListener = new ILabelProviderListener(){

        public void labelProviderChanged(LabelProviderChangedEvent event) {
            PortLabelProvider.this.fireChangeEvent(event.getElements());
        }
    };

    public PortLabelProvider() {
        this.fOperationRunner = new JobRunner(false);
        this.init();
    }

    public PortLabelProvider(ISetWithListeners knownElements, IOperationRunner operationRunner) {
        super(knownElements);
        this.fOperationRunner = operationRunner;
        this.init();
    }

    private void init() {
        ConvertingSet conversion = new ConvertingSet(this.getKnownElements(), (IConversion)new IConversion<AbstractPortNode, ChangeSetWrapper>(){

            public ChangeSetWrapper createAdapter(AbstractPortNode portNode) {
                ITeamRepository repo = portNode.getRepository();
                IChangeSet changeSet = null;
                if (portNode instanceof CurrentPortNode) {
                    changeSet = ((CurrentPortNode)portNode).getPortSourceChangeSet();
                }
                if (portNode instanceof PendingPortNode) {
                    changeSet = ((PendingPortNode)portNode).getSourceChangeSet();
                }
                if (changeSet != null) {
                    return new ChangeSetWrapper(repo, changeSet);
                }
                return null;
            }
        }, true);
        DecoratedChangeSetLabelProvider decoratedLabelProvider = new DecoratedChangeSetLabelProvider(Messages.DecoratedChangeSetLabelProvider_authorWorkItemComment, Messages.DecoratedChangeSetLabelProvider_authorWorkItem, Messages.DecoratedChangeSetLabelProvider_authorComment, Messages.DecoratedChangeSetLabelProvider_authorNone, false, (ISetWithListeners<ChangeSetWrapper>)conversion.getRange(), this.fOperationRunner);
        this.fNestedLabelProvider = new ConvertingLabelProvider((IViewerLabelProvider)decoratedLabelProvider, (IDynamicFunction)conversion);
        this.fNestedLabelProvider.addListener(this.fLabelProviderListener);
    }

    public void doUpdateLabel(ViewerLabel label, Object element) {
        if (element instanceof CurrentPortNode && ((CurrentPortNode)element).getPortSourceChangeSet() == null) {
            label.setText(Messages.LocalWorkspaceChangesViewLabelProvider_CURRENT_PORT_FOLDER_NODE_LABEL);
            label.setImage(this.getImage(ImagePool.PATCH_ICON));
        } else if (element instanceof PendingPortNode && ((PendingPortNode)element).getSourceChangeSet() == null) {
            label.setText(this.getDescription((PendingPortNode)element));
            label.setImage(this.getImage(ImagePool.PATCH_ICON));
        } else {
            this.fNestedLabelProvider.updateLabel(label, element);
        }
    }

    private String getDescription(PendingPortNode element) {
        ICurrentPatchInput input;
        IChangeSetSource portSource = element.getPortSource();
        if (portSource instanceof IPatchChangeSetSource && (input = ((IPatchChangeSetSource)portSource).getInput()) != null) {
            return this.getDescription(input);
        }
        return Messages.LocalWorkspaceChangesViewLabelProvider_CURRENT_PORT_FOLDER_NODE_LABEL;
    }

    private String getDescription(ICurrentPatchInput input) {
        if (input.getChanges().size() == 1) {
            return Messages.PortLabelProvider_0;
        }
        return NLS.bind((String)Messages.PortLabelProvider_1, (Object)input.getChanges().size());
    }

    public void dispose() {
        this.fNestedLabelProvider.removeListener(this.fLabelProviderListener);
        this.fNestedLabelProvider.dispose();
    }
}

